/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;

public class DatabaseSpecificEscape {
    private static final IEscape[] _escapes = new IEscape[]{new PostgreSQLEscape(), new MckoiSQLEscape()};

    public static String escapeSQL(String sql, ISQLDatabaseMetaData md) {
        for (int i = 0; i < _escapes.length; ++i) {
            if (!_escapes[i].productMatches(md)) continue;
            return _escapes[i].escapeSQL(sql);
        }
        return sql;
    }

    private static class MckoiSQLEscape
    implements IEscape {
        private MckoiSQLEscape() {
        }

        @Override
        public boolean productMatches(ISQLDatabaseMetaData md) {
            return DialectFactory.isMcKoi(md);
        }

        @Override
        public String escapeSQL(String sql) {
            return sql.replaceAll("\\\\", "\\\\\\\\");
        }
    }

    private static class PostgreSQLEscape
    implements IEscape {
        private PostgreSQLEscape() {
        }

        @Override
        public boolean productMatches(ISQLDatabaseMetaData md) {
            return DialectFactory.isPostgreSQL(md);
        }

        @Override
        public String escapeSQL(String sql) {
            return sql.replaceAll("\\\\", "\\\\\\\\");
        }
    }

    private static interface IEscape {
        public boolean productMatches(ISQLDatabaseMetaData var1);

        public String escapeSQL(String var1);
    }
}

