/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DTProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DataTypeJavaObject
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private boolean _isNullable;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeJavaObject.class);
    private DefaultColumnRenderer _renderer = DefaultColumnRenderer.getInstance();
    private static final String thisClassName = "net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeJavaObject";
    private static boolean propertiesAlreadyLoaded = false;
    private static boolean _readSQLJavaObject = true;

    public DataTypeJavaObject(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        DataTypeJavaObject.loadProperties();
    }

    private static void loadProperties() {
        if (!propertiesAlreadyLoaded) {
            _readSQLJavaObject = true;
            String readSQLJavaObjectString = DTProperties.get(thisClassName, "readSQLJavaObject");
            if (readSQLJavaObjectString != null && readSQLJavaObjectString.equals("false")) {
                _readSQLJavaObject = false;
            }
            propertiesAlreadyLoaded = true;
        }
    }

    @Override
    public String getClassName() {
        return "java.lang.String";
    }

    @Override
    public boolean areEqual(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj1.equals(obj2);
    }

    @Override
    public String renderObject(Object value) {
        return (String)this._renderer.renderObject(value);
    }

    @Override
    public boolean isEditableInCell(Object originalValue) {
        return false;
    }

    @Override
    public boolean needToReRead(Object originalValue) {
        return false;
    }

    @Override
    public JTextField getJTextField() {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeJavaObject.this._textComponent, evt, DataTypeJavaObject.this._table);
                    CellDataPopup.showDialog(DataTypeJavaObject.this._table, DataTypeJavaObject.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    @Override
    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        return null;
    }

    @Override
    public boolean useBinaryEditingPanel() {
        return false;
    }

    @Override
    public boolean isEditableInPopup(Object originalValue) {
        return false;
    }

    @Override
    public JTextArea getJTextArea(Object value) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText(this.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    @Override
    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    @Override
    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        String data = null;
        if (_readSQLJavaObject) {
            try {
                Object value = rs.getObject(index);
                if (value == null || value instanceof Number || value instanceof String || value instanceof Date || value instanceof URL) {
                    data = value + "";
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (data == null) {
                data = s_stringMgr.getString("DataTypeUnknown.unknown", this._colDef.getSqlType());
            }
        } else {
            data = s_stringMgr.getString("DataTypeUnknown.unknown", this._colDef.getSqlType());
        }
        if (rs.wasNull()) {
            return null;
        }
        return data;
    }

    @Override
    public String getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (value == null || value.toString() == null) {
            return this._colDef.getLabel() + " IS NULL";
        }
        return this._colDef.getLabel() + "='" + value.toString() + "'";
    }

    @Override
    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            pstmt.setString(position, (String)value);
        }
    }

    @Override
    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return null;
    }

    @Override
    public boolean canDoFileIO() {
        return false;
    }

    @Override
    public String importObject(FileInputStream inStream) throws IOException {
        throw new IOException("Can not import data type JAVA_OBJECT");
    }

    @Override
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        throw new IOException("Can not export data type JAVA_OBJECT");
    }

    public static OkJPanel getControlPanel() {
        DataTypeJavaObject.loadProperties();
        return new SQLJavaObjectOkJPanel();
    }

    private static class SQLJavaObjectOkJPanel
    extends OkJPanel {
        private static final long serialVersionUID = 1353928067985854545L;
        private JCheckBox _showSQLJavaObjectChk = new JCheckBox(DataTypeJavaObject.access$300().getString("dataTypeJavaObject.readContentsWhenLoaded"));

        public SQLJavaObjectOkJPanel() {
            this._showSQLJavaObjectChk.setSelected(_readSQLJavaObject);
            this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("dataTypeJavaObject.sqlJavaObjectType")));
            this.add(this._showSQLJavaObjectChk);
        }

        @Override
        public void ok() {
            _readSQLJavaObject = this._showSQLJavaObjectChk.isSelected();
            DTProperties.put(DataTypeJavaObject.thisClassName, "readSQLJavaObject", Boolean.valueOf(_readSQLJavaObject).toString());
        }
    }

    private class KeyTextHandler
    extends KeyAdapter {
        private KeyTextHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeJavaObject.this._textComponent);
            e.consume();
            DataTypeJavaObject.this._beepHelper.beep(_theComponent);
        }
    }
}

