/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetTableControls;
import net.sourceforge.squirrel_sql.fw.datasetviewer.RowNumberTableColumn;

public final class MyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5511368149198548935L;
    private List<Object[]> _data = new ArrayList<Object[]>();
    private ColumnDisplayDefinition[] _colDefs = new ColumnDisplayDefinition[0];
    private IDataSetTableControls _creator = null;

    MyTableModel(IDataSetTableControls creator) {
        this._creator = creator;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == -42) {
            return false;
        }
        if (this._creator.needToReRead(col, this.getValueAt(row, col))) {
            StringBuffer message = new StringBuffer();
            Object newValue = this._creator.reReadDatum(this._data.get(row), col, message);
            if (message.length() > 0) {
                return false;
            }
            this._data.get((int)row)[col] = newValue;
        }
        return this._creator.isColumnEditable(col, this.getValueAt(row, col));
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (-42 == col) {
            return row + 1;
        }
        return this._data.get(row)[col];
    }

    @Override
    public int getRowCount() {
        return this._data.size();
    }

    @Override
    public int getColumnCount() {
        return this._colDefs != null ? this._colDefs.length : 0;
    }

    @Override
    public String getColumnName(int col) {
        if (col == -42) {
            return RowNumberTableColumn.ROW_NUMBER_HEADER;
        }
        return this._colDefs != null ? this._colDefs[col].getLabel() : super.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        try {
            if (this._colDefs == null) {
                return Object.class;
            }
            return Class.forName(this._colDefs[col].getClassName());
        }
        catch (Exception e) {
            return null;
        }
    }

    void setHeadings(ColumnDisplayDefinition[] hdgs) {
        this._colDefs = hdgs;
    }

    public void addRow(Object[] row) {
        this._data.add(row);
    }

    void clear() {
        this._data.clear();
    }

    public void allRowsAdded() {
        this.fireTableStructureChanged();
    }

    @Override
    public void setValueAt(Object newValue, int row, int col) {
        int[] colsToUpdate = this._creator.changeUnderlyingValueAt(row, col, newValue, this.getValueAt(row, col));
        for (int i = 0; i < colsToUpdate.length; ++i) {
            this._data.get((int)row)[colsToUpdate[i]] = newValue;
        }
    }

    public void deleteRows(int[] rows) {
        if (rows.length == 0) {
            return;
        }
        Arrays.sort(rows);
        for (int i = rows.length - 1; i >= 0; --i) {
            if (rows[i] >= this._data.size()) continue;
            this._data.remove(rows[i]);
        }
        this.fireTableDataChanged();
    }
}

