/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class JavabeanArrayDataSet
implements IDataSet {
    private final ILogger s_log = LoggerController.createLogger(JavabeanArrayDataSet.class);
    private Object[] _currentRow;
    private List<Object[]> _data;
    private Iterator<Object[]> _dataIter;
    private int _columnCount;
    private DataSetDefinition _dataSetDefinition;

    public JavabeanArrayDataSet(Object[] beans) throws DataSetException {
        this.setJavabeanArray(beans);
    }

    @Override
    public final int getColumnCount() {
        return this._columnCount;
    }

    @Override
    public DataSetDefinition getDataSetDefinition() {
        return this._dataSetDefinition;
    }

    @Override
    public synchronized boolean next(IMessageHandler msgHandler) throws DataSetException {
        if (this._dataIter.hasNext()) {
            this._currentRow = this._dataIter.next();
            return true;
        }
        return false;
    }

    @Override
    public synchronized Object get(int columnIndex) {
        return this._currentRow[columnIndex];
    }

    protected Object executeGetter(Object bean, Method getter) throws InvocationTargetException, IllegalAccessException {
        return getter.invoke(bean, (Object[])null);
    }

    private void setJavabeanArray(Object[] beans) throws DataSetException {
        if (beans == null) {
            beans = new Object[]{};
        }
        if (beans.length > 0) {
            BeanInfo info = null;
            try {
                info = Introspector.getBeanInfo(beans[0].getClass(), 1);
                this.validateBeans(beans);
                this.initialize(info);
            }
            catch (IntrospectionException ex) {
                throw new DataSetException(ex);
            }
            try {
                for (int i = 0; i < beans.length; ++i) {
                    this.processBeanInfo(beans[i], info);
                }
            }
            catch (Exception ex) {
                throw new DataSetException(ex);
            }
            this._dataIter = this._data.iterator();
        }
    }

    private void processBeanInfo(Object bean, BeanInfo info) throws InvocationTargetException, IllegalAccessException {
        PropertyDescriptor[] propDesc = info.getPropertyDescriptors();
        Object[] line = new Object[propDesc.length];
        for (int i = 0; i < propDesc.length; ++i) {
            Method getter = propDesc[i].getReadMethod();
            if (getter == null) continue;
            line[i] = this.executeGetter(bean, getter);
        }
        if (line != null) {
            this._data.add(line);
        }
    }

    private void validateBeans(Object[] beans) throws IllegalArgumentException {
        if (beans.length > 0) {
            String className = beans[0].getClass().getName();
            for (int i = 1; i < beans.length; ++i) {
                if (beans[i].getClass().getName().equals(className)) continue;
                throw new IllegalArgumentException("All beans must be the same Class");
            }
        }
    }

    private void initialize(BeanInfo info) {
        this._data = new ArrayList<Object[]>();
        ColumnDisplayDefinition[] colDefs = this.createColumnDefinitions(info, null);
        this._dataSetDefinition = new DataSetDefinition(colDefs);
        this._columnCount = this._dataSetDefinition.getColumnDefinitions().length;
    }

    private ColumnDisplayDefinition[] createColumnDefinitions(BeanInfo info, int[] columnWidths) {
        PropertyDescriptor[] propDesc = info.getPropertyDescriptors();
        ColumnDisplayDefinition[] columnDefs = new ColumnDisplayDefinition[propDesc.length];
        for (int i = 0; i < propDesc.length; ++i) {
            int colWidth = columnWidths != null && columnWidths.length >= i ? columnWidths[i] : 200;
            columnDefs[i] = new ColumnDisplayDefinition(colWidth, propDesc[i].getDisplayName());
        }
        return columnDefs;
    }
}

