/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLLeafNodeConstructor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.TextImpl;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class XSLText
extends XSLLeafNodeConstructor {
    private boolean disable = false;
    private StringValue value;

    public void prepareAttributes() throws XPathException {
        String disableAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("disable-output-escaping")) {
                disableAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (disableAtt != null) {
            this.disable = this.processBooleanAttribute("disable-output-escaping", disableAtt);
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        this.value = StringValue.EMPTY_STRING;
        while ((child = kids.next()) != null) {
            if (child instanceof StyleElement) {
                ((StyleElement)child).compileError("xsl:text must not contain child elements", "XTSE0010");
                return;
            }
            this.value = StringValue.makeStringValue(child.getStringValueCS());
        }
        super.validate(decl);
    }

    protected String getErrorCodeForSelectPlusContent() {
        return null;
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        if (this.isExpandingText()) {
            TextImpl child = (TextImpl)this.iterateAxis((byte)3).next();
            if (child != null) {
                ArrayList<Expression> contents = new ArrayList<Expression>(10);
                this.getCompilation().getStyleNodeFactory(true).compileContentValueTemplate(child, contents);
                Expression block = Block.makeBlock(contents);
                block.setLocation(this.allocateLocation());
                return block;
            }
            return new ValueOf(new StringLiteral(StringValue.EMPTY_STRING), this.disable, false);
        }
        return new ValueOf(Literal.makeLiteral(this.value), this.disable, false);
    }
}

