/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.evpull.ComplexContentProcessor;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventIteratorToReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.UpdateAgent;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQueryExpression
implements Location {
    protected Expression expression;
    protected SlotManager stackFrameMap;
    protected Executable executable;
    protected QueryModule mainModule;

    public XQueryExpression(Expression exp, QueryModule mainModule, boolean streaming) throws XPathException {
        Executable exec = mainModule.getExecutable();
        Configuration config = mainModule.getConfiguration();
        this.stackFrameMap = config.makeSlotManager();
        this.executable = exec;
        this.mainModule = mainModule;
        exp.setRetainedStaticContext(mainModule.makeRetainedStaticContext());
        Optimizer optimizer = config.obtainOptimizer();
        try {
            ExpressionVisitor visitor = ExpressionVisitor.make(mainModule);
            visitor.setOptimizeForStreaming(streaming);
            exp = exp.simplify();
            exp.checkForUpdatingSubexpressions();
            ContextItemStaticInfo cit = new ContextItemStaticInfo(mainModule.getUserQueryContext().getRequiredContextItemType(), true);
            Expression e2 = exp.typeCheck(visitor, cit);
            if (e2 != exp) {
                e2.setRetainedStaticContext(exp.getRetainedStaticContext());
                exp = e2;
            }
            if (optimizer.getOptimizationLevel() != 0 && (e2 = exp.optimize(visitor, cit)) != exp) {
                e2.setRetainedStaticContext(exp.getRetainedStaticContext());
                exp = e2;
            }
        }
        catch (XPathException err) {
            mainModule.reportStaticError(err);
            throw err;
        }
        ExpressionTool.allocateSlots(exp, 0, this.stackFrameMap);
        this.expression = exp;
        this.executable.setConfiguration(config);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public PackageData getPackageData() {
        return this.mainModule.getPackageData();
    }

    public Configuration getConfiguration() {
        return this.mainModule.getConfiguration();
    }

    public boolean usesContextItem() {
        if (ExpressionTool.dependsOnFocus(this.expression)) {
            return true;
        }
        List<GlobalVariable> map = this.getPackageData().getGlobalVariableList();
        if (map != null) {
            for (GlobalVariable var : map) {
                Expression select = var.getSelectExpression();
                if (select == null || !ExpressionTool.dependsOnFocus(select)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUpdateQuery() {
        return false;
    }

    public SlotManager getStackFrameMap() {
        return this.stackFrameMap;
    }

    public void explainPathMap() {
    }

    public QueryModule getMainModule() {
        return this.mainModule;
    }

    public StructuredQName[] getExternalVariableNames() {
        List<StructuredQName> list = this.stackFrameMap.getVariableMap();
        StructuredQName[] names = new StructuredQName[this.stackFrameMap.getNumberOfVariables()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = list.get(i);
        }
        return names;
    }

    public List<Object> evaluate(DynamicQueryContext env) throws XPathException {
        Item item;
        if (this.isUpdateQuery()) {
            throw new XPathException("Cannot call evaluate() on an updating query");
        }
        SequenceIterator iterator = this.iterator(env);
        ArrayList<Object> list = new ArrayList<Object>(100);
        while ((item = iterator.next()) != null) {
            list.add(SequenceTool.convertToJava(item));
        }
        return list;
    }

    public Object evaluateSingle(DynamicQueryContext env) throws XPathException {
        if (this.isUpdateQuery()) {
            throw new XPathException("Cannot call evaluateSingle() on an updating query");
        }
        SequenceIterator iterator = this.iterator(env);
        Item item = iterator.next();
        if (item == null) {
            return null;
        }
        return SequenceTool.convertToJava(item);
    }

    public SequenceIterator iterator(DynamicQueryContext env) throws XPathException {
        if (this.isUpdateQuery()) {
            throw new XPathException("Cannot call iterator() on an updating query");
        }
        if (!env.getConfiguration().isCompatible(this.getExecutable().getConfiguration())) {
            throw new XPathException("The query must be compiled and executed under the same Configuration", "SXXP0004");
        }
        Controller controller = this.newController(env);
        try {
            Item contextItem = controller.getGlobalContextItem();
            if (contextItem instanceof NodeInfo && ((NodeInfo)contextItem).getTreeInfo().isTyped() && !this.getExecutable().isSchemaAware()) {
                throw new XPathException("A typed input document can only be used with a schema-aware query");
            }
            XPathContextMajor context = this.initialContext(env, controller);
            if (controller.getTraceListener() != null) {
                controller.preEvaluateGlobals(context);
            }
            context.openStackFrame(this.stackFrameMap);
            SequenceIterator iterator = this.expression.iterate(context);
            if ((iterator.getProperties() & 1) != 0) {
                return iterator;
            }
            return new ErrorReportingIterator(iterator, controller.getErrorListener());
        }
        catch (XPathException err) {
            TransformerException terr = err;
            while (terr.getException() instanceof TransformerException) {
                terr = (TransformerException)terr.getException();
            }
            XPathException de = XPathException.makeXPathException(terr);
            controller.reportFatalError(de);
            throw de;
        }
    }

    public void run(DynamicQueryContext env, Result result, Properties outputProperties) throws XPathException {
        OutputStream os;
        SequenceReceiver out;
        boolean mustClose;
        if (this.isUpdateQuery()) {
            throw new XPathException("Cannot call run() on an updating query");
        }
        if (!env.getConfiguration().isCompatible(this.getExecutable().getConfiguration())) {
            throw new XPathException("The query must be compiled and executed under the same Configuration", "SXXP0004");
        }
        Item contextItem = env.getContextItem();
        if (contextItem instanceof NodeInfo && ((NodeInfo)contextItem).getTreeInfo().isTyped() && !this.getExecutable().isSchemaAware()) {
            throw new XPathException("A typed input document can only be used with a schema-aware query");
        }
        Controller controller = this.newController(env);
        if (result instanceof Receiver) {
            ((Receiver)result).getPipelineConfiguration().setController(controller);
        }
        Properties actualProperties = this.validateOutputProperties(controller, outputProperties);
        XPathContextMajor context = this.initialContext(env, controller);
        TraceListener tracer = controller.getTraceListener();
        if (tracer != null) {
            controller.preEvaluateGlobals(context);
        }
        context.openStackFrame(this.stackFrameMap);
        boolean bl = mustClose = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        if (result instanceof SequenceReceiver) {
            out = (SequenceReceiver)result;
        } else {
            SerializerFactory sf = context.getConfiguration().getSerializerFactory();
            PipelineConfiguration pipe = controller.makePipelineConfiguration();
            pipe.setHostLanguage(51);
            out = sf.getReceiver(result, pipe, actualProperties);
        }
        context.setReceiver(out);
        out.open();
        try {
            this.expression.process(context);
        }
        catch (XPathException err) {
            controller.reportFatalError(err);
            throw err;
        }
        if (tracer != null) {
            tracer.close();
        }
        out.close();
        if (mustClose && (os = ((StreamResult)result).getOutputStream()) != null) {
            try {
                os.close();
            }
            catch (IOException err) {
                throw new XPathException(err);
            }
        }
    }

    public void runStreamed(DynamicQueryContext dynamicEnv, Source source, Result result, Properties outputProperties) throws XPathException {
        throw new XPathException("Streaming requires Saxon-EE");
    }

    protected Properties validateOutputProperties(Controller controller, Properties outputProperties) throws XPathException {
        Properties baseProperties = controller.getExecutable().getDefaultOutputProperties();
        if (outputProperties != null) {
            Enumeration<?> iter = outputProperties.propertyNames();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                String value = outputProperties.getProperty(key);
                try {
                    value = SaxonOutputKeys.checkOutputProperty(key, value, controller.getConfiguration(), true);
                    baseProperties.setProperty(key, value);
                }
                catch (XPathException dynamicError) {
                    outputProperties.remove(key);
                    controller.getErrorListener().warning(dynamicError);
                }
            }
        }
        if (baseProperties.getProperty("method") == null) {
            baseProperties.setProperty("method", "xml");
        }
        return baseProperties;
    }

    public void pull(DynamicQueryContext dynamicEnv, Result destination, Properties outputProperties) throws XPathException {
        if (this.isUpdateQuery()) {
            throw new XPathException("Cannot call pull() on an updating query");
        }
        Configuration config = dynamicEnv.getConfiguration();
        try {
            Controller controller = this.newController(dynamicEnv);
            Properties actualProperties = this.validateOutputProperties(controller, outputProperties);
            SerializerFactory sf = config.getSerializerFactory();
            PipelineConfiguration pipe = config.makePipelineConfiguration();
            SequenceReceiver receiver = sf.getReceiver(destination, pipe, actualProperties);
            if ("yes".equals(actualProperties.getProperty("{http://saxon.sf.net/}wrap-result-sequence"))) {
                receiver = config.getSerializerFactory().newSequenceWrapper(receiver);
            }
            EventIterator iter = this.internalIterateEvents(controller, dynamicEnv);
            EventIteratorToReceiver.copy(iter, receiver);
        }
        catch (XPathException err) {
            config.reportFatalError(err);
            throw err;
        }
    }

    public void pull(DynamicQueryContext dynamicEnv, SequenceReceiver destination) throws XPathException {
        if (this.isUpdateQuery()) {
            throw new XPathException("Cannot call pull() on an updating query");
        }
        Configuration config = dynamicEnv.getConfiguration();
        try {
            Controller controller = this.newController(dynamicEnv);
            EventIterator iter = this.internalIterateEvents(controller, dynamicEnv);
            EventIteratorToReceiver.copy(iter, destination);
        }
        catch (XPathException err) {
            config.reportFatalError(err);
            throw err;
        }
    }

    public EventIterator iterateEvents(Controller controller, DynamicQueryContext dynamicEnv) throws XPathException {
        if (this.isUpdateQuery()) {
            throw new XPathException("Cannot call iterateEvents() on an updating query");
        }
        dynamicEnv.initializeController(controller);
        return this.internalIterateEvents(controller, dynamicEnv);
    }

    private EventIterator internalIterateEvents(Controller controller, DynamicQueryContext dynamicEnv) throws XPathException {
        XPathContextMajor context = this.initialContext(dynamicEnv, controller);
        if (controller.getTraceListener() != null) {
            controller.preEvaluateGlobals(context);
        }
        context.openStackFrame(this.stackFrameMap);
        Configuration config = this.executable.getConfiguration();
        EventIterator ei = this.expression.iterateEvents(context);
        return new ComplexContentProcessor(config, ei);
    }

    public Set<MutableNodeInfo> runUpdate(DynamicQueryContext dynamicEnv) throws XPathException {
        throw new XPathException("Calling runUpdate() on a non-updating query");
    }

    public void runUpdate(DynamicQueryContext dynamicEnv, UpdateAgent agent) throws XPathException {
        throw new XPathException("Calling runUpdate() on a non-updating query");
    }

    protected XPathContextMajor initialContext(DynamicQueryContext dynamicEnv, Controller controller) throws XPathException {
        Item contextItem = controller.getGlobalContextItem();
        XPathContextMajor context = controller.newXPathContext();
        if (contextItem != null) {
            ManualIterator single = new ManualIterator(contextItem);
            context.setCurrentIterator(single);
            controller.setGlobalContextItem(contextItem);
        }
        return context;
    }

    public Controller newController(DynamicQueryContext env) throws XPathException {
        Controller controller = new Controller(this.executable.getConfiguration(), this.executable);
        env.initializeController(controller);
        return controller;
    }

    public void explain(ExpressionPresenter out) throws XPathException {
        out.startElement("query");
        this.getExecutable().getKeyManager().exportKeys(out, null);
        this.getExecutable().explainGlobalVariables(out);
        this.mainModule.explainGlobalFunctions(out);
        out.startElement("body");
        this.expression.export(out);
        out.endElement();
        out.endElement();
        out.close();
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setAllowDocumentProjection(boolean allowed) {
        if (allowed) {
            throw new UnsupportedOperationException("Document projection requires Saxon-EE");
        }
    }

    public boolean isDocumentProjectionAllowed() {
        return false;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return this.mainModule.getSystemId();
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public Location saveLocation() {
        return this;
    }

    public int getHostLanguage() {
        return 51;
    }

    private class ErrorReportingIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private UnfailingErrorListener listener;

        public ErrorReportingIterator(SequenceIterator base, UnfailingErrorListener listener) {
            this.base = base;
            this.listener = listener;
        }

        public Item next() throws XPathException {
            try {
                return this.base.next();
            }
            catch (XPathException e1) {
                e1.maybeSetLocation(XQueryExpression.this.expression.getLocation());
                this.listener.fatalError(e1);
                e1.setHasBeenReported(true);
                throw e1;
            }
        }

        public void close() {
            this.base.close();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new ErrorReportingIterator(this.base.getAnother(), this.listener);
        }

        public int getProperties() {
            return 0;
        }
    }
}

