/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;

public class MapPut
extends ExtensionFunctionDefinition {
    public static final StructuredQName FUNCTION_NAME = new StructuredQName("map", "http://www.w3.org/2005/xpath-functions/map", "put");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 57344), SequenceType.SINGLE_ATOMIC, SequenceType.ANY_SEQUENCE};

    public StructuredQName getFunctionQName() {
        return FUNCTION_NAME;
    }

    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return HashTrieMap.SINGLE_MAP_TYPE;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new MapMergeCall();
    }

    private class MapMergeCall
    extends ExtensionFunctionCall {
        boolean selfContained = false;

        private MapMergeCall() {
        }

        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
            this.selfContained = !ExpressionTool.refersToVariableOrFunction(arguments[0]);
        }

        public void copyLocalData(ExtensionFunctionCall destination) {
            ((MapMergeCall)destination).selfContained = this.selfContained;
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            MapItem baseMap = (MapItem)arguments[0].head();
            if (!(baseMap instanceof HashTrieMap)) {
                baseMap = HashTrieMap.copy(baseMap, context);
            }
            AtomicValue key = (AtomicValue)arguments[1].head();
            Sequence value = SequenceTool.makeRepeatable(arguments[2]);
            KeyValuePair pair = new KeyValuePair(key, value);
            return ((HashTrieMap)baseMap).addEntry(pair.key, pair.value);
        }
    }
}

