/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.event.DocumentValidator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.json.JsonReceiver;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class XMLToJsonFn
extends SystemFunction {
    private static final Map<String, SequenceType> requiredTypes = new HashMap<String, SequenceType>(20);
    private static String[] optionNames;

    private void error(String message, String code) throws XPathException {
        throw new XPathException(message, code);
    }

    private static boolean isOptionName(String string) {
        for (String s : optionNames) {
            if (!s.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static MapItem checkOptions(MapItem map, XPathContext context) throws XPathException {
        AtomicValue key;
        HashTrieMap result = new HashTrieMap(context);
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        AtomicIterator keysIterator = map.keys();
        while ((key = keysIterator.next()) != null && key instanceof StringValue) {
            String keyName = key.getStringValue();
            if (!XMLToJsonFn.isOptionName(keyName)) continue;
            RoleDiagnostic role = new RoleDiagnostic(15, keyName, 0);
            role.setErrorCode("XPTY0004");
            Sequence converted = th.applyFunctionConversionRules(map.get(key), requiredTypes.get(keyName), role, ExplicitLocation.UNKNOWN_LOCATION);
            converted = SequenceTool.toGroundedValue(converted);
            result = result.addEntry(key, converted);
        }
        return result;
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NodeInfo xml = (NodeInfo)arguments[0].head();
        if (xml == null) {
            return EmptySequence.getInstance();
        }
        MapItem options = this.getArity() == 2 ? (MapItem)arguments[1].head() : new HashTrieMap(context);
        boolean indent = false;
        Sequence val = (options = XMLToJsonFn.checkOptions(options, context)).get(new StringValue("indent"));
        if (val != null) {
            indent = ExpressionTool.effectiveBooleanValue(val.head());
        }
        PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
        JsonReceiver receiver = new JsonReceiver(pipe);
        receiver.setIndenting(indent);
        Receiver r = receiver;
        if (xml.getNodeKind() == 9) {
            r = new DocumentValidator(r, "FOJS0006");
        }
        StartTagBuffer stb = new StartTagBuffer(r);
        pipe.setComponent(StartTagBuffer.class.getName(), stb);
        stb.setPipelineConfiguration(pipe);
        stb.open();
        xml.copy(stb, 0, ExplicitLocation.UNKNOWN_LOCATION);
        stb.close();
        return new StringValue(receiver.getJsonString());
    }

    private String getOption(MapItem options, String option, XPathContext context, String defaultValue) throws XPathException {
        StringValue ov = new StringValue(option);
        Sequence val = options.get(ov);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof AtomicValue) {
            return ((AtomicValue)val).getStringValue();
        }
        this.error("Value of option '" + option + "' is not xs:string", "XXJJ9999");
        return defaultValue;
    }

    private boolean getOption(MapItem options, String option, XPathContext context, boolean defaultValue) throws XPathException {
        StringValue ov = new StringValue(option);
        Sequence val = options.get(ov);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof BooleanValue) {
            return ((BooleanValue)val).getBooleanValue();
        }
        this.error("Value of option '" + option + "' is not xs:boolean", "XXJJ9999");
        return defaultValue;
    }

    static {
        requiredTypes.put("indent", SequenceType.SINGLE_BOOLEAN);
        optionNames = new String[]{"indent"};
    }
}

