/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.ComponentBinding;
import net.sf.saxon.expr.instruct.ComponentCode;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Component<T extends ComponentCode> {
    private T code;
    private Visibility visibility;
    private List<ComponentBinding> bindings = new ArrayList<ComponentBinding>();
    private StylesheetPackage containingPackage;
    private StylesheetPackage declaringPackage;
    private boolean hasExplicitVisibility;
    private Component<? extends T> baseComponent;

    public Component(T code, Visibility visibility, StylesheetPackage containingPackage, StylesheetPackage declaringPackage) {
        this.code = code;
        this.visibility = visibility;
        this.containingPackage = containingPackage;
        this.declaringPackage = declaringPackage;
    }

    public List<ComponentBinding> getComponentBindings() {
        return this.bindings;
    }

    public void setComponentBindings(List<ComponentBinding> bindings) {
        this.bindings = bindings;
    }

    public void setVisibility(Visibility visibility, boolean explicit) {
        this.visibility = visibility;
        this.hasExplicitVisibility = explicit;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isVisibilityExplicit() {
        return this.hasExplicitVisibility;
    }

    public T getCode() {
        return this.code;
    }

    public StylesheetPackage getDeclaringPackage() {
        return this.declaringPackage;
    }

    public StylesheetPackage getContainingPackage() {
        return this.containingPackage;
    }

    public Component<? extends T> getBaseComponent() {
        return this.baseComponent;
    }

    public void setBaseComponent(Component<? extends T> original) {
        this.baseComponent = original;
    }

    public void export(ExpressionPresenter out, Map<Component, Integer> componentIdMap) throws XPathException {
        out.startElement("co");
        int id = this.obtainComponentId(this, componentIdMap);
        out.emitAttribute("id", "" + id);
        if (this.getVisibility() != null && this.getVisibility() != Visibility.PRIVATE) {
            out.emitAttribute("vis", this.getVisibility().toString());
        }
        String refs = this.listComponentReferences(componentIdMap).toString();
        out.emitAttribute("binds", refs);
        if (this.baseComponent != null) {
            int baseId = this.obtainComponentId(this.baseComponent, componentIdMap);
            out.emitAttribute("base", "" + baseId);
        }
        if (!this.declaringPackage.equals(this.containingPackage)) {
            out.emitAttribute("dpack", this.declaringPackage.getPackageName());
        } else {
            ((ComponentCode)this.code).export(out);
        }
        out.endElement();
    }

    public String listComponentReferences(Map<Component, Integer> componentIdMap) {
        FastStringBuffer fsb = new FastStringBuffer(128);
        for (ComponentBinding ref : this.getComponentBindings()) {
            Component target = ref.getTarget();
            int targetId = this.obtainComponentId(target, componentIdMap);
            if (fsb.length() != 0) {
                fsb.append(" ");
            }
            fsb.append("" + targetId);
        }
        return fsb.toString();
    }

    private int obtainComponentId(Component component, Map<Component, Integer> componentIdMap) {
        Integer id = componentIdMap.get(component);
        if (id == null) {
            id = componentIdMap.size();
            componentIdMap.put(component, id);
        }
        return id;
    }
}

