/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Collections;
import java.util.Iterator;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.AxisIteratorOverSequence;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.UntypedAtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextFragmentValue
extends GenericTreeInfo
implements NodeInfo,
SourceLocator {
    private CharSequence text;
    private String baseURI;
    private String documentURI;
    private TextFragmentTextNode textNode = null;

    public TextFragmentValue(Configuration config, CharSequence value, String baseURI) {
        super(config);
        this.setRootNode(this);
        this.text = value;
        this.baseURI = baseURI;
    }

    @Override
    public TreeInfo getTreeInfo() {
        return this;
    }

    @Override
    public NodeInfo getRootNode() {
        return this;
    }

    @Override
    public NodeInfo head() {
        return this;
    }

    @Override
    public SequenceIterator iterate() {
        return SingletonIterator.makeIterator(this);
    }

    @Override
    public boolean isTyped() {
        return false;
    }

    @Override
    public final int getNodeKind() {
        return 9;
    }

    @Override
    public String getStringValue() {
        return this.text.toString();
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.text;
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo other) {
        return this == other;
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        buffer.append("tt");
        buffer.append(Long.toString(this.getDocumentNumber()));
    }

    @Override
    public void setSystemId(String systemId) {
        this.documentURI = systemId;
    }

    @Override
    public String getSystemId() {
        return this.documentURI;
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public int compareOrder(NodeInfo other) {
        if (this == other) {
            return 0;
        }
        return -1;
    }

    @Override
    public int comparePosition(NodeInfo other) {
        if (this == other) {
            return 12;
        }
        if (this.textNode == other) {
            return 0;
        }
        throw new UnsupportedOperationException();
    }

    private int getNameCode() {
        return -1;
    }

    public int getFingerprint() {
        return -1;
    }

    @Override
    public String getPrefix() {
        return "";
    }

    @Override
    public String getURI() {
        return "";
    }

    @Override
    public String getDisplayName() {
        return "";
    }

    @Override
    public String getLocalPart() {
        return "";
    }

    @Override
    public boolean hasChildNodes() {
        return !"".equals(this.text);
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public Location saveLocation() {
        return this;
    }

    @Override
    public SchemaType getSchemaType() {
        return Untyped.getInstance();
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return null;
    }

    @Override
    public AtomicSequence atomize() {
        return new UntypedAtomicValue(this.text);
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public String getAttributeValue(String uri, String local) {
        return null;
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber) {
        switch (axisNumber) {
            case 0: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 1: 
            case 12: {
                return SingleNodeIterator.makeIterator(this);
            }
            case 3: 
            case 4: {
                return SingleNodeIterator.makeIterator(this.getTextNode());
            }
            case 5: {
                Item[] nodes = new NodeInfo[]{this, this.getTextNode()};
                return new AxisIteratorOverSequence(new ArrayIterator(nodes));
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 0: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 1: 
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 3: 
            case 4: {
                return Navigator.filteredSingleton(this.getTextNode(), nodeTest);
            }
            case 5: {
                boolean b1 = nodeTest.matchesNode(this);
                TextFragmentTextNode textNode2 = this.getTextNode();
                boolean b2 = nodeTest.matchesNode(textNode2);
                if (b1) {
                    if (b2) {
                        Item[] pair = new NodeInfo[]{this, textNode2};
                        return new AxisIteratorOverSequence(new ArrayIterator(pair));
                    }
                    return SingleNodeIterator.makeIterator(this);
                }
                if (b2) {
                    return SingleNodeIterator.makeIterator(textNode2);
                }
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    @Override
    public NodeInfo getParent() {
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        return this;
    }

    @Override
    public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
        out.characters(this.text, locationId, 0);
    }

    @Override
    public NodeInfo selectID(String id, boolean getParent) {
        return null;
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public String[] getUnparsedEntity(String name) {
        return null;
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public boolean isIdref() {
        return false;
    }

    @Override
    public boolean isNilled() {
        return false;
    }

    private TextFragmentTextNode getTextNode() {
        if (this.textNode == null) {
            this.textNode = new TextFragmentTextNode();
        }
        return this.textNode;
    }

    private class TextFragmentTextNode
    implements NodeInfo,
    SourceLocator {
        private TextFragmentTextNode() {
        }

        public TreeInfo getTreeInfo() {
            return TextFragmentValue.this;
        }

        public NodeInfo head() {
            return this;
        }

        public SequenceIterator iterate() {
            return SingletonIterator.makeIterator(this);
        }

        public void setSystemId(String systemId) {
        }

        public Configuration getConfiguration() {
            return this.getTreeInfo().getConfiguration();
        }

        public final int getNodeKind() {
            return 3;
        }

        public String getStringValue() {
            return TextFragmentValue.this.text.toString();
        }

        public CharSequence getStringValueCS() {
            return TextFragmentValue.this.text;
        }

        public boolean isSameNodeInfo(NodeInfo other) {
            return this == other;
        }

        public void generateId(FastStringBuffer buffer) {
            buffer.append("tt");
            buffer.append(Long.toString(TextFragmentValue.this.getDocumentNumber()));
            buffer.append("t1");
        }

        public String getSystemId() {
            return null;
        }

        public String getBaseURI() {
            return TextFragmentValue.this.baseURI;
        }

        public int compareOrder(NodeInfo other) {
            if (this == other) {
                return 0;
            }
            return 1;
        }

        public int comparePosition(NodeInfo other) {
            if (this == other) {
                return 12;
            }
            if (TextFragmentValue.this == other) {
                return 4;
            }
            throw new UnsupportedOperationException();
        }

        private int getNameCode() {
            return -1;
        }

        public int getFingerprint() {
            return -1;
        }

        public String getPrefix() {
            return "";
        }

        public String getURI() {
            return "";
        }

        public String getDisplayName() {
            return "";
        }

        public String getLocalPart() {
            return "";
        }

        public boolean hasChildNodes() {
            return false;
        }

        public String getAttributeValue(String uri, String local) {
            return null;
        }

        public int getLineNumber() {
            return -1;
        }

        public Location saveLocation() {
            return this;
        }

        public SchemaType getSchemaType() {
            return null;
        }

        public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
            return null;
        }

        public AtomicSequence atomize() throws XPathException {
            return new UntypedAtomicValue(TextFragmentValue.this.text);
        }

        public String getPublicId() {
            return null;
        }

        public int getColumnNumber() {
            return -1;
        }

        public AxisIterator iterateAxis(byte axisNumber) {
            switch (axisNumber) {
                case 0: 
                case 9: 
                case 13: {
                    return SingleNodeIterator.makeIterator(TextFragmentValue.this);
                }
                case 1: {
                    Item[] nodes = new NodeInfo[]{this, TextFragmentValue.this};
                    return new AxisIteratorOverSequence(new ArrayIterator(nodes));
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                case 5: 
                case 12: {
                    return SingleNodeIterator.makeIterator(this);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + axisNumber);
        }

        public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
            switch (axisNumber) {
                case 0: 
                case 9: 
                case 13: {
                    return Navigator.filteredSingleton(TextFragmentValue.this, nodeTest);
                }
                case 1: {
                    boolean matchesDoc = nodeTest.matchesNode(TextFragmentValue.this);
                    boolean matchesText = nodeTest.matchesNode(this);
                    if (matchesDoc && matchesText) {
                        Item[] nodes = new NodeInfo[]{this, TextFragmentValue.this};
                        return new AxisIteratorOverSequence(new ArrayIterator(nodes));
                    }
                    if (matchesDoc && !matchesText) {
                        return SingleNodeIterator.makeIterator(TextFragmentValue.this);
                    }
                    if (matchesText && !matchesDoc) {
                        return SingleNodeIterator.makeIterator(this);
                    }
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                case 5: 
                case 12: {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + axisNumber);
        }

        public NodeInfo getParent() {
            return TextFragmentValue.this;
        }

        public NodeInfo getRoot() {
            return TextFragmentValue.this;
        }

        public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
            out.characters(TextFragmentValue.this.text, locationId, 0);
        }

        public boolean isId() {
            return false;
        }

        public boolean isIdref() {
            return false;
        }

        public boolean isNilled() {
            return false;
        }
    }
}

