/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.arrays.ArrayFunctionSet;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.XSLSequence;
import net.sf.saxon.trans.XPathException;

public class XSLArray
extends XSLSequence {
    private boolean composite;

    @Override
    public boolean isInXsltNamespace() {
        return this.getNodeName().hasURI(NamespaceUri.XSLT);
    }

    @Override
    protected void prepareAttributes() {
        for (AttributeInfo att : this.attributes()) {
            NodeName attName = att.getNodeName();
            String value = att.getValue();
            String f = attName.getDisplayName();
            if (f.equals("select")) {
                this.setSelectExpression(this.makeExpression(value, att));
                continue;
            }
            if (f.equals("composite")) {
                this.composite = this.processBooleanAttribute("composite", value);
                continue;
            }
            this.checkUnknownAttribute(attName);
        }
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        Expression functionCall;
        if (this.isInXsltNamespace()) {
            this.requireXslt40Element();
        } else if (!this.getConfiguration().isLicensedFeature(8)) {
            this.compileError("saxon:array requires a Saxon-PE or -EE license");
        }
        if (this.getSelectExpression() == null) {
            this.setSelectExpression(this.compileSequenceConstructor(exec, decl, false));
        }
        if (this.composite) {
            SystemFunction arrayOf = ArrayFunctionSet.getInstance(40).makeFunction("of", 1);
            functionCall = arrayOf.makeFunctionCall(this.getSelectExpression());
        } else {
            SystemFunction arrayFromSeq = ArrayFunctionSet.getInstance(40).makeFunction("_from-sequence", 1);
            functionCall = arrayFromSeq.makeFunctionCall(this.getSelectExpression());
        }
        ExpressionTool.copyLocationInfo(this.getSelectExpression(), functionCall);
        return functionCall;
    }
}

