/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.functions.Count;
import net.sf.saxon.functions.DeepEqual40;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class RangeKey
extends MapItem {
    private final UnicodeString min;
    private final UnicodeString max;
    private final TreeMap<AtomicMatchKey, Object> index;

    public RangeKey(UnicodeString min, UnicodeString max, TreeMap<AtomicMatchKey, Object> index) {
        this.min = min;
        this.max = max;
        this.index = index;
    }

    @Override
    public GroundedValue get(AtomicValue key) {
        UnicodeString k = key.getUnicodeStringValue();
        if (!(this.min != null && this.min.compareTo(k) > 0 || this.max != null && this.max.compareTo(k) < 0)) {
            Object value = this.index.get(k);
            if (value == null) {
                return null;
            }
            if (value instanceof NodeInfo) {
                return (NodeInfo)value;
            }
            List nodes = (List)value;
            return nodes.isEmpty() ? null : new SequenceExtent.Of(nodes);
        }
        return null;
    }

    @Override
    public int size() {
        try {
            return Count.count(this.keys());
        }
        catch (XPathException err) {
            return 0;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.keys().next() == null;
    }

    @Override
    public AtomicIterator keys() {
        return new RangeKeyIterator(this.min, this.max, this.index);
    }

    @Override
    public Iterable<KeyValuePair> keyValuePairs() {
        AtomicValue key;
        ArrayList<KeyValuePair> kvpList = new ArrayList<KeyValuePair>();
        AtomicIterator keyIter = this.keys();
        while ((key = keyIter.next()) != null) {
            kvpList.add(new KeyValuePair(key, this.get(key)));
        }
        return kvpList;
    }

    @Override
    public MapItem remove(AtomicValue key) {
        return HashTrieMap.copy(this).remove(key);
    }

    @Override
    public UType getKeyUType() {
        return UType.STRING;
    }

    @Override
    public MapItem addEntry(AtomicValue key, GroundedValue value) {
        return HashTrieMap.copy(this).addEntry(key, value);
    }

    @Override
    public boolean conforms(AtomicType keyType, SequenceType valueType, TypeHierarchy th) {
        AtomicValue key;
        AtomicIterator keyIter = this.keys();
        while ((key = keyIter.next()) != null) {
            GroundedValue value = this.get(key);
            if (valueType.matches(value, th)) continue;
            return false;
        }
        return true;
    }

    @Override
    public MapType getItemType(TypeHierarchy th) {
        return new MapType(BuiltInAtomicType.STRING, SequenceType.NODE_SEQUENCE);
    }

    @Override
    public MapType getFunctionItemType() {
        return new MapType(BuiltInAtomicType.STRING, SequenceType.NODE_SEQUENCE);
    }

    @Override
    public String getDescription() {
        return "range key";
    }

    @Override
    public boolean deepEquals(FunctionItem other, XPathContext context, AtomicComparer comparer, int flags) {
        if (other instanceof RangeKey) {
            RangeKey rk = (RangeKey)other;
            return this.min.equals(rk.min) && this.max.equals(rk.max) && this.index.equals(rk.index);
        }
        return false;
    }

    @Override
    public boolean deepEqual40(FunctionItem other, XPathContext context, DeepEqual40.DeepEqualOptions options) {
        if (other instanceof RangeKey) {
            RangeKey rk = (RangeKey)other;
            return this.min.equals(rk.min) && this.max.equals(rk.max) && this.index.equals(rk.index);
        }
        return false;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("range-key-map");
        out.emitAttribute("size", this.size() + "");
        out.endElement();
    }

    @Override
    public boolean isTrustedResultType() {
        return false;
    }

    public String toString() {
        return MapItem.mapToString(this);
    }

    private static class RangeKeyIterator
    implements AtomicIterator {
        private int pos = 0;
        private StringValue curr = null;
        private final StringValue top;
        private final UnicodeString min;
        private final UnicodeString max;
        private final TreeMap<AtomicMatchKey, Object> index;

        public RangeKeyIterator(UnicodeString min, UnicodeString max, TreeMap<AtomicMatchKey, Object> index) {
            this.top = new StringValue((UnicodeString)(max == null ? index.lastKey() : index.floorKey(max)));
            this.min = min;
            this.max = max;
            this.index = index;
        }

        @Override
        public StringValue next() {
            if (this.pos <= 0) {
                UnicodeString c;
                if (this.pos < 0) {
                    return null;
                }
                this.curr = this.min == null ? new StringValue((UnicodeString)this.index.firstKey()) : ((c = (UnicodeString)this.index.ceilingKey(this.min)) == null || this.max != null && c.compareTo(this.max) > 0 ? null : new StringValue(c));
            } else {
                this.curr = this.curr.equals(this.top) ? null : new StringValue((UnicodeString)this.index.higherKey(this.curr.getUnicodeStringValue()));
            }
            if (this.curr == null) {
                this.pos = -1;
                return null;
            }
            ++this.pos;
            return this.curr;
        }
    }
}

