/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.ArrayList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.expr.sort.GroupMatchingIterator;
import net.sf.saxon.functions.Count;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;

public class GroupStartingIterator
extends GroupMatchingIterator
implements LookaheadIterator,
GroupIterator {
    public GroupStartingIterator(PullEvaluator select, Pattern startPattern, XPathContext context) throws XPathException {
        this.select = select;
        this.pattern = startPattern;
        this.baseContext = context;
        this.runningContext = context.newMinorContext();
        this.population = this.runningContext.trackFocus(select.iterate(context));
        this.nextItem = this.population.next();
    }

    @Override
    public boolean supportsGetLength() {
        return true;
    }

    @Override
    public int getLength() {
        try {
            GroupStartingIterator another = new GroupStartingIterator(this.select, this.pattern, this.baseContext);
            return Count.steppingCount(another);
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
    }

    @Override
    protected void advance() throws XPathException {
        Item nextCandidate;
        this.currentMembers = new ArrayList(10);
        this.currentMembers.add(this.current);
        while ((nextCandidate = this.population.next()) != null) {
            if (this.pattern.matches(nextCandidate, this.runningContext)) {
                this.nextItem = nextCandidate;
                return;
            }
            this.currentMembers.add(nextCandidate);
        }
        this.nextItem = null;
    }
}

