/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CompositeAtomicKey;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.functions.Count;
import net.sf.saxon.functions.DistinctValues;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;

public class GroupAdjacentIterator
implements GroupIterator,
LastPositionFinder,
LookaheadIterator {
    private final PullEvaluator select;
    private final FocusIterator population;
    private final Expression keyExpression;
    private final StringCollator collator;
    private final XPathContext baseContext;
    private final XPathContext runningContext;
    private CompositeAtomicKey currentComparisonKey;
    private AtomicSequence currentKey;
    private List<Item> currentMembers;
    private CompositeAtomicKey nextComparisonKey;
    private List<AtomicValue> nextKey = null;
    private Item nextItem;
    private Item current = null;
    private int position = 0;
    private boolean composite = false;

    public GroupAdjacentIterator(PullEvaluator select, Expression keyExpression, XPathContext baseContext, StringCollator collator, boolean composite) throws XPathException {
        this.select = select;
        this.keyExpression = keyExpression;
        this.baseContext = baseContext;
        this.runningContext = baseContext.newMinorContext();
        this.population = this.runningContext.trackFocus(select.iterate(baseContext));
        this.collator = collator;
        this.composite = composite;
        this.nextItem = this.population.next();
        if (this.nextItem != null) {
            this.nextKey = this.getKey(this.runningContext);
            this.nextComparisonKey = this.getComparisonKey(this.nextKey, baseContext);
        }
    }

    @Override
    public boolean supportsGetLength() {
        return true;
    }

    @Override
    public int getLength() {
        try {
            GroupAdjacentIterator another = new GroupAdjacentIterator(this.select, this.keyExpression, this.baseContext, this.collator, this.composite);
            return Count.steppingCount(another);
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
    }

    private List<AtomicValue> getKey(XPathContext context) throws XPathException {
        AtomicValue val;
        ArrayList<AtomicValue> key = new ArrayList<AtomicValue>();
        SequenceIterator iter = this.keyExpression.iterate(context);
        while ((val = (AtomicValue)iter.next()) != null) {
            key.add(val);
        }
        return key;
    }

    private CompositeAtomicKey getComparisonKey(List<AtomicValue> key, XPathContext keyContext) throws XPathException {
        ArrayList<AtomicMatchKey> ckey = new ArrayList<AtomicMatchKey>(key.size());
        for (AtomicValue aKey : key) {
            AtomicMatchKey comparisonKey = aKey.isNaN() ? DistinctValues.NaN_MATCH_KEY : aKey.getXPathMatchKey(this.collator, keyContext.getImplicitTimezone());
            ckey.add(comparisonKey);
        }
        return new CompositeAtomicKey(ckey);
    }

    private void advance() throws XPathException {
        Item nextCandidate;
        this.currentMembers = new ArrayList<Item>(20);
        this.currentMembers.add(this.current);
        while ((nextCandidate = this.population.next()) != null) {
            List<AtomicValue> newKey = this.getKey(this.runningContext);
            CompositeAtomicKey newComparisonKey = this.getComparisonKey(newKey, this.baseContext);
            try {
                if (newComparisonKey.equals(this.currentComparisonKey)) {
                    this.currentMembers.add(nextCandidate);
                    continue;
                }
                this.nextItem = nextCandidate;
                this.nextComparisonKey = newComparisonKey;
                this.nextKey = newKey;
                return;
            }
            catch (ClassCastException e) {
                String message = "Grouping key values are of non-comparable types";
                XPathException err = new XPathException(message);
                err.setIsTypeError(true);
                err.setXPathContext(this.runningContext);
                throw err;
            }
        }
        this.nextItem = null;
        this.nextKey = null;
    }

    @Override
    public AtomicSequence getCurrentGroupingKey() {
        return this.currentKey;
    }

    @Override
    public GroundedValue currentGroup() throws XPathException {
        return SequenceExtent.makeSequenceExtent(this.currentMembers);
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.nextItem != null;
    }

    @Override
    public Item next() {
        try {
            if (this.nextItem == null) {
                this.current = null;
                this.position = -1;
                return null;
            }
            this.current = this.nextItem;
            this.currentKey = this.nextKey.size() == 1 ? (AtomicSequence)this.nextKey.get(0) : new AtomicArray(this.nextKey);
            this.currentComparisonKey = this.nextComparisonKey;
            ++this.position;
            this.advance();
            return this.current;
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
    }

    @Override
    public void close() {
        this.population.close();
    }
}

