/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Arrays;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.PushElaborator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.ApplyNextMatchingTemplate;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.TemplateRuleTraceListener;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.trans.rules.Rule;

public class NextMatch
extends ApplyNextMatchingTemplate {
    boolean useTailRecursion;

    public NextMatch(boolean useTailRecursion) {
        this.useTailRecursion = useTailRecursion;
    }

    @Override
    public int getInstructionNameCode() {
        return 183;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        NextMatch nm2 = new NextMatch(this.useTailRecursion);
        nm2.setActualParams(WithParam.copy(nm2, this.getActualParams(), rebindings));
        nm2.setTunnelParams(WithParam.copy(nm2, this.getTunnelParams(), rebindings));
        ExpressionTool.copyLocationInfo(this, nm2);
        return nm2;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("nextMatch", this);
        String flags = "i";
        if (this.useTailRecursion) {
            flags = "t";
        }
        out.emitAttribute("flags", flags);
        if (this.getActualParams().length != 0) {
            WithParam.exportParameters(this.getActualParams(), out, false);
        }
        if (this.getTunnelParams().length != 0) {
            WithParam.exportParameters(this.getTunnelParams(), out, true);
        }
        out.endElement();
    }

    @Override
    public String getStreamerName() {
        return "NextMatch";
    }

    @Override
    public Elaborator getElaborator() {
        return new NextMatchElaborator();
    }

    private static class NextMatchElaborator
    extends PushElaborator {
        private NextMatchElaborator() {
        }

        @Override
        public PushEvaluator elaborateForPush() {
            NextMatch expr = (NextMatch)this.getExpression();
            Location loc = expr.getLocation();
            return (output, context) -> {
                Item currentItem;
                Controller controller = context.getController();
                assert (controller != null);
                ParameterSet params = Instruction.assembleParams(context, expr.getActualParams());
                ParameterSet tunnels = Instruction.assembleTunnelParams(context, expr.getTunnelParams());
                Rule currentRule = context.getCurrentTemplateRule();
                if (currentRule == null) {
                    XPathException e = new XPathException("There is no current template rule", "XTDE0560");
                    e.setXPathContext(context);
                    e.setLocation(loc);
                    throw e;
                }
                Component.M modeComponent = context.getCurrentMode();
                if (modeComponent == null) {
                    throw new AssertionError((Object)"Current mode is null");
                }
                Mode mode = modeComponent.getActor();
                Rule rule = mode.getNextMatchRule(currentItem = context.getCurrentIterator().current(), currentRule, context);
                if (rule == null) {
                    mode.getBuiltInRuleSet().process(currentItem, params, tunnels, output, context, loc);
                } else {
                    if (expr.useTailRecursion) {
                        Arrays.fill(context.getStackFrame().getStackFrameValues(), null);
                        ((XPathContextMajor)context).setCurrentComponent(modeComponent);
                        return new NextMatchPackage(expr, rule, params, tunnels, output, context);
                    }
                    TemplateRule nh = (TemplateRule)rule.getAction();
                    nh.initialize();
                    XPathContextMajor c2 = context.newContext();
                    c2.setOrigin(expr);
                    c2.openStackFrame(nh.getStackFrameMap());
                    c2.setLocalParameters(params);
                    c2.setTunnelParameters(tunnels);
                    c2.setCurrentTemplateRule(rule);
                    c2.setCurrentComponent(modeComponent);
                    c2.setCurrentMergeGroupIterator(null);
                    if (mode.isModeTracing()) {
                        TemplateRuleTraceListener tracer = ((XsltController)controller).getTemplateRuleTraceListener();
                        tracer.enter("next-match", loc, currentItem, nh);
                        nh.apply(output, c2);
                        tracer.leave();
                    } else {
                        nh.apply(output, c2);
                    }
                }
                return null;
            };
        }
    }

    private static class NextMatchPackage
    implements TailCall {
        private final NextMatch instruction;
        private final Rule rule;
        private final ParameterSet params;
        private final ParameterSet tunnelParams;
        private final Outputter output;
        private final XPathContext evaluationContext;

        public NextMatchPackage(NextMatch instruction, Rule rule, ParameterSet params, ParameterSet tunnelParams, Outputter output, XPathContext evaluationContext) {
            this.instruction = instruction;
            this.rule = rule;
            this.params = params;
            this.tunnelParams = tunnelParams;
            this.output = output;
            this.evaluationContext = evaluationContext;
        }

        @Override
        public TailCall processLeavingTail() throws XPathException {
            TemplateRule nh = (TemplateRule)this.rule.getAction();
            nh.initialize();
            XPathContextMajor c2 = this.evaluationContext.newContext();
            c2.setOrigin(this.instruction);
            c2.setLocalParameters(this.params);
            c2.setTunnelParameters(this.tunnelParams);
            c2.openStackFrame(nh.getStackFrameMap());
            c2.setCurrentTemplateRule(this.rule);
            c2.setCurrentComponent(this.evaluationContext.getCurrentComponent());
            c2.setCurrentMergeGroupIterator(null);
            Mode mode = this.evaluationContext.getCurrentMode().getActor();
            if (mode.isModeTracing()) {
                TemplateRuleTraceListener tracer = ((XsltController)this.evaluationContext.getController()).getTemplateRuleTraceListener();
                tracer.enter("next-match", this.instruction.getLocation(), this.evaluationContext.getContextItem(), nh);
                TailCall tc = nh.applyLeavingTail(this.output, c2);
                tracer.leave();
                return tc;
            }
            return nh.applyLeavingTail(this.output, c2);
        }
    }
}

