/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.ArrayList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.OrderByClause;
import net.sf.saxon.expr.flwor.Tuple;
import net.sf.saxon.expr.flwor.TupleExpression;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.ItemToBeSorted;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;

public class OrderByClausePull
extends TuplePull {
    private final TuplePull base;
    private final OrderByClause orderByClause;
    private final TupleExpression tupleExpr;
    private int currentPosition = -1;
    private final AtomicComparer[] comparers;
    private final ArrayList<ItemToBeSorted> tupleArray = new ArrayList(100);

    public OrderByClausePull(TuplePull base, TupleExpression tupleExpr, OrderByClause orderBy, XPathContext context) {
        this.base = base;
        this.tupleExpr = tupleExpr;
        this.orderByClause = orderBy;
        AtomicComparer[] suppliedComparers = orderBy.getAtomicComparers();
        this.comparers = new AtomicComparer[suppliedComparers.length];
        for (int n = 0; n < this.comparers.length; ++n) {
            this.comparers[n] = suppliedComparers[n].provideContext(context);
        }
    }

    @Override
    public boolean nextTuple(XPathContext context) throws XPathException {
        if (this.currentPosition < 0) {
            this.currentPosition = 0;
            int position = 0;
            while (this.base.nextTuple(context)) {
                Tuple tuple = this.tupleExpr.evaluateItem(context);
                SortKeyDefinitionList sortKeyDefinitions = this.orderByClause.getSortKeyDefinitions();
                ItemToBeSorted itbs = new ItemToBeSorted(sortKeyDefinitions.size());
                itbs.value = tuple;
                for (int i = 0; i < sortKeyDefinitions.size(); ++i) {
                    itbs.sortKeyValues[i] = this.orderByClause.evaluateSortKey(i, context);
                }
                itbs.originalPosition = ++position;
                this.tupleArray.add(itbs);
            }
            try {
                this.tupleArray.sort((a, b) -> {
                    try {
                        for (int i = 0; i < this.comparers.length; ++i) {
                            int comp = this.comparers[i].compareAtomicValues(a.sortKeyValues[i], b.sortKeyValues[i]);
                            if (comp == 0) continue;
                            return comp;
                        }
                    }
                    catch (NoDynamicContextException e) {
                        throw new AssertionError((Object)("Sorting without dynamic context: " + e.getMessage()));
                    }
                    return a.originalPosition - b.originalPosition;
                });
            }
            catch (ClassCastException e) {
                XPathException err = new XPathException("Non-comparable types found while sorting: " + e.getMessage());
                err.setErrorCode("XPTY0004");
                throw err;
            }
        }
        if (this.currentPosition < this.tupleArray.size()) {
            this.tupleExpr.setCurrentTuple(context, (Tuple)this.tupleArray.get((int)this.currentPosition++).value);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.base.close();
    }
}

