/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.MethodOptimizationInfo;

public class NoSideEffectMethodMarker
extends SimplifiedVisitor
implements MemberVisitor {
    public static final Object KEPT_BUT_NO_SIDE_EFFECTS = new Object();

    public void visitAnyMember(Clazz Clazz2, Member member) {
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        NoSideEffectMethodMarker.markNoSideEffects(programMethod);
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        NoSideEffectMethodMarker.markNoSideEffects(libraryMethod);
    }

    private static void markNoSideEffects(Method method) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (info != null) {
            info.setNoSideEffects();
        } else {
            MethodLinker.lastMember(method).setVisitorInfo(KEPT_BUT_NO_SIDE_EFFECTS);
        }
    }

    public static boolean hasNoSideEffects(Method method) {
        if (MethodLinker.lastVisitorAccepter(method).getVisitorInfo() == KEPT_BUT_NO_SIDE_EFFECTS) {
            return true;
        }
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return info != null && info.hasNoSideEffects();
    }
}

