/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.IFSDeleteAction;
import com.ibm.as400.vaccess.IFSEditAction;
import com.ibm.as400.vaccess.IFSFilePropertiesPane;
import com.ibm.as400.vaccess.IFSRenameAction;
import com.ibm.as400.vaccess.PermissionAction;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VIFSConstants;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEvent;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import javax.swing.Icon;

public class VIFSFile
implements VObject,
VIFSConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String description_ = ResourceLoader.getText("IFS_FILE_DESCRIPTION");
    private static final Icon icon16_ = ResourceLoader.getIcon("VIFSFile16.gif", description_);
    private static final Icon icon32_ = ResourceLoader.getIcon("VIFSFile32.gif", description_);
    private static final String readAbbreviationText_ = ResourceLoader.getText("IFS_READ_ABBREVIATION");
    private static final String writeAbbreviationText_ = ResourceLoader.getText("IFS_WRITE_ABBREVIATION");
    IFSFile file_ = null;
    private transient VAction[] actions_;
    private transient boolean actionsInitialized_;
    private transient String attributes_;
    private transient VAction defaultAction_;
    private transient Date modified_;
    private transient VPropertiesPane propertiesPane_;
    private transient boolean readable_;
    private transient Long size_;
    private transient boolean writable_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public VIFSFile() {
        this.file_ = new IFSFile();
        this.initializeTransient();
    }

    public VIFSFile(IFSFile iFSFile) {
        if (iFSFile == null) {
            throw new NullPointerException("file");
        }
        this.file_ = iFSFile;
        this.initializeTransient();
    }

    public VIFSFile(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("path");
        }
        this.file_ = new IFSFile(aS400, string);
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    boolean canRead() {
        return this.readable_;
    }

    boolean canWrite() {
        return this.writable_;
    }

    public VAction[] getActions() {
        this.initializeCreationActions();
        return this.actions_;
    }

    public VAction getDefaultAction() {
        return this.defaultAction_;
    }

    public Icon getIcon(int n, boolean bl) {
        if (n == 32) {
            return icon32_;
        }
        return icon16_;
    }

    Date getModified() {
        return this.modified_;
    }

    public String getName() {
        return this.file_.getName();
    }

    public String getParentDirectory() {
        return this.file_.getParent();
    }

    public String getPath() {
        return this.file_.getPath();
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public synchronized Object getPropertyValue(Object object) {
        if (object == VObject.NAME_PROPERTY) {
            return this;
        }
        if (object == VObject.DESCRIPTION_PROPERTY) {
            return description_;
        }
        if (object == VIFSConstants.SIZE_PROPERTY) {
            return this.size_;
        }
        if (object == VIFSConstants.MODIFIED_PROPERTY) {
            return this.modified_;
        }
        if (object == VIFSConstants.ATTRIBUTES_PROPERTY) {
            return this.attributes_;
        }
        return null;
    }

    long getSize() {
        return this.size_;
    }

    public AS400 getSystem() {
        return this.file_.getSystem();
    }

    public String getText() {
        return this.file_.getName();
    }

    private void initializeCreationActions() {
        if (this.actionsInitialized_) {
            return;
        }
        String string = this.file_.getPath().toUpperCase();
        if (string.startsWith("/QSYS.LIB/") || string.startsWith("/QDLS/")) {
            for (int i = 0; i < 2; ++i) {
                this.actions_[i].setEnabled(false);
            }
            this.defaultAction_ = this.actions_[4];
        }
        this.actionsInitialized_ = true;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.file_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.file_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.addVObjectListener(new VObjectListener_());
        this.actions_ = new VAction[5];
        this.actions_[0] = new IFSEditAction(this, this.file_, true);
        this.actions_[1] = new IFSEditAction(this, this.file_, false);
        this.actions_[2] = new IFSRenameAction(this, this.file_);
        this.actions_[3] = new IFSDeleteAction(this, this.file_);
        this.actions_[4] = new PermissionAction(this.file_);
        this.defaultAction_ = this.actions_[0];
        this.actionsInitialized_ = false;
        for (int i = 0; i < this.actions_.length; ++i) {
            this.actions_[i].addErrorListener(this.errorEventSupport_);
            this.actions_[i].addVObjectListener(this.objectEventSupport_);
            this.actions_[i].addWorkingListener(this.workingEventSupport_);
        }
        this.propertiesPane_ = new IFSFilePropertiesPane(this);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
        this.attributes_ = "";
        this.modified_ = new Date();
        this.readable_ = false;
        this.size_ = new Long(0L);
        this.writable_ = false;
    }

    public void load() {
        this.workingEventSupport_.fireStartWorking();
        this.initializeCreationActions();
        try {
            this.size_ = new Long(this.file_.length());
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
            this.size_ = new Long(0L);
        }
        try {
            this.modified_ = new Date(this.file_.lastModified());
        }
        catch (Exception exception) {
            this.modified_ = new Date(0L);
            this.errorEventSupport_.fireError(exception);
        }
        try {
            this.readable_ = this.file_.canRead();
        }
        catch (Exception exception) {
            this.readable_ = false;
            this.errorEventSupport_.fireError(exception);
        }
        try {
            this.writable_ = this.file_.canWrite();
        }
        catch (Exception exception) {
            this.writable_ = false;
            this.errorEventSupport_.fireError(exception);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.readable_) {
            stringBuffer.append(readAbbreviationText_);
        }
        if (this.writable_) {
            stringBuffer.append(writeAbbreviationText_);
        }
        this.attributes_ = stringBuffer.toString();
        this.workingEventSupport_.fireStopWorking();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("path");
        }
        this.file_.setPath(string);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.file_.setSystem(aS400);
    }

    public String toString() {
        return this.file_.getName();
    }

    private class VObjectListener_
    implements VObjectListener,
    Serializable {
        private VObjectListener_() {
        }

        public void objectChanged(VObjectEvent vObjectEvent) {
            VIFSFile.this.file_.clearCachedAttributes();
        }

        public void objectCreated(VObjectEvent vObjectEvent) {
        }

        public void objectDeleted(VObjectEvent vObjectEvent) {
        }
    }
}

