/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.DBDateCellRenderer;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;

class SQLResultSetData
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private SQLConnection connection_ = null;
    private String query_ = null;
    private transient Object[][] data_ = null;
    private transient ResultSet resultSet_ = null;
    private transient Statement stmt_ = null;
    private transient boolean resourceOpen_ = false;
    private transient int numColumns_ = 0;
    private transient ResultSetMetaData resultSetMetaData_ = null;
    private static int ROW_INCREMENT_ = 100;
    private transient int numRows_ = 0;
    private transient int lastRecordRead_ = -1;
    private transient boolean allRecordsRead_ = true;
    private transient SQLWarning warnings_;
    private transient boolean error_;
    private transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    private transient WorkingEventSupport workingListeners_ = new WorkingEventSupport(this);
    private boolean fireWorkingEvents_ = true;

    public void addErrorListener(ErrorListener errorListener) {
        this.errorListeners_.addErrorListener(errorListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingListeners_.addWorkingListener(workingListener);
    }

    public synchronized void close() {
        if (this.resourceOpen_) {
            try {
                this.resultSet_.close();
            }
            catch (SQLException sQLException) {
                this.errorListeners_.fireError(sQLException);
            }
        }
        if (this.stmt_ != null) {
            try {
                this.stmt_.close();
            }
            catch (SQLException sQLException) {
                this.errorListeners_.fireError(sQLException);
            }
        }
        this.resourceOpen_ = false;
    }

    public void clearWarnings() {
        this.warnings_ = null;
        if (this.resultSet_ != null) {
            try {
                this.resultSet_.clearWarnings();
            }
            catch (SQLException sQLException) {
                this.errorListeners_.fireError(sQLException);
            }
        }
    }

    public synchronized boolean getAllRecordsProcessed() {
        return this.allRecordsRead_;
    }

    public synchronized int getColumnDisplaySize(int n) {
        if (this.resultSet_ == null) {
            throw new IndexOutOfBoundsException("index");
        }
        int n2 = 0;
        try {
            switch (this.resultSetMetaData_.getColumnType(n + 1)) {
                case 92: {
                    n2 = DBDateCellRenderer.getDisplaySize(1);
                    break;
                }
                case 91: {
                    n2 = DBDateCellRenderer.getDisplaySize(3);
                    break;
                }
                case 93: {
                    n2 = DBDateCellRenderer.getDisplaySize(2);
                    break;
                }
                default: {
                    n2 = this.resultSetMetaData_.getColumnDisplaySize(n + 1);
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            this.errorListeners_.fireError(sQLException);
        }
        return n2;
    }

    public synchronized String getColumnLabel(int n) {
        if (this.resultSet_ == null) {
            throw new IndexOutOfBoundsException("index");
        }
        try {
            return this.resultSetMetaData_.getColumnLabel(n + 1);
        }
        catch (SQLException sQLException) {
            this.errorListeners_.fireError(sQLException);
            return "";
        }
    }

    public synchronized String getColumnName(int n) {
        if (this.resultSet_ == null) {
            throw new IndexOutOfBoundsException("index");
        }
        try {
            return this.resultSetMetaData_.getColumnName(n + 1);
        }
        catch (SQLException sQLException) {
            this.errorListeners_.fireError(sQLException);
            return "";
        }
    }

    public synchronized int getColumnType(int n) {
        if (this.resultSet_ == null) {
            throw new IndexOutOfBoundsException("index");
        }
        try {
            return this.resultSetMetaData_.getColumnType(n + 1);
        }
        catch (SQLException sQLException) {
            this.errorListeners_.fireError(sQLException);
            return 1;
        }
    }

    public SQLConnection getConnection() {
        return this.connection_;
    }

    public synchronized int getLastRecordProcessed() {
        return this.lastRecordRead_;
    }

    public synchronized int getNumberOfColumns() {
        return this.numColumns_;
    }

    public synchronized int getNumberOfRows() {
        if (!this.allRecordsRead_) {
            this.readAllRecords();
        }
        return this.numRows_;
    }

    public String getQuery() {
        return this.query_;
    }

    public synchronized Object getValueAt(int n, int n2) {
        if (this.resultSet_ == null) {
            throw new IndexOutOfBoundsException("rowIndex");
        }
        if (this.lastRecordRead_ < n) {
            this.readMoreRecords(n - this.lastRecordRead_);
        }
        if (this.lastRecordRead_ < n) {
            throw new IndexOutOfBoundsException("rowIndex");
        }
        return this.data_[n][n2];
    }

    public synchronized SQLWarning getWarnings() {
        SQLWarning sQLWarning = null;
        if (this.resultSet_ != null) {
            SQLWarning sQLWarning2 = null;
            try {
                sQLWarning2 = this.resultSet_.getWarnings();
            }
            catch (SQLException sQLException) {
                this.errorListeners_.fireError(sQLException);
            }
            if (this.warnings_ != null) {
                if (sQLWarning2 != null) {
                    SQLWarning sQLWarning3;
                    SQLWarning sQLWarning4 = this.warnings_;
                    while ((sQLWarning3 = sQLWarning4.getNextWarning()) != null) {
                        sQLWarning4 = sQLWarning3;
                    }
                    sQLWarning4.setNextWarning(sQLWarning2);
                }
                sQLWarning = this.warnings_;
            } else {
                sQLWarning = sQLWarning2;
            }
        }
        return sQLWarning;
    }

    public synchronized void load() {
        Trace.log(1, "Doing data load.");
        if (this.connection_ == null || this.query_ == null) {
            Trace.log(1, "Data not set for load, exiting.");
            return;
        }
        if (this.fireWorkingEvents_) {
            this.workingListeners_.fireStartWorking();
        }
        if (this.resourceOpen_) {
            try {
                this.resultSet_.close();
            }
            catch (SQLException sQLException) {
                this.errorListeners_.fireError(sQLException);
            }
            this.resourceOpen_ = false;
        }
        this.resultSetMetaData_ = null;
        this.numColumns_ = 0;
        this.lastRecordRead_ = -1;
        this.allRecordsRead_ = true;
        this.data_ = null;
        this.numRows_ = 0;
        try {
            Object object;
            if (this.stmt_ == null) {
                object = this.connection_.getConnection();
                this.stmt_ = object.createStatement();
                try {
                    this.warnings_ = object.getWarnings();
                }
                catch (SQLException sQLException) {
                    this.errorListeners_.fireError(sQLException);
                }
            }
            this.resultSet_ = this.stmt_.executeQuery(this.query_);
            this.resourceOpen_ = true;
            try {
                object = this.stmt_.getWarnings();
                if (object != null) {
                    if (this.warnings_ == null) {
                        this.warnings_ = object;
                    } else {
                        SQLWarning sQLWarning;
                        SQLWarning sQLWarning2 = this.warnings_;
                        while ((sQLWarning = sQLWarning2.getNextWarning()) != null) {
                            sQLWarning2 = sQLWarning;
                        }
                        sQLWarning2.setNextWarning((SQLWarning)object);
                    }
                }
            }
            catch (SQLException sQLException) {
                this.errorListeners_.fireError(sQLException);
            }
            this.resultSetMetaData_ = this.resultSet_.getMetaData();
            this.numColumns_ = this.resultSetMetaData_.getColumnCount();
            if (!this.resultSet_.next()) {
                try {
                    this.resultSet_.close();
                }
                catch (SQLException sQLException) {
                    this.errorListeners_.fireError(sQLException);
                }
            } else {
                this.allRecordsRead_ = false;
                this.data_ = new Object[ROW_INCREMENT_][this.numColumns_];
            }
        }
        catch (SQLException sQLException) {
            this.resultSet_ = null;
            this.resultSetMetaData_ = null;
            this.numColumns_ = 0;
            this.errorListeners_.fireError(sQLException);
            this.error_ = true;
        }
        if (this.fireWorkingEvents_) {
            this.workingListeners_.fireStopWorking();
        }
    }

    public synchronized void readAllRecords() {
        Trace.log(1, "Reading all rows.");
        this.workingListeners_.fireStartWorking();
        this.error_ = false;
        while (!this.allRecordsRead_ && !this.error_) {
            this.fireWorkingEvents_ = false;
            this.readMoreRecords(ROW_INCREMENT_);
            this.fireWorkingEvents_ = true;
        }
        this.workingListeners_.fireStopWorking();
    }

    public synchronized void readMoreRecords(int n) {
        Trace.log(1, "Reading more rows:", n);
        if (this.fireWorkingEvents_) {
            this.workingListeners_.fireStartWorking();
        }
        this.error_ = false;
        if (!this.allRecordsRead_) {
            int n2;
            if (this.lastRecordRead_ + n >= this.data_.length) {
                int n3 = this.lastRecordRead_ + n + 1;
                n2 = ROW_INCREMENT_ > n3 ? ROW_INCREMENT_ : n3;
                Object[][] objectArray = new Object[this.data_.length + n2][this.numColumns_];
                System.arraycopy(this.data_, 0, objectArray, 0, this.data_.length);
                this.data_ = objectArray;
            }
            Vector<SQLException> vector = null;
            for (int i = 1; i <= n; ++i) {
                int n4;
                for (n4 = 1; n4 <= this.numColumns_; ++n4) {
                    try {
                        this.data_[this.lastRecordRead_ + 1][n4 - 1] = this.resultSet_.getObject(n4);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        this.data_[this.lastRecordRead_ + 1][n4 - 1] = null;
                        n2 = 0;
                        if (vector == null) {
                            vector = new Vector<SQLException>();
                            vector.addElement(sQLException);
                        } else {
                            for (int j = 0; j < vector.size(); ++j) {
                                SQLException sQLException2 = (SQLException)vector.elementAt(j);
                                if (!sQLException.getSQLState().equals(sQLException2.getSQLState()) || sQLException.getErrorCode() != sQLException2.getErrorCode() || !sQLException.getMessage().equals(sQLException2.getMessage())) continue;
                                n2 = 1;
                                Trace.log(1, "Duplicate error getting column value, swallowing error: " + sQLException.getSQLState() + " : " + sQLException.getErrorCode() + " : " + sQLException.getMessage());
                                break;
                            }
                            vector.addElement(sQLException);
                        }
                        if (n2 != 0) continue;
                        this.errorListeners_.fireError(sQLException);
                    }
                }
                ++this.lastRecordRead_;
                n4 = 0;
                try {
                    n4 = this.resultSet_.next() ? 1 : 0;
                }
                catch (SQLException sQLException) {
                    this.errorListeners_.fireError(sQLException);
                    this.error_ = true;
                    n4 = 0;
                }
                if (n4 != 0) continue;
                this.allRecordsRead_ = true;
                try {
                    this.resultSet_.close();
                    this.resourceOpen_ = false;
                }
                catch (SQLException sQLException) {
                    this.errorListeners_.fireError(sQLException);
                }
                this.numRows_ = this.lastRecordRead_ + 1;
                break;
            }
        }
        if (this.fireWorkingEvents_) {
            this.workingListeners_.fireStopWorking();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.data_ = null;
        this.resultSet_ = null;
        this.stmt_ = null;
        this.resourceOpen_ = false;
        this.numColumns_ = 0;
        this.resultSetMetaData_ = null;
        this.numRows_ = 0;
        this.lastRecordRead_ = -1;
        this.allRecordsRead_ = true;
        this.errorListeners_ = new ErrorEventSupport(this);
        this.workingListeners_ = new WorkingEventSupport(this);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorListeners_.removeErrorListener(errorListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingListeners_.removeWorkingListener(workingListener);
    }

    public void setConnection(SQLConnection sQLConnection) {
        if (sQLConnection != this.connection_) {
            this.connection_ = sQLConnection;
            if (this.stmt_ != null) {
                try {
                    this.stmt_.close();
                }
                catch (SQLException sQLException) {
                    this.errorListeners_.fireError(sQLException);
                }
            }
            this.stmt_ = null;
            this.warnings_ = null;
        }
    }

    public void setQuery(String string) {
        this.query_ = string;
    }
}

