/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.resource.PagedListBuffer;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.io.IOException;
import java.io.ObjectInputStream;

public class BufferedResourceList
extends ResourceList {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private int numberOfPages_ = 5;
    private int pageSize_ = 20;
    private transient PagedListBuffer buffer_ = null;

    public BufferedResourceList() {
        this.initializeTransient();
    }

    public BufferedResourceList(Presentation presentation, ResourceMetaData[] resourceMetaDataArray, ResourceMetaData[] resourceMetaDataArray2, ResourceMetaData[] resourceMetaDataArray3) {
        super(presentation, resourceMetaDataArray, resourceMetaDataArray2, resourceMetaDataArray3);
        this.initializeTransient();
    }

    BufferedResourceList(Presentation presentation, ResourceMetaDataTable resourceMetaDataTable, ResourceMetaDataTable resourceMetaDataTable2, ResourceMetaDataTable resourceMetaDataTable3) {
        super(presentation, resourceMetaDataTable, resourceMetaDataTable2, resourceMetaDataTable3);
        this.initializeTransient();
    }

    public void close() throws ResourceException {
        super.close();
        this.buffer_.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireResourceAdded(Resource resource, long l) {
        BufferedResourceList bufferedResourceList = this;
        synchronized (bufferedResourceList) {
            this.buffer_.setResource(l, resource);
        }
        super.fireResourceAdded(resource, l);
    }

    public int getNumberOfPages() {
        return this.numberOfPages_;
    }

    public int getPageSize() {
        return this.pageSize_;
    }

    private void initializeTransient() {
    }

    public boolean isResourceAvailable(long l) throws ResourceException {
        boolean bl = super.isResourceAvailable(l);
        return bl && this.buffer_.getResource(l) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ResourceException {
        if (this.isOpen()) {
            return;
        }
        super.open();
        BufferedResourceList bufferedResourceList = this;
        synchronized (bufferedResourceList) {
            this.buffer_ = new PagedListBuffer(this.numberOfPages_, this.pageSize_);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void refreshContents() throws ResourceException {
        if (this.isOpen()) {
            this.buffer_.clear();
        }
        super.refreshContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource resourceAt(long l) throws ResourceException {
        BufferedResourceList bufferedResourceList = this;
        synchronized (bufferedResourceList) {
            Resource resource = super.resourceAt(l);
            if (resource == null) {
                BufferedResourceList bufferedResourceList2 = this;
                synchronized (bufferedResourceList2) {
                    return this.buffer_.getResource(l);
                }
            }
            return resource;
        }
    }

    public void setNumberOfPages(int n) {
        if (this.isOpen()) {
            throw new ExtendedIllegalStateException("open", 2);
        }
        if (n <= 0) {
            throw new ExtendedIllegalArgumentException("numberOfPages", 2);
        }
        this.numberOfPages_ = n;
    }

    public void setPageSize(int n) {
        if (this.isOpen()) {
            throw new ExtendedIllegalStateException("open", 2);
        }
        if (n <= 0) {
            throw new ExtendedIllegalArgumentException("pageSize", 2);
        }
        this.pageSize_ = n;
    }
}

