/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Timestamp;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.DateTimeConverter;
import com.ibm.as400.access.DirectoryEntry;
import com.ibm.as400.access.DirectoryEntryList;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserObjectsOwnedList;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class User
implements Serializable {
    static final long serialVersionUID = 5L;
    private static final String[] SPECIAL_AUTHORITIES = new String[]{"*ALLOBJ", "*SECADM", "*JOBCTL", "*SPLCTL", "*SAVSYS", "*SERVICE", "*AUDIT", "*IOSYSCFG"};
    public static final String NONE = "*NONE";
    public static final String SPECIAL_AUTHORITY_ALL_OBJECT = SPECIAL_AUTHORITIES[0];
    public static final String SPECIAL_AUTHORITY_AUDIT = SPECIAL_AUTHORITIES[6];
    public static final String SPECIAL_AUTHORITY_IO_SYSTEM_CONFIGURATION = SPECIAL_AUTHORITIES[7];
    public static final String SPECIAL_AUTHORITY_JOB_CONTROL = SPECIAL_AUTHORITIES[2];
    public static final String SPECIAL_AUTHORITY_SAVE_SYSTEM = SPECIAL_AUTHORITIES[4];
    public static final String SPECIAL_AUTHORITY_SECURITY_ADMINISTRATOR = SPECIAL_AUTHORITIES[1];
    public static final String SPECIAL_AUTHORITY_SERVICE = SPECIAL_AUTHORITIES[5];
    public static final String SPECIAL_AUTHORITY_SPOOL_CONTROL = SPECIAL_AUTHORITIES[3];
    private static final ProgramParameter ERROR_CODE = new ProgramParameter(new byte[8]);
    private AS400 system_ = null;
    private String name_ = null;
    private String description_ = null;
    private boolean groupHasMember_ = false;
    private CommandCall chgUsrPrf_ = null;
    private CommandCall chgUsrAud_ = null;
    private static final boolean COMMAND_CHGUSRPRF = true;
    private static final boolean COMMAND_CHGUSRAUD = false;
    private boolean partiallyLoaded_ = false;
    private boolean loaded_ = false;
    private boolean connected_ = false;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;
    private String userProfileName_;
    private Date previousSignedOnDate_;
    private int signedOnAttemptsNotValid_;
    private String status_;
    private byte[] passwordLastChangedDateBytes_;
    private Date passwordLastChangedDate_;
    private boolean noPassword_;
    private int passwordExpirationInterval_;
    private byte[] passwordExpireDateBytes_;
    private Date passwordExpireDate_;
    private int daysUntilPasswordExpire_;
    private boolean passwordSetExpire_;
    private String userClassName_;
    private String[] specialAuthority_;
    private String groupProfileName_;
    private String owner_;
    private String groupAuthority_;
    private String assistanceLevel_;
    private String currentLibraryName_;
    private String initialMenu_;
    private String initialProgram_;
    private String limitCapabilities_;
    private String displaySignOnInformation_;
    private String limitDeviceSessions_;
    private String keyboardBuffering_;
    private int maximumStorageAllowed_;
    private int storageUsed_;
    private int highestSchedulingPriority_;
    private String jobDescription_;
    private String accountingCode_;
    private String messageQueue_;
    private String messageQueueDeliveryMethod_;
    private int messageQueueSeverity_;
    private String outputQueue_;
    private String printDevice_;
    private String specialEnvironment_;
    private String attentionKeyHandlingProgram_;
    private String languageID_;
    private String countryID_;
    private int ccsid_;
    private String[] userOptions_;
    private String sortSequenceTable_;
    private String objectAuditingValue_;
    private String[] userActionAuditLevel_;
    private String groupAuthorityType_;
    private String[] supplementalGroups_;
    private long userID_;
    private long groupID_;
    private String homeDirectory_;
    private String[] localeJobAttributes_;
    private String localePathName_;
    private boolean withDigitalCertificates_;
    private String chridControl_;
    private String[] iaspNames_;
    private int[] iaspStorageAllowed_;
    private int[] iaspStorageUsed_;
    private boolean localPasswordManagement_;
    private String pwdChangeBlock_;
    private boolean userEntitlementRequired_;
    private int userExpirationInterval_;
    private byte[] userExpirationDateBytes_;
    private Date userExpirationDate_;
    private String userExpirationAction_;
    private transient DateTimeConverter dateConverter_;
    private String jobDateFormat_;
    private transient AS400Timestamp timestampConverter_;
    private static final String[] LOCALE_ATTRIBUTES = new String[]{"*NONE", "*SYSVAL", "*CCSID", "*DATFMT", "*DATSEP", "*SRTSEQ", "*TIMSEP", "*DECFMT"};
    private static final int FORMAT_DTS = 1;
    private static final String[] AUDIT_LEVELS = new String[]{"*CMD", "*CREATE", "*DELETE", "*JOBDTA", "*OBJMGT", "*OFCSRV", "*PGMADP", "*SAVRST", "*SECURITY", "*SERVICE", "*SPLFDTA", "*SYSMGT", "*OPTICAL"};
    private static final String[] USER_OPTIONS = new String[]{"*CLKWD", "*EXPERT", "*HLPFULL", "*STSMSG", "*NOSTSMSG", "*ROLLKEY", "*PRTMSG"};

    public User() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing User object.");
        }
    }

    public User(AS400 aS400, String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing User object, system: " + aS400 + ", name: " + string);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if ((string = string.trim()).length() > 10) {
            Trace.log(2, "Length of parameter 'name' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("name (" + string + ")", 1);
        }
        if ((string.length() == 0 || !Character.isLetter(string.charAt(0))) && Trace.traceOn_) {
            Trace.log(4, "Value of parameter 'name' is not a valid user profile name: '" + string + "'");
        }
        this.system_ = aS400;
        this.name_ = string.toUpperCase();
    }

    User(AS400 aS400, String string, boolean bl, String string2) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing User object, system: " + aS400 + ", name: " + string);
        }
        this.system_ = aS400;
        this.name_ = string;
        this.groupHasMember_ = bl;
        this.description_ = string2;
        this.partiallyLoaded_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        User user = this;
        synchronized (user) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        User user = this;
        synchronized (user) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public boolean exists() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Determining user existence.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            Trace.log(2, "Cannot connect to server before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        try {
            String string = "QSYS/CHKOBJ OBJ(QSYS/" + this.name_ + ") OBJTYPE(*USRPRF) AUT(*NONE)";
            CommandCall commandCall = new CommandCall(this.system_, string);
            if (!commandCall.run()) {
                throw new AS400Exception(commandCall.getMessageList());
            }
        }
        catch (AS400Exception aS400Exception) {
            AS400Message[] aS400MessageArray = aS400Exception.getAS400MessageList();
            if (aS400MessageArray.length == 1 && aS400MessageArray[0].getID().equalsIgnoreCase("CPF9801")) {
                return false;
            }
            throw aS400Exception;
        }
        return true;
    }

    public String getAccountingCode() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.accountingCode_;
    }

    public String getAssistanceLevel() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.assistanceLevel_;
    }

    public String getAttentionKeyHandlingProgram() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.attentionKeyHandlingProgram_;
    }

    public int getCCSID() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.ccsid_;
    }

    public String getCHRIDControl() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.chridControl_;
    }

    public String getCountryID() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.countryID_;
    }

    public String getCurrentLibraryName() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.currentLibraryName_;
    }

    public int getDaysUntilPasswordExpire() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.daysUntilPasswordExpire_;
    }

    public String getDescription() {
        if (!this.loaded_ && !this.partiallyLoaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.description_;
    }

    public DirectoryEntry getDirectoryEntry() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        DirectoryEntryList directoryEntryList = new DirectoryEntryList(this.system_);
        directoryEntryList.addSelection("USER", this.name_.toUpperCase());
        DirectoryEntry[] directoryEntryArray = directoryEntryList.getEntries();
        if (directoryEntryArray.length == 0) {
            return null;
        }
        return directoryEntryArray[0];
    }

    public String getDisplaySignOnInformation() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.displaySignOnInformation_;
    }

    public String getGroupAuthority() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.groupAuthority_;
    }

    public String getGroupAuthorityType() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.groupAuthorityType_;
    }

    public long getGroupID() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.groupID_;
    }

    public int getGroupIDNumber() {
        return (int)this.getGroupID();
    }

    public String getGroupProfileName() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.groupProfileName_;
    }

    public int getHighestSchedulingPriority() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.highestSchedulingPriority_;
    }

    public String getHomeDirectory() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.homeDirectory_;
    }

    public String[] getIASPNames() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.iaspNames_;
    }

    public int getIASPStorageAllowed(String string) {
        if (string == null) {
            Trace.log(2, "Parameter 'iaspName' is null.");
            throw new NullPointerException("iaspName");
        }
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        if (this.iaspStorageAllowed_ == null) {
            return -2;
        }
        for (int i = 0; i < this.iaspNames_.length; ++i) {
            if (!this.iaspNames_[i].equals(string)) continue;
            return this.iaspStorageAllowed_[i];
        }
        return -2;
    }

    public int getIASPStorageUsed(String string) {
        if (string == null) {
            Trace.log(2, "Parameter 'iaspName' is null.");
            throw new NullPointerException("iaspName");
        }
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        if (this.iaspStorageUsed_ == null) {
            return -2;
        }
        for (int i = 0; i < this.iaspNames_.length; ++i) {
            if (!this.iaspNames_[i].equals(string)) continue;
            return this.iaspStorageUsed_[i];
        }
        return -2;
    }

    public String getInitialMenu() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.initialMenu_;
    }

    public String getInitialProgram() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.initialProgram_;
    }

    public String getJobDescription() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.jobDescription_;
    }

    public String getKeyboardBuffering() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.keyboardBuffering_;
    }

    public String getLanguageID() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.languageID_;
    }

    public String getLimitCapabilities() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.limitCapabilities_;
    }

    public String getLimitDeviceSessions() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.limitDeviceSessions_;
    }

    public String[] getLocaleJobAttributes() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.localeJobAttributes_;
    }

    public String getLocalePathName() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.localePathName_;
    }

    public int getMaximumStorageAllowed() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.maximumStorageAllowed_;
    }

    public String getMessageQueue() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.messageQueue_;
    }

    public String getMessageQueueDeliveryMethod() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.messageQueueDeliveryMethod_;
    }

    public int getMessageQueueSeverity() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.messageQueueSeverity_;
    }

    public String getName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting name: " + this.name_);
        }
        return this.name_;
    }

    public String getObjectAuditingValue() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.objectAuditingValue_;
    }

    public UserObjectsOwnedList getObjectsOwned() {
        if (Trace.traceOn_) {
            Trace.log(1, "Loading user information.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            Trace.log(2, "Cannot connect to server before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        return new UserObjectsOwnedList(this.system_, this.name_);
    }

    public String getOutputQueue() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.outputQueue_;
    }

    public String getOwner() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.owner_;
    }

    public Date getPasswordExpireDate() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        if (this.passwordExpireDate_ == null) {
            try {
                if (User.isNullOrBlanks(this.passwordExpireDateBytes_)) {
                    return null;
                }
                AS400Timestamp aS400Timestamp = this.getTimestampConverter(1);
                this.passwordExpireDate_ = aS400Timestamp.toDate(aS400Timestamp.toTimestamp(this.passwordExpireDateBytes_), TimeZone.getDefault());
            }
            catch (Exception exception) {
                if (Trace.traceOn_) {
                    Trace.log(2, "Exception while converting datePasswordExpires:", (Throwable)exception);
                }
                throw new InternalErrorException(10, (Throwable)exception);
            }
        }
        return this.passwordExpireDate_;
    }

    private synchronized AS400Timestamp getTimestampConverter(int n) {
        if (this.timestampConverter_ == null) {
            this.timestampConverter_ = new AS400Timestamp(AS400.getDefaultTimeZone(this.system_));
            this.timestampConverter_.setFormat(n);
        } else if (n != this.timestampConverter_.getFormat()) {
            this.timestampConverter_.setFormat(n);
        }
        return this.timestampConverter_;
    }

    public String getPasswordChangeBlock() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.pwdChangeBlock_;
    }

    public int getPasswordExpirationInterval() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.passwordExpirationInterval_;
    }

    public Date getPasswordLastChangedDate() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        if (this.passwordLastChangedDate_ == null) {
            try {
                if (User.isNullOrBlanks(this.passwordLastChangedDateBytes_)) {
                    return null;
                }
                AS400Timestamp aS400Timestamp = this.getTimestampConverter(1);
                this.passwordLastChangedDate_ = aS400Timestamp.toDate(aS400Timestamp.toTimestamp(this.passwordLastChangedDateBytes_), TimeZone.getDefault());
            }
            catch (Exception exception) {
                Trace.log(2, "Exception while converting passwordLastChangedDate:", (Throwable)exception);
                throw new InternalErrorException(10, (Throwable)exception);
            }
        }
        return this.passwordLastChangedDate_;
    }

    public Date getPreviousSignedOnDate() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.previousSignedOnDate_;
    }

    public String getPrintDevice() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.printDevice_;
    }

    public int getSignedOnAttemptsNotValid() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.signedOnAttemptsNotValid_;
    }

    public String getSortSequenceTable() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.sortSequenceTable_;
    }

    public String[] getSpecialAuthority() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.specialAuthority_;
    }

    public String getSpecialEnvironment() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.specialEnvironment_;
    }

    public String getStatus() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.status_;
    }

    public int getStorageUsed() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.storageUsed_;
    }

    public String[] getSupplementalGroups() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.supplementalGroups_;
    }

    public int getSupplementalGroupsNumber() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.supplementalGroups_ == null ? 0 : this.supplementalGroups_.length;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public String[] getUserActionAuditLevel() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.userActionAuditLevel_;
    }

    public String getUserClassName() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.userClassName_;
    }

    public String getUserExpirationAction() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.userExpirationAction_;
    }

    public Date getUserExpirationDate() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        if (this.userExpirationDate_ == null) {
            try {
                if (User.isNullOrBlanks(this.userExpirationDateBytes_)) {
                    return null;
                }
                AS400Timestamp aS400Timestamp = this.getTimestampConverter(1);
                this.userExpirationDate_ = aS400Timestamp.toDate(aS400Timestamp.toTimestamp(this.userExpirationDateBytes_), TimeZone.getDefault());
            }
            catch (Exception exception) {
                if (Trace.traceOn_) {
                    Trace.log(2, "Exception while converting userExpirationDate:", (Throwable)exception);
                }
                throw new InternalErrorException(10, (Throwable)exception);
            }
        }
        return this.userExpirationDate_;
    }

    private static final boolean isNullOrBlanks(byte[] byArray) {
        if (byArray == null) {
            return true;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 64) continue;
            return false;
        }
        return true;
    }

    public int getUserExpirationInterval() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.userExpirationInterval_;
    }

    public long getUserID() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.userID_;
    }

    public int getUserIDNumber() {
        return (int)this.getUserID();
    }

    public String[] getUserOptions() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.userOptions_;
    }

    public String getUserProfileName() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.userProfileName_;
    }

    public boolean hasSpecialAuthority(String string) {
        Object object;
        String string2;
        if (string == null) {
            Trace.log(2, "Parameter 'authority' is null.");
            throw new NullPointerException("authority");
        }
        String[] stringArray = this.getSpecialAuthority();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                return true;
            }
        }
        if ((string2 = this.getGroupProfileName()) != null && !string2.equals(NONE)) {
            try {
                object = new User(this.system_, string2);
                if (((User)object).hasSpecialAuthority(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                Trace.log(2, "Unexpected Exception constructing User object:", (Throwable)exception);
                throw new InternalErrorException(10, (Throwable)exception);
            }
        }
        if ((object = this.getSupplementalGroups()) != null) {
            for (int i = 0; i < ((String[])object).length; ++i) {
                try {
                    User user = new User(this.system_, (String)object[i]);
                    if (!user.hasSpecialAuthority(string)) continue;
                    return true;
                }
                catch (Exception exception) {
                    Trace.log(2, "Unexpected Exception constructing User object:", (Throwable)exception);
                    throw new InternalErrorException(10, (Throwable)exception);
                }
            }
        }
        return false;
    }

    public boolean isGroupHasMember() {
        if (!this.loaded_ && !this.partiallyLoaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.groupHasMember_;
    }

    public boolean isLocalPasswordManagement() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.localPasswordManagement_;
    }

    public boolean isNoPassword() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.noPassword_;
    }

    public boolean isPasswordSetExpire() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.passwordSetExpire_;
    }

    public boolean isUserEntitlementRequired() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.userEntitlementRequired_;
    }

    public boolean isWithDigitalCertificates() {
        if (!this.loaded_) {
            this.loadUserInformation_SwallowExceptions();
        }
        return this.withDigitalCertificates_;
    }

    private void loadUserInformation_SwallowExceptions() {
        try {
            this.loadUserInformation();
        }
        catch (Exception exception) {
            Trace.log(2, "Exception swallowed during retrieval of user information:", (Throwable)exception);
        }
    }

    public void loadUserInformation() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (Trace.traceOn_) {
            Trace.log(1, "Loading user information.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            Trace.log(2, "Cannot connect to server before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        Converter converter = new Converter(this.system_.getCcsid(), this.system_);
        byte[] byArray = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        converter.stringToByteArray(this.name_, byArray);
        int n8 = 1024;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n8), new ProgramParameter(BinaryConverter.intToByteArray(n8)), new ProgramParameter(new byte[]{-28, -30, -39, -55, -16, -13, -16, -16}), new ProgramParameter(byArray), ERROR_CODE};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QSYRUSRI.PGM", programParameterArray);
        programCall.suggestThreadsafe();
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray2 = programParameterArray[0].getOutputData();
        int n9 = BinaryConverter.byteArrayToInt(byArray2, 0);
        if (n9 < (n7 = BinaryConverter.byteArrayToInt(byArray2, 4))) {
            if (Trace.traceOn_) {
                Trace.log(1, "Retrieve user information receiver variable too small, bytes returned: " + n9 + ", bytes available: " + n7);
            }
            n8 = n7;
            try {
                programParameterArray[0].setOutputDataLength(n8);
                programParameterArray[1].setInputData(BinaryConverter.intToByteArray(n8));
            }
            catch (PropertyVetoException propertyVetoException) {
                Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
                throw new InternalErrorException(10, (Throwable)propertyVetoException);
            }
            if (!programCall.run()) {
                throw new AS400Exception(programCall.getMessageList());
            }
            byArray2 = programParameterArray[0].getOutputData();
        }
        this.userProfileName_ = converter.byteArrayToString(byArray2, 8, 10).trim();
        String string = converter.byteArrayToString(byArray2, 18, 13);
        if (string.trim().length() > 0) {
            Calendar calendar = AS400Calendar.getGregorianInstance();
            calendar.clear();
            calendar.set(1, 1900 + Integer.parseInt(string.substring(0, 3)));
            calendar.set(2, Integer.parseInt(string.substring(3, 5)) - 1);
            calendar.set(5, Integer.parseInt(string.substring(5, 7)));
            calendar.set(10, Integer.parseInt(string.substring(7, 9)));
            calendar.set(12, Integer.parseInt(string.substring(9, 11)));
            calendar.set(13, Integer.parseInt(string.substring(11, 13)));
            calendar.setTimeZone(this.system_.getTimeZone());
            this.previousSignedOnDate_ = calendar.getTime();
        } else {
            this.previousSignedOnDate_ = null;
        }
        this.signedOnAttemptsNotValid_ = BinaryConverter.byteArrayToInt(byArray2, 32);
        this.status_ = converter.byteArrayToString(byArray2, 36, 10).trim();
        if (this.passwordLastChangedDateBytes_ == null) {
            this.passwordLastChangedDateBytes_ = new byte[8];
        }
        System.arraycopy(byArray2, 46, this.passwordLastChangedDateBytes_, 0, 8);
        this.passwordLastChangedDate_ = null;
        this.noPassword_ = byArray2[54] == -24;
        this.passwordExpirationInterval_ = BinaryConverter.byteArrayToInt(byArray2, 56);
        if (this.passwordExpireDateBytes_ == null) {
            this.passwordExpireDateBytes_ = new byte[8];
        }
        System.arraycopy(byArray2, 60, this.passwordExpireDateBytes_, 0, 8);
        this.passwordExpireDate_ = null;
        this.daysUntilPasswordExpire_ = BinaryConverter.byteArrayToInt(byArray2, 68);
        this.passwordSetExpire_ = byArray2[72] == -24;
        this.userClassName_ = converter.byteArrayToString(byArray2, 73, 10).trim();
        int n10 = 0;
        for (n6 = 0; n6 < 8; ++n6) {
            if (byArray2[83 + n6] != -24) continue;
            ++n10;
        }
        this.specialAuthority_ = new String[n10];
        n6 = 0;
        for (int i = 0; i < 8; ++i) {
            if (byArray2[83 + i] != -24) continue;
            this.specialAuthority_[n6++] = SPECIAL_AUTHORITIES[i];
        }
        this.groupProfileName_ = converter.byteArrayToString(byArray2, 98, 10).trim();
        this.owner_ = converter.byteArrayToString(byArray2, 108, 10).trim();
        this.groupAuthority_ = converter.byteArrayToString(byArray2, 118, 10).trim();
        this.assistanceLevel_ = converter.byteArrayToString(byArray2, 128, 10).trim();
        this.currentLibraryName_ = converter.byteArrayToString(byArray2, 138, 10).trim();
        String string2 = converter.byteArrayToString(byArray2, 148, 10).trim();
        this.initialMenu_ = string2.equals("*SIGNOFF") ? string2 : QSYSObjectPathName.toPath(converter.byteArrayToString(byArray2, 158, 10).trim(), string2, "MNU");
        String string3 = converter.byteArrayToString(byArray2, 168, 10).trim();
        this.initialProgram_ = string3.equals(NONE) ? NONE : QSYSObjectPathName.toPath(converter.byteArrayToString(byArray2, 178, 10).trim(), string3, "PGM");
        this.limitCapabilities_ = converter.byteArrayToString(byArray2, 188, 10).trim();
        this.description_ = converter.byteArrayToString(byArray2, 198, 50).trim();
        this.displaySignOnInformation_ = converter.byteArrayToString(byArray2, 248, 10).trim();
        this.limitDeviceSessions_ = converter.byteArrayToString(byArray2, 258, 10).trim();
        this.keyboardBuffering_ = converter.byteArrayToString(byArray2, 268, 10).trim();
        this.maximumStorageAllowed_ = BinaryConverter.byteArrayToInt(byArray2, 280);
        this.storageUsed_ = BinaryConverter.byteArrayToInt(byArray2, 284);
        this.highestSchedulingPriority_ = byArray2[288] & 0xF;
        this.jobDescription_ = QSYSObjectPathName.toPath(converter.byteArrayToString(byArray2, 299, 10).trim(), converter.byteArrayToString(byArray2, 289, 10).trim(), "JOBD");
        this.accountingCode_ = converter.byteArrayToString(byArray2, 309, 15).trim();
        this.messageQueue_ = QSYSObjectPathName.toPath(converter.byteArrayToString(byArray2, 334, 10).trim(), converter.byteArrayToString(byArray2, 324, 10).trim(), "MSGQ");
        this.messageQueueDeliveryMethod_ = converter.byteArrayToString(byArray2, 344, 10).trim();
        this.messageQueueSeverity_ = BinaryConverter.byteArrayToInt(byArray2, 356);
        String string4 = converter.byteArrayToString(byArray2, 360, 10).trim();
        this.outputQueue_ = string4.equals("*WRKSTN") || string4.equals("*DEV") ? string4 : QSYSObjectPathName.toPath(converter.byteArrayToString(byArray2, 370, 10).trim(), string4, "OUTQ");
        this.printDevice_ = converter.byteArrayToString(byArray2, 380, 10).trim();
        this.specialEnvironment_ = converter.byteArrayToString(byArray2, 390, 10).trim();
        String string5 = converter.byteArrayToString(byArray2, 400, 10).trim();
        this.attentionKeyHandlingProgram_ = string5.equals(NONE) || string5.equals("*SYSVAL") ? string5 : QSYSObjectPathName.toPath(converter.byteArrayToString(byArray2, 410, 10).trim(), string5, "PGM");
        this.languageID_ = converter.byteArrayToString(byArray2, 420, 10).trim();
        this.countryID_ = converter.byteArrayToString(byArray2, 430, 10).trim();
        this.ccsid_ = BinaryConverter.byteArrayToInt(byArray2, 440);
        int n11 = 0;
        for (n5 = 0; n5 < 7; ++n5) {
            if (byArray2[444 + n5] != -24) continue;
            ++n11;
        }
        this.userOptions_ = new String[n11];
        n6 = 0;
        for (n5 = 0; n5 < 7; ++n5) {
            if (byArray2[444 + n5] != -24) continue;
            this.userOptions_[n6++] = USER_OPTIONS[n5];
        }
        String string6 = converter.byteArrayToString(byArray2, 480, 10).trim();
        this.sortSequenceTable_ = string6.equals("*HEX") || string6.equals("*LANGIDUNQ") || string6.equals("*LANGIDSHR") || string6.equals("*SYSVAL") || string6.length() == 0 ? string6 : QSYSObjectPathName.toPath(converter.byteArrayToString(byArray2, 490, 10).trim(), string6, "FILE");
        this.objectAuditingValue_ = converter.byteArrayToString(byArray2, 500, 10).trim();
        int n12 = 0;
        for (n4 = 0; n4 < 13; ++n4) {
            if (byArray2[510 + n4] != -24) continue;
            ++n12;
        }
        this.userActionAuditLevel_ = new String[n12];
        n6 = 0;
        for (n4 = 0; n4 < 13; ++n4) {
            if (byArray2[510 + n4] != -24) continue;
            this.userActionAuditLevel_[n6++] = AUDIT_LEVELS[n4];
        }
        this.groupAuthorityType_ = converter.byteArrayToString(byArray2, 574, 10).trim();
        n4 = BinaryConverter.byteArrayToInt(byArray2, 584);
        int n13 = BinaryConverter.byteArrayToInt(byArray2, 588);
        this.supplementalGroups_ = new String[n13];
        for (n3 = 0; n3 < n13; ++n3) {
            this.supplementalGroups_[n3] = converter.byteArrayToString(byArray2, n4 + n3 * 10, 10).trim();
        }
        this.userID_ = BinaryConverter.byteArrayToUnsignedInt(byArray2, 592);
        this.groupID_ = BinaryConverter.byteArrayToUnsignedInt(byArray2, 596);
        n3 = BinaryConverter.byteArrayToInt(byArray2, 600);
        int n14 = BinaryConverter.byteArrayToInt(byArray2, n3);
        int n15 = BinaryConverter.byteArrayToInt(byArray2, n3 + 16);
        Converter converter2 = n14 > 0 && n14 < 65535 ? new Converter(n14, this.system_) : converter;
        this.homeDirectory_ = converter2.byteArrayToString(byArray2, n3 + 32, n15).trim();
        int n16 = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            if (byArray2[608 + n2] != -24) continue;
            ++n16;
        }
        this.localeJobAttributes_ = new String[n16];
        n6 = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            if (byArray2[608 + n2] != -24) continue;
            this.localeJobAttributes_[n6++] = LOCALE_ATTRIBUTES[n2];
        }
        n2 = BinaryConverter.byteArrayToInt(byArray2, 624);
        int n17 = BinaryConverter.byteArrayToInt(byArray2, 628);
        if (n17 == 10) {
            this.localePathName_ = converter.byteArrayToString(byArray2, n2, n17).trim();
        } else {
            n = BinaryConverter.byteArrayToInt(byArray2, n2);
            n17 = BinaryConverter.byteArrayToInt(byArray2, n2 + 16);
            Converter converter3 = n > 0 && n < 65535 ? new Converter(n, this.system_) : converter;
            this.localePathName_ = converter3.byteArrayToString(byArray2, n2 + 32, n17).trim();
        }
        this.groupHasMember_ = byArray2[632] == -15;
        this.withDigitalCertificates_ = byArray2[633] == -15;
        this.chridControl_ = converter.byteArrayToString(byArray2, 634, 10).trim();
        n = this.system_.getVRM();
        if (n >= 327936) {
            int n18 = BinaryConverter.byteArrayToInt(byArray2, 644);
            int n19 = BinaryConverter.byteArrayToInt(byArray2, 648);
            int n20 = BinaryConverter.byteArrayToInt(byArray2, 652);
            int n21 = BinaryConverter.byteArrayToInt(byArray2, 656);
            if (Trace.traceOn_ && n19 != n20) {
                Trace.log(4, "Not all IASP information was returned, count: " + n19 + ", returned:", n20);
            }
            this.iaspNames_ = new String[n20];
            this.iaspStorageAllowed_ = new int[n20];
            this.iaspStorageUsed_ = new int[n20];
            for (int i = 0; i < n20; ++i) {
                int n22 = n18 + i * n21;
                this.iaspNames_[i] = converter.byteArrayToString(byArray2, n22, 10).trim();
                this.iaspStorageAllowed_[i] = BinaryConverter.byteArrayToInt(byArray2, n22 + 12);
                this.iaspStorageUsed_[i] = BinaryConverter.byteArrayToInt(byArray2, n22 + 16);
            }
            if (n >= 328448) {
                boolean bl = this.localPasswordManagement_ = byArray2[660] == -24;
                if (n >= 393472) {
                    this.pwdChangeBlock_ = converter.byteArrayToString(byArray2, 661, 10).trim();
                    boolean bl2 = this.userEntitlementRequired_ = byArray2[671] == -15;
                    if (n >= 459008) {
                        this.userExpirationInterval_ = BinaryConverter.byteArrayToInt(byArray2, 672);
                        if (this.userExpirationDateBytes_ == null) {
                            this.userExpirationDateBytes_ = new byte[8];
                        }
                        System.arraycopy(byArray2, 676, this.userExpirationDateBytes_, 0, 8);
                        this.userExpirationDate_ = null;
                        this.userExpirationAction_ = converter.byteArrayToString(byArray2, 684, 10).trim();
                    }
                }
            }
        }
        this.loaded_ = true;
        this.connected_ = true;
    }

    public void refresh() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadUserInformation();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    private void runCommand(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Changing user profile.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            Trace.log(2, "Cannot connect to server before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        CommandCall commandCall = this.getCommandCallObject(true);
        try {
            commandCall.setCommand("QSYS/CHGUSRPRF USRPRF(" + this.name_ + ") " + string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
        this.loaded_ = false;
        this.connected_ = true;
    }

    private final CommandCall getCommandCallObject(boolean bl) {
        if (bl) {
            if (this.chgUsrPrf_ == null) {
                this.chgUsrPrf_ = new CommandCall(this.system_);
                this.chgUsrPrf_.suggestThreadsafe(false);
            }
            return this.chgUsrPrf_;
        }
        if (this.chgUsrAud_ == null) {
            this.chgUsrAud_ = new CommandCall(this.system_);
            this.chgUsrAud_.suggestThreadsafe(false);
        }
        return this.chgUsrAud_;
    }

    private void runCommandAud(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Changing user auditing.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            Trace.log(2, "Cannot connect to server before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        CommandCall commandCall = this.getCommandCallObject(false);
        try {
            commandCall.setCommand("QSYS/CHGUSRAUD USRPRF(" + this.name_ + ") " + string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (!commandCall.run()) {
            throw new AS400Exception(commandCall.getMessageList());
        }
        this.loaded_ = false;
        this.connected_ = true;
    }

    public void setAccountingCode(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'accountingCode' is null.");
            throw new NullPointerException("accountingCode");
        }
        if (string.equals("*BLANK")) {
            this.runCommand("ACGCDE(*BLANK)");
        } else {
            this.runCommand("ACGCDE('" + string + "')");
        }
    }

    private static String setArrayToString(String[] stringArray) {
        int n = stringArray.length;
        if (n == 0) {
            return NONE;
        }
        if (n == 1) {
            return stringArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public void setAssistanceLevel(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'assistanceLevel' is null.");
            throw new NullPointerException("assistanceLevel");
        }
        this.runCommand("ASTLVL(" + string + ")");
    }

    public void setAttentionKeyHandlingProgram(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'attentionKeyHandlingProgram' is null.");
            throw new NullPointerException("attentionKeyHandlingProgram");
        }
        if (string.length() == 0 || string.startsWith("*")) {
            this.runCommand("ATNPGM(" + string + ")");
        } else {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "PGM");
            this.runCommand("ATNPGM(" + qSYSObjectPathName.getLibraryName() + "/" + qSYSObjectPathName.getObjectName() + ")");
        }
    }

    public void setCCSID(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.runCommand("CCSID(" + (n == -2 ? "*SYSVAL" : Integer.toString(n)) + ")");
    }

    public void setCCSID(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'ccsid' is null.");
            throw new NullPointerException("ccsid");
        }
        this.runCommand("CCSID(" + string + ")");
    }

    public void setCHRIDControl(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'chridControl' is null.");
            throw new NullPointerException("chridControl");
        }
        this.runCommand("CHRIDCTL(" + string + ")");
    }

    public void setCountryID(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'countryID' is null.");
            throw new NullPointerException("countryID");
        }
        this.runCommand("CNTRYID(" + string + ")");
    }

    public void setCurrentLibraryName(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'currentLibraryName' is null.");
            throw new NullPointerException("currentLibraryName");
        }
        this.runCommand("CURLIB(" + string + ")");
    }

    public void setDescription(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'description' is null.");
            throw new NullPointerException("description");
        }
        if (string.equals("*BLANK")) {
            this.runCommand("TEXT(*BLANK)");
        } else {
            this.runCommand("TEXT('" + string + "')");
        }
    }

    public void setDisplaySignOnInformation(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'displaySignOnInformation' is null.");
            throw new NullPointerException("displaySignOnInformation");
        }
        this.runCommand("DSPSGNINF(" + string + ")");
    }

    public void setGroupAuthority(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'groupAuthority' is null.");
            throw new NullPointerException("groupAuthority");
        }
        this.runCommand("GRPAUT(" + string + ")");
    }

    public void setGroupAuthorityType(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'groupAuthorityType' is null.");
            throw new NullPointerException("groupAuthorityType");
        }
        this.runCommand("GRPAUTTYP(" + string + ")");
    }

    public void setGroupID(long l) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (l == 0L) {
            this.runCommand("GID(*NONE)");
        } else {
            this.runCommand("GID(" + Long.toString(l) + ")");
        }
    }

    public void setGroupID(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'groupID' is null.");
            throw new NullPointerException("groupID");
        }
        this.runCommand("GID(" + string + ")");
    }

    public void setGroupProfileName(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'groupProfileName' is null.");
            throw new NullPointerException("groupProfileName");
        }
        this.runCommand("GRPPRF(" + string + ")");
    }

    public void setHighestSchedulingPriority(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.runCommand("PTYLMT(" + Integer.toString(n) + ")");
    }

    public void setHomeDirectory(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'homeDirectory' is null.");
            throw new NullPointerException("homeDirectory");
        }
        if (string.length() == 0 || string.startsWith("*")) {
            this.runCommand("HOMEDIR(" + string + ")");
        } else {
            this.runCommand("HOMEDIR('" + string + "')");
        }
    }

    public void setInitialMenu(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'initialMenu' is null.");
            throw new NullPointerException("initialMenu");
        }
        if (string.length() == 0 || string.startsWith("*")) {
            this.runCommand("INLMNU(" + string + ")");
        } else {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "MNU");
            this.runCommand("INLMNU(" + qSYSObjectPathName.getLibraryName() + "/" + qSYSObjectPathName.getObjectName() + ")");
        }
    }

    public void setInitialProgram(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'initialProgram' is null.");
            throw new NullPointerException("initialProgram");
        }
        if (string.length() == 0 || string.startsWith("*")) {
            this.runCommand("INLPGM(" + string + ")");
        } else {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "PGM");
            this.runCommand("INLPGM(" + qSYSObjectPathName.getLibraryName() + "/" + qSYSObjectPathName.getObjectName() + ")");
        }
    }

    public void setJobDescription(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'jobDescription' is null.");
            throw new NullPointerException("jobDescription");
        }
        if (string.length() == 0 || string.startsWith("*")) {
            this.runCommand("JOBD(" + string + ")");
        } else {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "JOBD");
            this.runCommand("JOBD(" + qSYSObjectPathName.getLibraryName() + "/" + qSYSObjectPathName.getObjectName() + ")");
        }
    }

    public void setKeyboardBuffering(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'keyboardBuffering' is null.");
            throw new NullPointerException("keyboardBuffering");
        }
        this.runCommand("KBDBUF(" + string + ")");
    }

    public void setLanguageID(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'languageID' is null.");
            throw new NullPointerException("languageID");
        }
        this.runCommand("LANGID(" + string + ")");
    }

    public void setLimitCapabilities(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'limitCapabilities' is null.");
            throw new NullPointerException("limitCapabilities");
        }
        this.runCommand("LMTCPB(" + string + ")");
    }

    public void setLimitDeviceSessions(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'limitDeviceSessions' is null.");
            throw new NullPointerException("limitDeviceSessions");
        }
        this.runCommand("LMTDEVSSN(" + string + ")");
    }

    public void setLocaleJobAttributes(String[] stringArray) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (stringArray == null) {
            Trace.log(2, "Parameter 'localeJobAttributes' is null.");
            throw new NullPointerException("localeJobAttributes");
        }
        this.runCommand("SETJOBATR(" + User.setArrayToString(stringArray) + ")");
    }

    public void setLocalePathName(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'localePathName' is null.");
            throw new NullPointerException("localePathName");
        }
        if (string.length() == 0 || string.startsWith("*")) {
            this.runCommand("LOCALE(" + string + ")");
        } else {
            this.runCommand("LOCALE('" + string + "')");
        }
    }

    public void setLocalPasswordManagement(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.runCommand("LCLPWDMGT(" + (bl ? "*YES" : "*NO") + ")");
    }

    public void setMaximumStorageAllowed(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.runCommand("MAXSTG(" + (n == -1 ? "*NOMAX" : Integer.toString(n)) + ")");
    }

    public void setMaximumStorageAllowed(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'maximumStorageAllowed' is null.");
            throw new NullPointerException("maximumStorageAllowed");
        }
        this.runCommand("MAXSTG(" + string + ")");
    }

    public void setMessageQueue(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'messageQueue' is null.");
            throw new NullPointerException("messageQueue");
        }
        if (string.length() == 0 || string.startsWith("*")) {
            this.runCommand("MSGQ(" + string + ")");
        } else {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "MSGQ");
            this.runCommand("MSGQ(" + qSYSObjectPathName.getLibraryName() + "/" + qSYSObjectPathName.getObjectName() + ")");
        }
    }

    public void setMessageQueueDeliveryMethod(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'messageQueueDeliveryMethod' is null.");
            throw new NullPointerException("messageQueueDeliveryMethod");
        }
        this.runCommand("DLVRY(" + string + ")");
    }

    public void setMessageQueueSeverity(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.runCommand("SEV(" + Integer.toString(n) + ")");
    }

    public void setName(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting name: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if ((string = string.trim()).length() > 10) {
            Trace.log(2, "Length of parameter 'name' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("name (" + string + ")", 1);
        }
        if (string.equalsIgnoreCase(NONE)) {
            Trace.log(2, "Value of parameter 'name' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("name (" + string + ")", 2);
        }
        if (this.connected_) {
            Trace.log(2, "Cannot set property 'name' after connect.");
            throw new ExtendedIllegalStateException("name", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.name_ = string.toUpperCase();
        } else {
            String string2 = this.name_;
            String string3 = string.toUpperCase();
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("name", string2, string3);
            }
            this.name_ = string3;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("name", string2, string3);
            }
        }
    }

    public void setObjectAuditingValue(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'objectAuditingValue' is null.");
            throw new NullPointerException("objectAuditingValue");
        }
        this.runCommandAud("OBJAUD(" + string + ")");
    }

    public void setOutputQueue(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'outputQueue' is null.");
            throw new NullPointerException("outputQueue");
        }
        if (string.length() == 0 || string.startsWith("*")) {
            this.runCommand("OUTQ(" + string + ")");
        } else {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "OUTQ");
            this.runCommand("OUTQ(" + qSYSObjectPathName.getLibraryName() + "/" + qSYSObjectPathName.getObjectName() + ")");
        }
    }

    public void setOwner(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'owner' is null.");
            throw new NullPointerException("owner");
        }
        this.runCommand("OWNER(" + string + ")");
    }

    public void setPasswordChangeBlock(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'pwdChangeBlock' is null.");
            throw new NullPointerException("pwdChangeBlock");
        }
        this.runCommand("PWDCHGBLK(" + string + ")");
    }

    public void setPasswordExpirationInterval(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.runCommand("PWDEXPITV(" + (n == -1 ? "*NOMAX" : (n == 0 ? "*SYSVAL" : Integer.toString(n))) + ")");
    }

    public void setPasswordExpirationInterval(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'passwordExpirationInterval' is null.");
            throw new NullPointerException("passwordExpirationInterval");
        }
        this.runCommand("PWDEXPITV(" + string + ")");
    }

    public void setPasswordSetExpire(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.runCommand("PWDEXP(" + (bl ? "*YES" : "*NO") + ")");
    }

    public void setPrintDevice(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'printDevice' is null.");
            throw new NullPointerException("printDevice");
        }
        this.runCommand("PRTDEV(" + string + ")");
    }

    public void setSortSequenceTable(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'sortSequenceTable' is null.");
            throw new NullPointerException("sortSequenceTable");
        }
        if (string.length() == 0 || string.startsWith("*")) {
            this.runCommand("SRTSEQ(" + string + ")");
        } else {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "FILE");
            this.runCommand("SRTSEQ(" + qSYSObjectPathName.getLibraryName() + "/" + qSYSObjectPathName.getObjectName() + ")");
        }
    }

    public void setSpecialAuthority(String[] stringArray) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (stringArray == null) {
            Trace.log(2, "Parameter 'specialAuthority' is null.");
            throw new NullPointerException("specialAuthority");
        }
        this.runCommand("SPCAUT(" + User.setArrayToString(stringArray) + ")");
    }

    public void setSpecialEnvironment(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'specialEnvironment' is null.");
            throw new NullPointerException("specialEnvironment");
        }
        this.runCommand("SPCENV(" + string + ")");
    }

    public void setStatus(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'status' is null.");
            throw new NullPointerException("status");
        }
        this.runCommand("STATUS(" + string + ")");
    }

    public void setSupplementalGroups(String[] stringArray) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (stringArray == null) {
            Trace.log(2, "Parameter 'supplementalGroups' is null.");
            throw new NullPointerException("supplementalGroups");
        }
        this.runCommand("SUPGRPPRF(" + User.setArrayToString(stringArray) + ")");
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = aS400;
        } else {
            AS400 aS4002 = this.system_;
            AS400 aS4003 = aS400;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", aS4002, aS4003);
            }
            this.system_ = aS400;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS4003);
            }
        }
    }

    public void setUserActionAuditLevel(String[] stringArray) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (stringArray == null) {
            Trace.log(2, "Parameter 'userActionAuditLevel' is null.");
            throw new NullPointerException("userActionAuditLevel");
        }
        this.runCommandAud("AUDLVL(" + User.setArrayToString(stringArray) + ")");
    }

    public void setUserClassName(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (string == null) {
            Trace.log(2, "Parameter 'userClassName' is null.");
            throw new NullPointerException("userClassName");
        }
        this.runCommand("USRCLS(" + string + ")");
    }

    public void setUserExpirationDate(Date date) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException, ObjectDoesNotExistException {
        String string;
        if (this.system_.getVRM() < 459008) {
            String string2 = this.system_.getVersion() + "." + this.system_.getRelease();
            throw new RequestNotSupportedException(string2, 1);
        }
        if (date == null) {
            string = NONE;
        } else {
            String string3 = this.getJobDateFormat();
            byte[] byArray = this.getDateTimeConverter().convert(date, string3);
            string = DateTimeConverter.formatDateForCommandParameter(byArray, string3);
        }
        this.runCommand("USREXPDATE(" + string + ")");
    }

    private final DateTimeConverter getDateTimeConverter() {
        if (this.dateConverter_ == null) {
            this.dateConverter_ = new DateTimeConverter(this.system_);
        }
        return this.dateConverter_;
    }

    private final String getJobDateFormat() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.jobDateFormat_ == null) {
            CommandCall commandCall = this.getCommandCallObject(true);
            Job job = commandCall.getServerJob();
            this.jobDateFormat_ = job.getDateFormat();
        }
        return this.jobDateFormat_;
    }

    public void setUserExpirationInterval(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        if (this.system_.getVRM() < 459008) {
            String string = this.system_.getVersion() + "." + this.system_.getRelease();
            throw new RequestNotSupportedException(string, 1);
        }
        if (n < 1 || n > 366) {
            throw new ExtendedIllegalArgumentException("expirationInterval (" + n + ")", 4);
        }
        this.runCommand("USREXPITV(" + n + ") USREXPDATE(*USREXPITV)");
    }

    public void setUserID(long l) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        this.runCommand("UID(" + Long.toString(l) + ")");
    }

    public void setUserOptions(String[] stringArray) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (stringArray == null) {
            Trace.log(2, "Parameter 'userOptions' is null.");
            throw new NullPointerException("userOptions");
        }
        this.runCommand("USROPT(" + User.setArrayToString(stringArray) + ")");
    }

    public String toString() {
        return super.toString() + "[" + this.name_ + "]";
    }
}

