/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLLocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLNClobLocator
implements SQLLocator {
    private AS400JDBCConnection connection_;
    private SQLConversionSettings settings_;
    private ConvTable converter_;
    private int id_;
    private JDLobLocator locator_;
    private int maxLength_;
    private int truncated_;
    private boolean outOfBounds_;
    private int columnIndex_;
    private String value_;
    private Object savedObject_;
    private int scale_;

    SQLNClobLocator(AS400JDBCConnection aS400JDBCConnection, int n, int n2, SQLConversionSettings sQLConversionSettings, ConvTable convTable, int n3) {
        this.connection_ = aS400JDBCConnection;
        this.id_ = n;
        this.locator_ = new JDLobLocator(aS400JDBCConnection, n, n2, false);
        this.maxLength_ = n2;
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        this.settings_ = sQLConversionSettings;
        this.converter_ = convTable;
        this.columnIndex_ = n3;
    }

    public Object clone() {
        return new SQLNClobLocator(this.connection_, this.id_, this.maxLength_, this.settings_, this.converter_, this.columnIndex_);
    }

    public void setHandle(int n) {
        this.locator_.setHandle(n);
    }

    public int getHandle() {
        return this.locator_.getHandle();
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        int n2 = BinaryConverter.byteArrayToInt(byArray, n);
        this.locator_.setHandle(n2);
        this.locator_.setColumnIndex(this.columnIndex_);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.intToByteArray(this.locator_.getHandle(), byArray, n);
        if (this.savedObject_ != null) {
            this.writeToServer();
        }
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof String) {
            String string = (String)object;
            this.truncated_ = string.length() > this.maxLength_ ? string.length() - this.maxLength_ : 0;
            this.outOfBounds_ = false;
        } else if (!(object instanceof Reader || object instanceof InputStream || object instanceof Clob)) {
            JDError.throwSQLException((Object)this, "07006");
        }
        this.savedObject_ = object;
        if (n != -1) {
            this.scale_ = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        int n = this.scale_;
        if (n == -1) {
            try {
                n = (int)this.locator_.getLength();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object = this.savedObject_;
        if (this.savedObject_ instanceof String) {
            this.value_ = (String)object;
        } else if (object instanceof Reader) {
            if (n >= 0) {
                try {
                    int n2 = n < 1000000 ? n : 1000000;
                    Reader reader = (Reader)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cArray = new char[n2];
                    int n3 = 0;
                    int n4 = reader.read(cArray, 0, n2);
                    while (n4 > -1 && n3 < n) {
                        stringBuffer.append(cArray, 0, n4);
                        int n5 = n - (n3 += n4);
                        if (n5 < n2) {
                            n2 = n5;
                        }
                        n4 = reader.read(cArray, 0, n2);
                    }
                    this.value_ = stringBuffer.toString();
                    if (this.value_.length() < n) {
                        JDError.throwSQLException((Object)this, "07006");
                    }
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
            } else if (n == -2) {
                try {
                    int n6 = 1000000;
                    Reader reader = (Reader)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cArray = new char[n6];
                    int n7 = 0;
                    int n8 = reader.read(cArray, 0, n6);
                    while (n8 > -1) {
                        stringBuffer.append(cArray, 0, n8);
                        n7 += n8;
                        n8 = reader.read(cArray, 0, n6);
                    }
                    this.value_ = stringBuffer.toString();
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        } else if (object instanceof Clob) {
            Clob clob = (Clob)object;
            this.value_ = clob.getSubString(1L, (int)clob.length());
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
        int n9 = this.value_.length();
        if (n9 > this.maxLength_) {
            this.value_ = this.value_.substring(0, this.maxLength_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void writeToServer() throws SQLException {
        block51: {
            try {
                var1_1 = this.savedObject_;
                if (var1_1 instanceof String) {
                    var2_2 = (String)var1_1;
                    var3_6 = this.settings_.getBidiStringType();
                    if (var3_6 == -1) {
                        var3_6 = this.converter_.bidiStringType_;
                    }
                    var4_14 = new BidiConversionProperties(var3_6);
                    var4_14.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                    var4_14.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                    var5_21 = this.converter_.stringToByteArray(var2_2, var4_14);
                    this.locator_.writeData(0L, var5_21, true);
                    break block51;
                }
                if (var1_1 instanceof Reader) {
                    var2_3 = this.scale_;
                    if (var2_3 == 0) {
                        this.locator_.writeData(0L, new byte[0], 0, 0, true);
                        break block51;
                    }
                    if (var2_3 > 0) {
                        try {
                            var3_7 = var2_3 < 1000000 ? var2_3 : 1000000;
                            var4_15 = this.settings_.getBidiStringType();
                            if (var4_15 == -1) {
                                var4_15 = this.converter_.bidiStringType_;
                            }
                            var5_22 = new BidiConversionProperties(var4_15);
                            var5_22.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                            var5_22.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                            var6_27 = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), var5_22, var3_7);
                            try {
                                var7_34 = new byte[var3_7];
                                var8_38 = 0;
                                var9_41 = var6_27.read(var7_34, 0, var3_7);
                                while (var9_41 > -1 && var8_38 < var2_3) {
                                    this.locator_.writeData(var8_38, var7_34, 0, var9_41, true);
                                    var10_43 = var2_3 - (var8_38 += var9_41);
                                    if (var10_43 < var3_7) {
                                        var3_7 = var10_43;
                                        if (var6_27.available() == 0 && var3_7 != 0) {
                                            var6_27 = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), var5_22, var3_7);
                                        }
                                    }
                                    var9_41 = var6_27.read(var7_34, 0, var3_7);
                                }
                                if (var8_38 < var2_3) {
                                    JDError.throwSQLException((Object)this, "07006");
                                }
                                var12_44 = null;
                            }
                            catch (Throwable var11_48) {
                                var12_45 = null;
                                try {
                                    var6_27.close();
                                }
                                catch (Exception var13_47) {
                                    JDTrace.logException(this, "writeToServer stream.close()", var13_47);
                                }
                                throw var11_48;
                            }
                            try {
                                var6_27.close();
                            }
                            catch (Exception var13_46) {
                                JDTrace.logException(this, "writeToServer stream.close()", var13_46);
                            }
                            break block51;
                        }
                        catch (IOException var3_8) {
                            JDError.throwSQLException((Object)this, "HY000", var3_8);
                        }
                        break block51;
                    }
                    if (var2_3 == -2) {
                        try {
                            var3_9 = 1000000;
                            var4_16 = this.settings_.getBidiStringType();
                            if (var4_16 == -1) {
                                var4_16 = this.converter_.bidiStringType_;
                            }
                            var5_23 = new BidiConversionProperties(var4_16);
                            var5_23.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                            var5_23.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                            var6_28 = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), var5_23, var3_9);
                            try {
                                var7_35 = new byte[var3_9];
                                var8_39 = 0;
                                var9_42 = var6_28.read(var7_35, 0, var3_9);
                                while (var9_42 > -1) {
                                    this.locator_.writeData(var8_39, var7_35, 0, var9_42, true);
                                    var8_39 += var9_42;
                                    var9_42 = var6_28.read(var7_35, 0, var3_9);
                                }
                                var15_49 = null;
                            }
                            catch (Throwable var14_53) {
                                var15_50 = null;
                                try {
                                    var6_28.close();
                                }
                                catch (Exception var16_52) {
                                    JDTrace.logException(this, "writeToServer stream2.close()", var16_52);
                                }
                                throw var14_53;
                            }
                            try {
                                var6_28.close();
                            }
                            catch (Exception var16_51) {
                                JDTrace.logException(this, "writeToServer stream2.close()", var16_51);
                            }
                            break block51;
                        }
                        catch (IOException var3_10) {
                            JDError.throwSQLException((Object)this, "HY000", var3_10);
                        }
                        break block51;
                    }
                    JDError.throwSQLException((Object)this, "07006");
                    break block51;
                }
                if (var1_1 instanceof InputStream) {
                    var2_4 = this.scale_;
                    if (var2_4 == 0) {
                        this.locator_.writeData(0L, new byte[0], 0, 0, true);
                        break block51;
                    }
                    if (var2_4 > 0) {
                        var3_11 = (InputStream)this.savedObject_;
                        var4_17 = var2_4 < 1000000 ? var2_4 : 1000000;
                        var5_24 = new byte[var4_17];
                        try {
                            var6_29 = 0;
                            var7_36 = var3_11.read(var5_24, 0, var4_17);
                            while (var7_36 > -1 && var6_29 < var2_4) {
                                this.locator_.writeData(var6_29, var5_24, 0, var7_36, true);
                                var8_40 = var2_4 - (var6_29 += var7_36);
                                if (var8_40 < var4_17) {
                                    var4_17 = var8_40;
                                }
                                var7_36 = var3_11.read(var5_24, 0, var4_17);
                            }
                            if (var6_29 < var2_4) {
                                JDError.throwSQLException((Object)this, "07006");
                            }
                            break block51;
                        }
                        catch (IOException var6_30) {
                            JDError.throwSQLException((Object)this, "HY000", var6_30);
                        }
                        break block51;
                    }
                    if (var2_4 == -2) {
                        var3_12 = (InputStream)this.savedObject_;
                        var4_18 = 1000000;
                        var5_25 = new byte[var4_18];
                        try {
                            var6_31 = 0;
                            var7_37 = var3_12.read(var5_25, 0, var4_18);
                            while (var7_37 > -1) {
                                this.locator_.writeData(var6_31, var5_25, 0, var7_37, true);
                                var6_31 += var7_37;
                                var7_37 = var3_12.read(var5_25, 0, var4_18);
                            }
                            break block51;
                        }
                        catch (IOException var6_32) {
                            JDError.throwSQLException((Object)this, "HY000", var6_32);
                            break block51;
                        }
                    }
                    JDError.throwSQLException((Object)this, "07006");
                    break block51;
                }
                if (var1_1 instanceof Clob) {
                    var2_5 = false;
                    if (var1_1 instanceof AS400JDBCClobLocator) {
                        var3_13 = (AS400JDBCClobLocator)var1_1;
                        var4_19 = var3_13;
                        synchronized (var4_19) {
                            block52: {
                                if (var3_13.savedObject_ == null) break block52;
                                this.savedObject_ = var3_13.savedObject_;
                                this.scale_ = var3_13.savedScale_;
                                var3_13.savedObject_ = null;
                                this.writeToServer();
                                return;
                            }
                            ** try [egrp 11[TRYBLOCK] [11 : 988->994)] { 
                            {
                            }
                        }
                    }
lbl177:
                    // 3 sources

                    if (!var2_5) {
                        var3_13 = (Clob)var1_1;
                        var4_20 = (int)var3_13.length();
                        var5_26 = var3_13.getSubString(1L, var4_20);
                        var6_33 = this.converter_.stringToByteArray(var5_26);
                        this.locator_.writeData(0L, var6_33, 0, var6_33.length, true);
                        var2_5 = true;
                    } else {
                        JDError.throwSQLException((Object)this, "07006");
                    }
                    break block51;
                }
                JDError.throwSQLException((Object)this, "07006");
            }
            finally {
                this.savedObject_ = null;
            }
        }
        this.scale_ = (int)this.locator_.getLength();
    }

    public int getSQLType() {
        return 34;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH");
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCNClobLocator";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "NCLOB";
    }

    public int getMaximumPrecision() {
        return 0x7FFFFFFE;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 964;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 2005;
    }

    public String getTypeName() {
        return "CLOB";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.maxLength_;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.value_));
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 819);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new HexReaderInputStream(new StringReader(this.value_));
            }
            return new HexReaderInputStream(new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            byte[] byArray = BinaryConverter.stringToBytes(this.getString());
            return new AS400JDBCBlob(byArray, byArray.length);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.getString());
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new StringReader(this.value_);
            }
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCClob(this.value_, this.maxLength_);
        }
        return new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String string = this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), dBLobData.getLength());
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return string;
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ReaderInputStream((Reader)new StringReader(this.value_), 13488);
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 13488);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException("HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new StringReader(this.value_);
        }
        try {
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String string = this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), dBLobData.getLength());
        return string;
    }

    public Array getArray() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void updateSettings(SQLConversionSettings sQLConversionSettings) {
        this.settings_ = sQLConversionSettings;
    }
}

