/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RCCallProgramFailureReplyDataStream;
import com.ibm.as400.access.RCCallProgramReplyDataStream;
import com.ibm.as400.access.RCCallProgramRequestDataStream;
import com.ibm.as400.access.RCExchangeAttributesReplyDataStream;
import com.ibm.as400.access.RCExchangeAttributesRequestDataStream;
import com.ibm.as400.access.RCRunCommandReplyDataStream;
import com.ibm.as400.access.RCRunCommandRequestDataStream;
import com.ibm.as400.access.RemoteCommandImpl;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.StringTokenizer;

class RemoteCommandImplRemote
implements RemoteCommandImpl {
    private static final String CLASSNAME = "com.ibm.as400.access.RemoteCommandImplRemote";
    AS400ImplRemote system_;
    ConverterImplRemote converter_;
    ConverterImplRemote unicodeConverter_;
    boolean ccsidIsUserOveride_ = false;
    private AS400Server server_;
    AS400Message[] messageList_ = new AS400Message[0];
    int serverDataStreamLevel_ = 0;
    protected Boolean priorCallWasOnThread_ = null;

    RemoteCommandImplRemote() {
    }

    public boolean isNative() {
        return false;
    }

    public void setSystem(AS400Impl aS400Impl) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting up remote command implementation object.");
        }
        this.system_ = (AS400ImplRemote)aS400Impl;
        int n = this.system_.getUserOverrideCcsid();
        if (n != 0) {
            if (n == 65535) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Disregarding specified user override CCSID: 65535");
                }
            } else {
                this.converter_ = ConverterImplRemote.getConverter(n, this.system_);
                this.ccsidIsUserOveride_ = true;
            }
        }
    }

    public String getJobInfo(Boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job information from implementation object.");
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[6];
        byte[] byArray = new byte[46];
        programParameterArray[0] = new ProgramParameter(byArray.length);
        byte[] byArray2 = BinaryConverter.intToByteArray(byArray.length);
        programParameterArray[1] = new ProgramParameter(byArray2);
        byte[] byArray3 = new byte[]{-39, -29, -27, -61, -16, -15, -16, -16};
        programParameterArray[2] = new ProgramParameter(byArray3);
        byte[] byArray4 = BinaryConverter.intToByteArray(1);
        programParameterArray[3] = new ProgramParameter(byArray4);
        byte[] byArray5 = BinaryConverter.intToByteArray(1009);
        programParameterArray[4] = new ProgramParameter(byArray5);
        programParameterArray[5] = new ProgramParameter(new byte[8]);
        try {
            boolean bl2 = RemoteCommandImpl.ON_THREAD.equals(bl) ? this.runProgramOnThread("QSYS", "QWCRTVCA", programParameterArray, 0, false) : this.runProgramOffThread("QSYS", "QWCRTVCA", programParameterArray, 0);
            if (!bl2) {
                Trace.log(2, "Unable to retrieve job information.");
                throw new AS400Exception(this.messageList_);
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            Trace.log(2, "Unexpected ObjectDoesNotExistException:", (Throwable)objectDoesNotExistException);
            throw new InternalErrorException(10);
        }
        byArray = programParameterArray[0].getOutputData();
        if (Trace.traceOn_) {
            Trace.log(1, "Job information retrieved:", byArray);
        }
        return this.converter_.byteArrayToString(byArray, 20, 26);
    }

    public AS400Message[] getMessageList() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message list from implementation object.");
        }
        return this.messageList_;
    }

    public int getThreadsafeIndicator(String string) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        int n;
        String string2;
        String string3;
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving command Threadsafe indicator.");
        }
        this.openOnThread();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string4 = stringTokenizer.nextToken().toUpperCase();
        int n2 = string4.indexOf(47);
        if (n2 == -1) {
            string3 = "*LIBL";
            string2 = string4;
        } else {
            string3 = string4.substring(0, n2);
            string2 = string4.substring(n2 + 1);
        }
        byte[] byArray = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        this.converter_.stringToByteArray(string2, byArray);
        this.converter_.stringToByteArray(string3, byArray, 10);
        int n3 = AS400.nativeVRM.vrm_ >= 393472 || AS400.nativeVRM.vrm_ >= 328704 && !this.system_.isMissingPTF() ? 6 : 5;
        ProgramParameter[] programParameterArray = new ProgramParameter[n3];
        programParameterArray[0] = new ProgramParameter(350);
        programParameterArray[1] = new ProgramParameter(new byte[]{0, 0, 1, 94});
        programParameterArray[2] = new ProgramParameter(new byte[]{-61, -44, -60, -55, -16, -15, -16, -16});
        programParameterArray[3] = new ProgramParameter(byArray);
        programParameterArray[4] = new ProgramParameter(new byte[8]);
        if (n3 > 5) {
            programParameterArray[5] = new ProgramParameter(new byte[]{-15});
        }
        try {
            boolean bl = this.runProgramOnThread("QSYS", "QCDRCMDI", programParameterArray, 0, true);
            if (!bl) {
                ProgramParameter[] programParameterArray2;
                if (n3 > 5 && AS400.nativeVRM.vrm_ < 393472 && AS400.nativeVRM.vrm_ >= 328704 && this.messageList_[this.messageList_.length - 1].getID().equals("MCH0802")) {
                    if (Trace.traceOn_) {
                        Trace.log(4, "PTF SI29629 is not installed: (MCH0802) " + this.messageList_[this.messageList_.length - 1].getText());
                    }
                    this.system_.setMissingPTF();
                    programParameterArray2 = new ProgramParameter[5];
                    System.arraycopy(programParameterArray, 0, programParameterArray2, 0, 5);
                    bl = this.runProgramOnThread("QSYS", "QCDRCMDI", programParameterArray2, 0, true);
                }
                if (!bl) {
                    Trace.log(2, "Unable to retrieve command information.");
                    programParameterArray2 = this.messageList_[this.messageList_.length - 1].getID();
                    byte[] byArray2 = this.messageList_[this.messageList_.length - 1].getSubstitutionData();
                    if (programParameterArray2.equals("CPF9801") && string2.equals(this.converter_.byteArrayToString(byArray2, 0, 10).trim()) && string3.equals(this.converter_.byteArrayToString(byArray2, 10, 10).trim()) && "CMD".equals(this.converter_.byteArrayToString(byArray2, 20, 7).trim())) {
                        Trace.log(4, "Command not found.");
                        return 0;
                    }
                    if (programParameterArray2.equals("CPF9810") && string3.equals(this.converter_.byteArrayToString(byArray2).trim())) {
                        Trace.log(4, "Command library not found.");
                        return 0;
                    }
                    throw new AS400Exception(this.messageList_);
                }
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            Trace.log(2, "Unexpected ObjectDoesNotExistException:", (Throwable)objectDoesNotExistException);
            throw new InternalErrorException(10);
        }
        byte[] byArray3 = programParameterArray[0].getOutputData();
        if (Trace.traceOn_) {
            Trace.log(1, "Command information retrieved:", byArray3);
            Trace.log(1, "Multithreaded job action: " + (byArray3[334] & 0xF));
        }
        int n4 = byArray3[333] & 0xF;
        switch (n4) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                n = 0;
                if (!Trace.traceOn_) break;
                Trace.log(4, "Unrecognized threadsafe indicator value reported by QCDRCMDI:", n4);
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Threadsafe indicator:", n);
        }
        return n;
    }

    protected void open(Boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        this.openOffThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openOffThread() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Remote implementation object open.");
        }
        AS400Server aS400Server = this.server_ = this.system_.getConnection(2, false);
        synchronized (aS400Server) {
            DataStream dataStream = this.server_.getExchangeAttrReply();
            if (dataStream == null) {
                try {
                    dataStream = this.server_.sendExchangeAttrRequest(new RCExchangeAttributesRequestDataStream(this.system_.getNLV()));
                }
                catch (IOException iOException) {
                    Trace.log(2, "IOException during exchange attributes:", (Throwable)iOException);
                    this.disconnectServer();
                    throw iOException;
                }
                if (!(dataStream instanceof RCExchangeAttributesReplyDataStream)) {
                    Trace.log(2, "Unknown exchange attributes reply datastream:", dataStream.data_);
                    this.disconnectServer();
                    throw new InternalErrorException(2);
                }
                this.processReturnCode(((RCExchangeAttributesReplyDataStream)dataStream).getRC());
            }
            RCExchangeAttributesReplyDataStream rCExchangeAttributesReplyDataStream = (RCExchangeAttributesReplyDataStream)dataStream;
            if (!this.ccsidIsUserOveride_) {
                this.converter_ = ConverterImplRemote.getConverter(rCExchangeAttributesReplyDataStream.getCCSID(), this.system_);
            }
            this.serverDataStreamLevel_ = rCExchangeAttributesReplyDataStream.getDSLevel();
            if (this.serverDataStreamLevel_ >= 10) {
                this.unicodeConverter_ = ConverterImplRemote.getConverter(1200, this.system_);
            }
        }
    }

    protected void openOnThread() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        this.openOffThread();
    }

    public boolean runCommand(String string) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        return this.runCommandOffThread(string, 0);
    }

    public boolean runCommand(String string, Boolean bl, int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        return this.runCommandOffThread(string, n);
    }

    protected boolean runCommandOffThread(String string, int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(3, "Remote implementation running command: " + string);
            Trace.log(1, "Running command OFF-THREAD: " + string);
        }
        this.openOffThread();
        if (this.serverDataStreamLevel_ >= 10) {
            return this.runCommandOffThread(this.unicodeConverter_.stringToByteArray(string), n, 1200);
        }
        string = AS400BidiTransform.SQL_statement_reordering(string, this.system_.getBidiStringType(), this.converter_.table_.bidiStringType_);
        return this.runCommandOffThread(this.converter_.stringToByteArray(string, new BidiConversionProperties(this.converter_.table_.bidiStringType_)), n, 0);
    }

    public boolean runCommand(byte[] byArray, String string) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(3, "Remote implementation running command: " + string);
        }
        return this.runCommandOffThread(byArray, 0, 0);
    }

    public boolean runCommand(byte[] byArray, Boolean bl, int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        return this.runCommandOffThread(byArray, n, 0);
    }

    protected boolean runCommandOffThread(byte[] byArray, int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (RemoteCommandImpl.ON_THREAD.equals(this.priorCallWasOnThread_) && Trace.traceOn_) {
            Trace.log(1, "Prior call was on-thread, but this call is off-thread, so different job.");
        }
        this.priorCallWasOnThread_ = RemoteCommandImpl.OFF_THREAD;
        this.openOffThread();
        try {
            DataStream dataStream = this.server_.sendAndReceive(new RCRunCommandRequestDataStream(byArray, this.serverDataStreamLevel_, n, n2));
            if (!(dataStream instanceof RCRunCommandReplyDataStream)) {
                Trace.log(2, "Unknown run command reply datastream:", dataStream.data_);
                this.disconnectServer();
                throw new InternalErrorException(2);
            }
            RCRunCommandReplyDataStream rCRunCommandReplyDataStream = (RCRunCommandReplyDataStream)dataStream;
            this.messageList_ = rCRunCommandReplyDataStream.getMessageList(this.converter_);
            int n3 = rCRunCommandReplyDataStream.getRC();
            this.processReturnCode(n3);
            return n3 == 0;
        }
        catch (IOException iOException) {
            Trace.log(2, "Lost connection to remote command server:", (Throwable)iOException);
            this.disconnectServer();
            throw iOException;
        }
    }

    public boolean runProgram(String string, String string2, ProgramParameter[] programParameterArray) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        return this.runProgramOffThread(string, string2, programParameterArray, 0);
    }

    public boolean runProgram(String string, String string2, ProgramParameter[] programParameterArray, Boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        return this.runProgramOffThread(string, string2, programParameterArray, 0);
    }

    public boolean runProgram(String string, String string2, ProgramParameter[] programParameterArray, Boolean bl, int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        return this.runProgramOffThread(string, string2, programParameterArray, n);
    }

    protected boolean runProgramOnThread(String string, String string2, ProgramParameter[] programParameterArray, int n, boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        return this.runProgramOffThread(string, string2, programParameterArray, n);
    }

    protected boolean runProgramOffThread(String string, String string2, ProgramParameter[] programParameterArray, int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(3, "Remote implementation running program: " + string + "/" + string2);
            Trace.log(1, "Running program OFF-THREAD: " + string + "/" + string2);
        }
        if (RemoteCommandImpl.ON_THREAD.equals(this.priorCallWasOnThread_) && Trace.traceOn_) {
            Trace.log(1, "Prior call was on-thread, but this call is off-thread, so different job.");
        }
        this.priorCallWasOnThread_ = RemoteCommandImpl.OFF_THREAD;
        this.openOffThread();
        try {
            String string3;
            DataStream dataStream = this.server_.sendAndReceive(new RCCallProgramRequestDataStream(string, string2, programParameterArray, this.converter_, this.serverDataStreamLevel_, n));
            if (!(dataStream instanceof RCCallProgramReplyDataStream)) {
                Trace.log(2, "Unknown run program reply datastream ", dataStream.data_);
                this.disconnectServer();
                throw new InternalErrorException(2);
            }
            RCCallProgramReplyDataStream rCCallProgramReplyDataStream = (RCCallProgramReplyDataStream)dataStream;
            int n2 = rCCallProgramReplyDataStream.getRC();
            this.processReturnCode(n2);
            if (n2 == 0) {
                rCCallProgramReplyDataStream.getParameterList(programParameterArray);
                this.messageList_ = new AS400Message[0];
                return true;
            }
            this.messageList_ = rCCallProgramReplyDataStream.getMessageList(this.converter_);
            if (n2 == 1280 && this.messageList_.length != 0 && (string3 = this.messageList_[this.messageList_.length - 1].getID()).equals("MCH3401")) {
                byte[] byArray = this.messageList_[this.messageList_.length - 1].getSubstitutionData();
                if (byArray[0] == 2 && byArray[1] == 1 && string2.equals(this.converter_.byteArrayToString(byArray, 2, 30).trim())) {
                    throw new ObjectDoesNotExistException(QSYSObjectPathName.toPath(string, string2, "PGM"), 2);
                }
                if (byArray[0] == 4 && byArray[1] == 1 && string.equals(this.converter_.byteArrayToString(byArray, 2, 30).trim())) {
                    throw new ObjectDoesNotExistException(QSYSObjectPathName.toPath(string, string2, "PGM"), 1);
                }
            }
            return false;
        }
        catch (IOException iOException) {
            Trace.log(2, "Lost connection to remote command server:", (Throwable)iOException);
            this.disconnectServer();
            throw iOException;
        }
    }

    public byte[] runServiceProgram(String string, String string2, String string3, ProgramParameter[] programParameterArray) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        return this.runServiceProgram(string, string2, string3, 3, programParameterArray, ProgramCall.getDefaultThreadSafety(), 37, 0, false);
    }

    public byte[] runServiceProgram(String string, String string2, String string3, int n, ProgramParameter[] programParameterArray, Boolean bl, int n2, int n3, boolean bl2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        int n4;
        int n5;
        int n6;
        if (Trace.traceOn_) {
            Trace.log(3, "Remote implementation running service program: " + string + "/" + string2 + " procedure name: " + string3);
        }
        this.open(bl);
        ProgramParameter[] programParameterArray2 = new ProgramParameter[7 + programParameterArray.length];
        byte[] byArray = new byte[20];
        for (int i = 0; i < 20; ++i) {
            byArray[i] = 64;
        }
        this.converter_.stringToByteArray(string2, byArray, 0);
        this.converter_.stringToByteArray(string, byArray, 10);
        programParameterArray2[0] = new ProgramParameter(byArray);
        ConverterImplRemote converterImplRemote = ConverterImplRemote.getConverter(n2, this.system_);
        byte[] byArray2 = converterImplRemote.stringToByteArray(string3);
        byte[] byArray3 = new byte[byArray2.length + 1];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        programParameterArray2[1] = new ProgramParameter(byArray3);
        byte[] byArray4 = new byte[4];
        BinaryConverter.intToByteArray(n, byArray4, 0);
        programParameterArray2[2] = new ProgramParameter(byArray4);
        byte[] byArray5 = new byte[programParameterArray.length * 4];
        for (int i = 0; i < programParameterArray.length; ++i) {
            n6 = programParameterArray[i].getParameterType();
            if (this.serverDataStreamLevel_ < 6 && programParameterArray[i].getUsage() == 255) {
                n6 = 1;
            }
            BinaryConverter.intToByteArray(n6, byArray5, i * 4);
        }
        programParameterArray2[3] = new ProgramParameter(byArray5);
        byte[] byArray6 = new byte[4];
        BinaryConverter.intToByteArray(programParameterArray.length, byArray6, 0);
        programParameterArray2[4] = new ProgramParameter(byArray6);
        n6 = 8;
        int n7 = n5 = n == 0 ? 4 : 8;
        if (bl2 && programParameterArray.length != 0) {
            n4 = 0;
            n4 += byArray.length;
            n4 += byArray3.length;
            n4 += byArray4.length;
            n4 += byArray5.length;
            n4 += byArray6.length;
            n4 += n6;
            int n8 = (n4 += n5) % 16;
            if (n8 != 0) {
                n6 += 16 - n8;
                if (Trace.traceOn_) {
                    Trace.log(1, "To achieve 16-byte alignment, padding 'error code' parameter to length " + n6);
                }
            }
        }
        programParameterArray2[5] = new ProgramParameter(n6);
        programParameterArray2[6] = new ProgramParameter(n5);
        System.arraycopy(programParameterArray, 0, programParameterArray2, 7, programParameterArray.length);
        n4 = this.runProgram("QSYS", "QZRUCLSP", programParameterArray2, bl, n3) ? 1 : 0;
        if (n4 == 0) {
            return null;
        }
        return programParameterArray2[6].getOutputData();
    }

    private void processReturnCode(int n) throws ErrorCompletingRequestException {
        if (Trace.traceOn_) {
            byte[] byArray = new byte[2];
            BinaryConverter.unsignedShortToByteArray(n, byArray, 0);
            Trace.log(1, "Remote command server return code:", byArray);
        }
        switch (n) {
            case 0: {
                if (Trace.traceOn_) {
                    Trace.log(3, "Request processed successfully.");
                }
                return;
            }
            case 256: {
                if (Trace.traceOn_) {
                    Trace.log(4, "Limited user.");
                }
                return;
            }
            case 257: {
                Trace.log(2, "Exchange attributes request not valid.");
                this.disconnectServer();
                throw new InternalErrorException(5);
            }
            case 258: {
                Trace.log(2, "Datastream level not valid.");
                this.disconnectServer();
                throw new InternalErrorException(1);
            }
            case 259: {
                Trace.log(2, "Version not valid.");
                this.disconnectServer();
                throw new InternalErrorException(7);
            }
            case 260: {
                if (Trace.traceOn_) {
                    Trace.log(4, "CCSID not valid.");
                }
                return;
            }
            case 261: {
                if (Trace.traceOn_) {
                    Trace.log(4, "NLV not valid");
                }
                return;
            }
            case 262: {
                if (Trace.traceOn_) {
                    Trace.log(4, "NLV not installed.");
                }
                return;
            }
            case 263: {
                if (Trace.traceOn_) {
                    Trace.log(4, "Error retrieving product information, cannot validate NLV.");
                }
                return;
            }
            case 264: {
                if (Trace.traceOn_) {
                    Trace.log(4, "Error adding NLV library to system library list.");
                }
                return;
            }
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 517: {
                Trace.log(2, "Datastream not valid.");
                this.disconnectServer();
                throw new InternalErrorException(5);
            }
            case 516: {
                Trace.log(2, "Host Resource error.");
                this.disconnectServer();
                throw new ErrorCompletingRequestException(1);
            }
            case 768: {
                Trace.log(2, "Process exit point error.");
                this.disconnectServer();
                throw new ErrorCompletingRequestException(2);
            }
            case 769: 
            case 770: {
                Trace.log(2, "Request not valid.");
                this.disconnectServer();
                throw new InternalErrorException(5);
            }
            case 771: {
                Trace.log(2, "Maximum exceeded.");
                throw new ErrorCompletingRequestException(9);
            }
            case 772: {
                Trace.log(2, "Error calling exit program.");
                this.disconnectServer();
                throw new ErrorCompletingRequestException(3);
            }
            case 773: {
                Trace.log(2, "Exit program denied request.");
                this.disconnectServer();
                throw new ErrorCompletingRequestException(4);
            }
            case 1024: {
                if (Trace.traceOn_) {
                    Trace.log(3, "Error calling the command.");
                }
                return;
            }
            case 1025: {
                Trace.log(2, "CCSID not valid.");
                throw new InternalErrorException(5);
            }
            case 1280: {
                if (Trace.traceOn_) {
                    Trace.log(2, "Could not resolve program.");
                }
                return;
            }
            case 1281: {
                if (Trace.traceOn_) {
                    Trace.log(1, "Error calling the program.");
                }
                return;
            }
        }
        Trace.log(2, "Return code unknown.");
        this.disconnectServer();
        throw new InternalErrorException(9);
    }

    private void disconnectServer() {
        block2: {
            try {
                this.system_.disconnectServer(this.server_);
            }
            catch (Throwable throwable) {
                if (!Trace.traceOn_) break block2;
                Trace.log(1, "Exception while attempting to disconnect the server:", throwable);
            }
        }
    }

    static AS400Message[] parseMessages(byte[] byArray, ConverterImplRemote converterImplRemote) throws IOException {
        int n = BinaryConverter.byteArrayToUnsignedShort(byArray, 22);
        AS400Message[] aS400MessageArray = new AS400Message[n];
        int n2 = 24;
        for (int i = 0; i < n; ++i) {
            int n3;
            if (byArray[n2 + 5] == 6) {
                aS400MessageArray[i] = AS400ImplRemote.parseMessage(byArray, n2 + 6, converterImplRemote);
            } else if (byArray[n2 + 5] == 7) {
                n3 = n2;
                AS400Message aS400Message = new AS400Message();
                int n4 = BinaryConverter.byteArrayToInt(byArray, n2 += 6);
                aS400Message.setSeverity(BinaryConverter.byteArrayToInt(byArray, n2 += 4));
                int n5 = BinaryConverter.byteArrayToInt(byArray, n2 += n4);
                aS400Message.setID(converterImplRemote.byteArrayToString(byArray, n2 += 4, n5));
                int n6 = BinaryConverter.byteArrayToInt(byArray, n2 += n5);
                aS400Message.setType((byArray[n2 += 4] & 0xF) * 10 + (byArray[n2 + 1] & 0xF));
                int n7 = BinaryConverter.byteArrayToInt(byArray, n2 += n6);
                byte[] byArray2 = new byte[n7];
                System.arraycopy(byArray, n2 += 4, byArray2, 0, n7);
                aS400Message.setKey(byArray2);
                int n8 = BinaryConverter.byteArrayToInt(byArray, n2 += n7);
                aS400Message.setFileName(converterImplRemote.byteArrayToString(byArray, n2 += 4, n8).trim());
                int n9 = BinaryConverter.byteArrayToInt(byArray, n2 += n8);
                aS400Message.setMessageFileLibrarySpecified(converterImplRemote.byteArrayToString(byArray, n2 += 4, n9).trim());
                int n10 = BinaryConverter.byteArrayToInt(byArray, n2 += n9);
                aS400Message.setLibraryName(converterImplRemote.byteArrayToString(byArray, n2 += 4, n10).trim());
                int n11 = BinaryConverter.byteArrayToInt(byArray, n2 += n10);
                n2 += 4;
                int n12 = BinaryConverter.byteArrayToInt(byArray, n2 += n11);
                n2 += 4;
                int n13 = BinaryConverter.byteArrayToInt(byArray, n2 += n12);
                n2 += 4;
                int n14 = BinaryConverter.byteArrayToInt(byArray, n2 += n13);
                aS400Message.setSendingProgramName(converterImplRemote.byteArrayToString(byArray, n2 += 4, n14).trim());
                int n15 = BinaryConverter.byteArrayToInt(byArray, n2 += n14);
                aS400Message.setSendingProgramInstructionNumber(converterImplRemote.byteArrayToString(byArray, n2 += 4, n15).trim());
                int n16 = BinaryConverter.byteArrayToInt(byArray, n2 += n15);
                String string = converterImplRemote.byteArrayToString(byArray, n2 += 4, n16).trim();
                int n17 = BinaryConverter.byteArrayToInt(byArray, n2 += n16);
                String string2 = converterImplRemote.byteArrayToString(byArray, n2 += 4, n17).trim();
                aS400Message.setDate(string, string2);
                int n18 = BinaryConverter.byteArrayToInt(byArray, n2 += n17);
                aS400Message.setReceivingProgramName(converterImplRemote.byteArrayToString(byArray, n2 += 4, n18).trim());
                int n19 = BinaryConverter.byteArrayToInt(byArray, n2 += n18);
                aS400Message.setReceivingProgramInstructionNumber(converterImplRemote.byteArrayToString(byArray, n2 += 4, n19).trim());
                int n20 = BinaryConverter.byteArrayToInt(byArray, n2 += n19);
                aS400Message.setSendingType(converterImplRemote.byteArrayToString(byArray, n2 += 4, n20).trim());
                int n21 = BinaryConverter.byteArrayToInt(byArray, n2 += n20);
                aS400Message.setReceivingType(converterImplRemote.byteArrayToString(byArray, n2 += 4, n21).trim());
                int n22 = BinaryConverter.byteArrayToInt(byArray, n2 += n21);
                aS400Message.setTextCcsidConversionStatusIndicator(BinaryConverter.byteArrayToInt(byArray, n2 += 4));
                int n23 = BinaryConverter.byteArrayToInt(byArray, n2 += 4);
                aS400Message.setDataCcsidConversionStatusIndicator(BinaryConverter.byteArrayToInt(byArray, n2 += 4));
                int n24 = BinaryConverter.byteArrayToInt(byArray, n2 += 4);
                aS400Message.setAlertOption(converterImplRemote.byteArrayToString(byArray, n2 += 4, n24).trim());
                int n25 = BinaryConverter.byteArrayToInt(byArray, n2 += n24);
                aS400Message.setTextCcsid(BinaryConverter.byteArrayToInt(byArray, n2 += 4));
                int n26 = BinaryConverter.byteArrayToInt(byArray, n2 += 4);
                int n27 = BinaryConverter.byteArrayToInt(byArray, n2 += 4);
                aS400Message.setSubstitutionDataCcsid(n27);
                int n28 = BinaryConverter.byteArrayToInt(byArray, n2 += 4);
                byte[] byArray3 = new byte[n28];
                System.arraycopy(byArray, n2 += 4, byArray3, 0, n28);
                aS400Message.setSubstitutionData(byArray3);
                int n29 = BinaryConverter.byteArrayToInt(byArray, n2 += n28);
                aS400Message.setText(converterImplRemote.byteArrayToString(byArray, n2 += 4, n29).trim());
                int n30 = BinaryConverter.byteArrayToInt(byArray, n2 += n29);
                aS400Message.setHelp(converterImplRemote.byteArrayToString(byArray, n2 += 4, n30).trim());
                n2 += n30;
                aS400MessageArray[i] = aS400Message;
                n2 = n3;
            } else {
                aS400MessageArray[i] = new AS400Message();
                aS400MessageArray[i].setID(converterImplRemote.byteArrayToString(byArray, n2 + 6, 7));
                aS400MessageArray[i].setType((byArray[n2 + 13] & 0xF) * 10 + (byArray[n2 + 14] & 0xF));
                aS400MessageArray[i].setSeverity(BinaryConverter.byteArrayToUnsignedShort(byArray, n2 + 15));
                aS400MessageArray[i].setFileName(converterImplRemote.byteArrayToString(byArray, n2 + 17, 10).trim());
                aS400MessageArray[i].setLibraryName(converterImplRemote.byteArrayToString(byArray, n2 + 27, 10).trim());
                n3 = BinaryConverter.byteArrayToUnsignedShort(byArray, n2 + 37);
                int n31 = BinaryConverter.byteArrayToUnsignedShort(byArray, n2 + 39);
                byte[] byArray4 = new byte[n3];
                System.arraycopy(byArray, n2 + 41, byArray4, 0, n3);
                aS400MessageArray[i].setSubstitutionData(byArray4);
                aS400MessageArray[i].setSubstitutionDataCcsid(converterImplRemote.getCcsid());
                aS400MessageArray[i].setText(converterImplRemote.byteArrayToString(byArray, n2 + 41 + n3, n31));
                aS400MessageArray[i].setTextCcsid(converterImplRemote.getCcsid());
            }
            n2 += BinaryConverter.byteArrayToInt(byArray, n2);
        }
        return aS400MessageArray;
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        AS400Server.addReplyStream((DataStream)new RCExchangeAttributesReplyDataStream(), 2);
        AS400Server.addReplyStream((DataStream)new RCRunCommandReplyDataStream(), 2);
        AS400Server.addReplyStream((DataStream)new RCCallProgramReplyDataStream(), 2);
        AS400Server.addReplyStream((DataStream)new RCCallProgramFailureReplyDataStream(), 2);
    }
}

