/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PTFGroup;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyVetoException;
import java.io.IOException;

public class PTFGroupList {
    private AS400 system_;

    public PTFGroupList(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.setSystem(aS400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PTFGroup[] getPTFGroup() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        try {
            int n = this.system_.getCcsid();
            ConvTable convTable = ConvTable.getTable(n, null);
            ProgramParameter[] programParameterArray = new ProgramParameter[4];
            programParameterArray[0] = new ProgramParameter(convTable.stringToByteArray("JT4PTF    QTEMP     "));
            programParameterArray[0].setParameterType(2);
            programParameterArray[1] = new ProgramParameter(convTable.stringToByteArray("LSTG0100"));
            programParameterArray[1].setParameterType(2);
            programParameterArray[2] = new ProgramParameter(BinaryConverter.intToByteArray(n));
            programParameterArray[2].setParameterType(2);
            programParameterArray[3] = new ProgramParameter(new byte[4]);
            programParameterArray[3].setParameterType(2);
            ServiceProgramCall serviceProgramCall = new ServiceProgramCall(this.system_, "/QSYS.LIB/QPZGROUP.SRVPGM", "QpzListPtfGroups", 0, programParameterArray);
            boolean bl = serviceProgramCall.isStayOnThread();
            Object object = bl ? "JT4PTF    QTEMP     " : this.system_;
            byte[] byArray = null;
            Object object2 = object;
            synchronized (object2) {
                UserSpace userSpace = new UserSpace(this.system_, "/QSYS.LIB/QTEMP.LIB/JT4PTF.USRSPC");
                userSpace.setMustUseProgramCall(true);
                if (!bl) {
                    userSpace.setMustUseSockets(true);
                }
                try {
                    userSpace.create(262144, true, "", (byte)0, "User space for PTF Group list", "*EXCLUDE");
                    if (!serviceProgramCall.run()) {
                        throw new AS400Exception(serviceProgramCall.getMessageList());
                    }
                    int n2 = userSpace.getLength();
                    byArray = new byte[n2];
                    userSpace.read(byArray, 0);
                }
                finally {
                    try {
                        userSpace.delete();
                    }
                    catch (Exception exception) {
                        Trace.log(2, "Exception while deleting temporary user space", (Throwable)exception);
                    }
                }
            }
            int n3 = BinaryConverter.byteArrayToInt(byArray, 124);
            int n4 = BinaryConverter.byteArrayToInt(byArray, 132);
            int n5 = BinaryConverter.byteArrayToInt(byArray, 136);
            int n6 = BinaryConverter.byteArrayToInt(byArray, 140);
            convTable = ConvTable.getTable(n6, null);
            int n7 = 0;
            PTFGroup[] pTFGroupArray = new PTFGroup[n4];
            for (int i = 0; i < n4; ++i) {
                n7 = n3 + i * n5;
                String string = convTable.byteArrayToString(byArray, n7, 60);
                String string2 = convTable.byteArrayToString(byArray, n7 += 60, 100);
                int n8 = BinaryConverter.byteArrayToInt(byArray, n7 += 100);
                int n9 = BinaryConverter.byteArrayToInt(byArray, n7 += 4);
                n7 += 4;
                pTFGroupArray[i] = new PTFGroup(this.system_, string, string2, n8, n9);
            }
            return pTFGroupArray;
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, propertyVetoException);
            throw new InternalErrorException(10, (Throwable)propertyVetoException);
        }
    }

    public void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    public AS400 getSystem() {
        return this.system_;
    }
}

