/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SystemValue;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;

public class DateTimeConverter {
    private AS400 system_;
    private ProgramCall program_;
    private AS400Text text10_;
    private Calendar calendar_;
    private DateTime17Format format17_;
    private TimeZone systemTimeZone_;
    static String[][] iTimeZoneTojavaTimeZoneMapping = new String[][]{{"Q0000UTC", "UTC"}, {"Q0000GMT", "GMT"}, {"Q0000GMT2", "Europe/London"}, {"Q000GMT3", "Europe/London"}, {"QN0100UTCS", "GMT-1"}, {"QN0200UTCS", "GMT-2"}, {"QN0300UTCS", "GMT-3"}, {"QN0300UTC2", "America/Sao_Paulo"}, {"QN0330NST", "America/St_Johns"}, {"QN0330NST2", "America/St_Johns"}, {"QN0330NST3", "America/St_Johns"}, {"QN0330NST4", "America/St_Johns"}, {"QN0400UTCS", "GMT-4"}, {"QN0400AST", "Atlantic/Bermuda"}, {"QN0400AST2", "Atlantic/Bermuda"}, {"QN0400CLT", "America/Santiago"}, {"QN0400UTC2", "America/Caracas"}, {"QN0500UTCS", "GMT-5"}, {"QN0500EST", "America/New_York"}, {"QN0500EST2", "GMT-5"}, {"QN0500EST3", "America/New_York"}, {"QN0600UTCS", "GMT-6"}, {"QN0600CST", "America/Chicago"}, {"QN0600CST2", "America/Chicago"}, {"QN0600CST3", "America/Mexico_City"}, {"QN0600S", "America/Chicago"}, {"QN0700UTCS", "GMT-7"}, {"QN0700MST", "America/Denver"}, {"QN0700MST2", "America/Phoenix"}, {"QN0700MST3", "America/Denver"}, {"QN0700MST4", "America/Mazatlan"}, {"QN0700T", "America/Denver"}, {"QN0800UTCS", "GMT-8"}, {"QN0800PST", "America/Los_Angeles"}, {"QN0800PST2", "America/Los_Angeles"}, {"QN0800PST3", "America/Tijuana"}, {"QN0800U", "America/Los_Angeles"}, {"QN0900UTCS", "GMT-9"}, {"QN0900AST", "America/Anchorage"}, {"QN0900AST2", "America/Anchorage"}, {"QN1000UTCS", "GMT-10"}, {"QN1000HAST", "America/Adak"}, {"QN1000HAS2", "America/Adak"}, {"QN1000HST", "Pacific/Honolulu"}, {"QN1100UTCS", "GMT-11"}, {"QN1200UTCS", "GMT-12"}, {"QP1245UTCS", "Pacific/Chatham"}, {"QP1245UTC2", "Pacific/Chatham"}, {"QP1200UTCS", "GMT+12"}, {"QP1200NZST", "Pacific/Auckland"}, {"QP1200NZS2", "Pacific/Auckland"}, {"QP1200NZS3", "Pacific/Auckland"}, {"QP1100UTCS", "GMT+11"}, {"QP1000UTCS", "GMT+10"}, {"QP1000AEST", "Australia/Sydney"}, {"QP1000AES2", "Australia/Sydney"}, {"QP0930ACST", "Australia/Adelaide"}, {"QP0930ACS2", "Australia/Adelaide"}, {"QP0900UTCS", "GMT+9"}, {"QP0900JST", "Asia/Tokyo"}, {"QP0900KST", "Asia/Seoul"}, {"QP0900WIT", "Asia/Jayapura"}, {"QP0800UTCS", "GMT+8"}, {"QP0800AWST", "Australia/Perth"}, {"QP0800AWS2", "Australia/Perth"}, {"QP0800AWS3", "Australia/Perth"}, {"QP0800BST", "Asia/Shanghai"}, {"QP0800JIST", "Asia/Hong_Kong"}, {"QP0800WITA", "Asia/Ujung_Pandang"}, {"QP0700UTCS", "GMT+7"}, {"QP0700WIB", "Asia/Jakarta"}, {"QP0600UTCS", "GMT+6"}, {"QP0600UTC2", "Asia/Almaty"}, {"QP0600UTC3", "Asia/Almaty"}, {"QP0530IST", "Asia/Calcutta"}, {"QP0500UTCS", "GMT+5"}, {"QP0500UTC2", "Asia/Aqtobe"}, {"QP0500UTC3", "Asia/Aqtobe"}, {"QP0400UTCS", "GMT+4"}, {"QP0400UTC2", "Asia/Aqtau"}, {"QP0400UTC3", "Asia/Aqtau"}, {"QP0300MSK", "Europe/Moscow"}, {"QP0300UTCS", "GMT+3"}, {"QP0200UTCS", "GMT+2"}, {"QP0200EET", "Europe/Tallinn"}, {"QP0200EET2", "GMT+2"}, {"QP0200EET3", "Europe/Tallinn"}, {"QP0200SAST", "Africa/Johannesburg"}, {"QP0100UTCS", "GMT+1"}, {"QP0100CET", "Europe/Zurich"}, {"QP0100CET2", "Europe/Zurich"}, {"QP0100CET3", "Europe/Zurich"}, {"QP0100CET4", "Europe/Zurich"}};
    static Hashtable iTimeZoneToJavaTimeZoneHash = null;

    public DateTimeConverter(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
        this.program_ = new ProgramCall(this.system_);
        this.text10_ = new AS400Text(10, this.system_.getCcsid(), this.system_);
    }

    public byte[] convert(byte[] byArray, String string, String string2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.convert(byArray, string, string2, null);
    }

    private byte[] convert(byte[] byArray, String string, String string2, String string3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramParameter[] programParameterArray;
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        if (string == null) {
            throw new NullPointerException("inFormat");
        }
        if (string2 == null) {
            throw new NullPointerException("outFormat");
        }
        if (string3 == null) {
            programParameterArray = new ProgramParameter[5];
            this.setRequiredParameters(programParameterArray, byArray, string, string2);
        } else {
            programParameterArray = new ProgramParameter[10];
            this.setRequiredParameters(programParameterArray, byArray, string, string2);
            this.setOptionalParameters(programParameterArray, string3);
        }
        try {
            this.program_.setProgram("/QSYS.LIB/QWCCVTDT.PGM", programParameterArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.program_.suggestThreadsafe();
        if (!this.program_.run()) {
            Trace.log(2, "DateTimeConverter call to QWCCVTDT failed.");
            AS400Message[] aS400MessageArray = this.program_.getMessageList();
            for (int i = 0; i < aS400MessageArray.length; ++i) {
                Trace.log(2, aS400MessageArray[i].toString());
            }
            throw new AS400Exception(aS400MessageArray);
        }
        byte[] byArray2 = programParameterArray[3].getOutputData();
        return byArray2;
    }

    private void setRequiredParameters(ProgramParameter[] programParameterArray, byte[] byArray, String string, String string2) {
        programParameterArray[0] = new ProgramParameter(this.text10_.toBytes(string));
        programParameterArray[1] = new ProgramParameter(byArray);
        programParameterArray[2] = new ProgramParameter(this.text10_.toBytes(string2));
        programParameterArray[3] = new ProgramParameter(17);
        programParameterArray[4] = new ErrorCodeParameter();
    }

    private void setOptionalParameters(ProgramParameter[] programParameterArray, String string) {
        byte[] byArray = this.text10_.toBytes(string);
        programParameterArray[5] = new ProgramParameter(byArray);
        programParameterArray[6] = new ProgramParameter(byArray);
        programParameterArray[7] = new ProgramParameter(0);
        programParameterArray[8] = new ProgramParameter(BinaryConverter.intToByteArray(0));
        programParameterArray[9] = new ProgramParameter(new byte[]{-16});
    }

    public Date convert(byte[] byArray, String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        if (string == null) {
            throw new NullPointerException("inFormat");
        }
        byte[] byArray2 = this.convert(byArray, string, "*YYMD", null);
        Record record = this.getFormat17().getNewRecord(byArray2);
        if (Trace.traceOn_) {
            Trace.log(1, "DateTimeConverter record parsed from bytes: " + record.toString());
        }
        Calendar calendar = this.getCalendar();
        calendar.set(Integer.parseInt(((String)record.getField("year")).trim()), Integer.parseInt(((String)record.getField("month")).trim()) - 1, Integer.parseInt(((String)record.getField("day")).trim()), Integer.parseInt(((String)record.getField("hour")).trim()), Integer.parseInt(((String)record.getField("minute")).trim()), Integer.parseInt(((String)record.getField("second")).trim()));
        calendar.set(14, Integer.parseInt(((String)record.getField("millisecond")).trim()));
        return calendar.getTime();
    }

    public byte[] convert(Date date, String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (date == null) {
            throw new NullPointerException("date");
        }
        if (string == null) {
            throw new NullPointerException("outFormat");
        }
        byte[] byArray = this.dateToBytes(date);
        return this.convert(byArray, "*YYMD", string, null);
    }

    private byte[] dateToBytes(Date date) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Calendar calendar = this.getCalendar();
        calendar.setTime(date);
        Record record = this.getFormat17().getNewRecord();
        record.setField("year", (Object)Integer.toString(calendar.get(1)));
        int n = calendar.get(2) + 1;
        String string = (n < 10 ? "0" : "") + n;
        record.setField("month", (Object)string);
        int n2 = calendar.get(5);
        String string2 = (n2 < 10 ? "0" : "") + n2;
        record.setField("day", (Object)string2);
        int n3 = calendar.get(11);
        String string3 = (n3 < 10 ? "0" : "") + n3;
        record.setField("hour", (Object)string3);
        int n4 = calendar.get(12);
        String string4 = (n4 < 10 ? "0" : "") + n4;
        record.setField("minute", (Object)string4);
        int n5 = calendar.get(13);
        String string5 = (n5 < 10 ? "0" : "") + n5;
        record.setField("second", (Object)string5);
        int n6 = calendar.get(14);
        String string6 = (n6 < 100 ? "0" : "") + (n6 < 10 ? "0" : "") + n6;
        record.setField("millisecond", (Object)string6);
        if (Trace.traceOn_) {
            Trace.log(1, "DateTimeConverter record parsed from Date: " + record.toString());
        }
        return record.getContents();
    }

    private final Calendar getCalendar() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.calendar_ == null) {
            this.calendar_ = AS400Calendar.getGregorianInstance(this.getSystemTimeZone());
        } else {
            this.calendar_.clear();
        }
        return this.calendar_;
    }

    private synchronized DateTime17Format getFormat17() {
        if (this.format17_ == null) {
            this.format17_ = new DateTime17Format(this.system_);
        }
        return this.format17_;
    }

    final TimeZone getSystemTimeZone() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.systemTimeZone_ == null) {
            this.systemTimeZone_ = DateTimeConverter.timeZoneForSystem(this.system_);
        }
        return this.systemTimeZone_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String iTimeZoneToJavaTimeZone(String string) {
        string = string.toUpperCase();
        String[][] stringArray = iTimeZoneTojavaTimeZoneMapping;
        synchronized (iTimeZoneTojavaTimeZoneMapping) {
            if (iTimeZoneToJavaTimeZoneHash == null) {
                iTimeZoneToJavaTimeZoneHash = new Hashtable();
                for (int i = 0; i < iTimeZoneTojavaTimeZoneMapping.length; ++i) {
                    iTimeZoneToJavaTimeZoneHash.put(iTimeZoneTojavaTimeZoneMapping[i][0], iTimeZoneTojavaTimeZoneMapping[i][1]);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (String)iTimeZoneToJavaTimeZoneHash.get(string);
        }
    }

    public static TimeZone timeZoneForSystem(AS400 aS400) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Object object;
        Object object2;
        try {
            object2 = new SystemValue(aS400, "QTIMZON");
            object = (String)((SystemValue)object2).getValue();
            String string = DateTimeConverter.iTimeZoneToJavaTimeZone((String)object);
            if (string != null) {
                return TimeZone.getTimeZone(string);
            }
        }
        catch (Exception exception) {
            Trace.log(2, exception);
        }
        object2 = null;
        try {
            object = new SystemValue(aS400, "QUTCOFFSET");
            object2 = (String)((SystemValue)object).getValue();
            if (object2 == null || ((String)object2).length() == 0) {
                if (Trace.traceOn_) {
                    Trace.log(1, "QUTCOFFSET is not set. Assuming server is in the same time zone as client application.");
                }
                return TimeZone.getDefault();
            }
            return TimeZone.getTimeZone("GMT" + (String)object2);
        }
        catch (RequestNotSupportedException requestNotSupportedException) {
            Trace.log(2, requestNotSupportedException);
            throw new InternalErrorException(10, (Throwable)requestNotSupportedException);
        }
        catch (RuntimeException runtimeException) {
            if (Trace.traceOn_) {
                Trace.log(4, "[" + runtimeException.toString() + "] Unable to determine time zone of system. " + "QUTCOFFSET value is " + (String)object2 + ". " + "Assuming server is in the same time zone as client application.");
            }
            return TimeZone.getDefault();
        }
    }

    static final String formatDateForCommandParameter(byte[] byArray, String string) throws UnsupportedEncodingException {
        int n = 0;
        String string2 = null;
        String string3 = CharConverter.byteArrayToString(37, byArray);
        if (string.equals("*DTS")) {
            n = 8;
        } else if (string.equals("*YYMD") || string.equals("*MDYY") || string.equals("*DMYY") || string.equals("*LONGJUL")) {
            n = 17;
        } else if (string.equals("*MDY") || string.equals("*YMD") || string.equals("*DMY")) {
            string2 = string3.substring(1, 7);
        } else if (string.equals("*JUL")) {
            string2 = string3.substring(1, 6);
        } else {
            n = 16;
        }
        if (string2 != null) {
            return string2;
        }
        if (string3.length() == n) {
            return string3;
        }
        return string3.substring(0, n);
    }

    private static class DateTime17Format
    extends RecordFormat {
        private static final long serialVersionUID = 1L;

        DateTime17Format(AS400 aS400) {
            int n = aS400.getCcsid();
            AS400Text aS400Text = new AS400Text(2, n, aS400);
            this.addFieldDescription(new CharacterFieldDescription(new AS400Text(4, n, aS400), "year"));
            this.addFieldDescription(new CharacterFieldDescription(aS400Text, "month"));
            this.addFieldDescription(new CharacterFieldDescription(aS400Text, "day"));
            this.addFieldDescription(new CharacterFieldDescription(aS400Text, "hour"));
            this.addFieldDescription(new CharacterFieldDescription(aS400Text, "minute"));
            this.addFieldDescription(new CharacterFieldDescription(aS400Text, "second"));
            this.addFieldDescription(new CharacterFieldDescription(new AS400Text(3, n, aS400), "millisecond"));
        }
    }
}

