/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.JDTrace;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.DriverManager;
import java.sql.SQLException;

abstract class AS400JDBCOutputStream
extends OutputStream {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private boolean closed_ = false;
    private long position_;

    AS400JDBCOutputStream(long l) {
        this.position_ = l;
    }

    public void close() {
        this.closed_ = true;
    }

    public void flush() {
    }

    public synchronized void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("byteArray");
        }
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("byteArray");
        }
        if (n < 0 || n > n2) {
            throw new ExtendedIllegalArgumentException("off", 2);
        }
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("len", 2);
        }
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        try {
            int n3 = this.doWrite(this.position_, byArray, n, n2);
            if (n3 != n2) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Unable to write requested number of bytes: " + n3 + " != " + n2);
                }
                this.closed_ = true;
                throw new IOException();
            }
            this.position_ += (long)n2;
        }
        catch (SQLException sQLException) {
            if (JDTrace.isTraceOn()) {
                sQLException.printStackTrace(DriverManager.getLogWriter());
            }
            this.closed_ = true;
            IOException iOException = new IOException(sQLException.getMessage());
            try {
                iOException.initCause(sQLException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw iOException;
        }
    }

    public synchronized void write(int n) throws IOException {
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        try {
            int n2 = this.doWrite(this.position_, (byte)n);
            if (n2 != 1) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Unable to write requested number of bytes: " + n2 + " != 1");
                }
                this.closed_ = true;
                throw new IOException();
            }
            ++this.position_;
        }
        catch (SQLException sQLException) {
            if (JDTrace.isTraceOn()) {
                sQLException.printStackTrace(DriverManager.getLogWriter());
            }
            this.closed_ = true;
            IOException iOException = new IOException(sQLException.getMessage());
            try {
                iOException.initCause(sQLException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw iOException;
        }
    }

    abstract int doWrite(long var1, byte[] var3, int var4, int var5) throws SQLException;

    abstract int doWrite(long var1, byte var3) throws SQLException;
}

