/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlobLocatorOutputStream;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class AS400JDBCBlobLocator
implements Blob {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    JDLobLocator locator_;
    Object savedObject_;
    int savedScale_;
    private byte[] cache_;
    private int cacheOffset_;
    private static final byte[] INIT_CACHE = new byte[0];
    private int maxLength_;

    AS400JDBCBlobLocator(JDLobLocator jDLobLocator, Object object, int n) {
        this.locator_ = jDLobLocator;
        this.savedObject_ = object;
        this.savedScale_ = n;
        this.maxLength_ = this.locator_.getMaxLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream() throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            return new AS400JDBCInputStream(this.locator_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long l, int n) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            int n2;
            int n3 = (int)l - 1;
            if (n3 < 0 || n < 0 || (long)(n3 + n) > this.locator_.getLength()) {
                JDError.throwSQLException((Object)this, "HY024");
            }
            if ((n2 = (int)this.locator_.getLength() - n3) <= 0) {
                return new byte[0];
            }
            if (n2 > n) {
                n2 = n;
            }
            DBLobData dBLobData = this.locator_.retrieveData(n3, n2);
            int n4 = dBLobData.getLength();
            byte[] byArray = new byte[n4];
            System.arraycopy(dBLobData.getRawBytes(), dBLobData.getOffset(), byArray, 0, n4);
            return byArray;
        }
    }

    public int getHandle() throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        return this.locator_.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            return this.locator_.getLength();
        }
    }

    private void initCache() {
        this.cacheOffset_ = 0;
        this.cache_ = INIT_CACHE;
    }

    private int getCachedByte(int n) throws SQLException {
        int n2 = n - this.cacheOffset_;
        if (n2 >= this.cache_.length) {
            int n3 = 1000000;
            int n4 = (int)this.locator_.getLength();
            if (n4 < 0) {
                n4 = Integer.MAX_VALUE;
            }
            if (n3 + n > n4) {
                n3 = n4 - n;
            }
            this.cache_ = this.getBytes(n + 1, n3);
            this.cacheOffset_ = n;
            n2 = 0;
        }
        if (this.cache_.length == 0) {
            return -1;
        }
        return this.cache_[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(byte[] byArray, long l) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            int n = (int)l - 1;
            if (byArray == null || n < 0 || (long)n >= this.locator_.getLength()) {
                throw JDError.throwSQLException((Object)this, "HY024");
            }
            int n2 = (int)this.locator_.getLength() - byArray.length;
            this.initCache();
            for (int i = n; i <= n2; ++i) {
                int n3 = 0;
                int n4 = this.getCachedByte(i + n3);
                while (n3 < byArray.length && n4 != -1 && byArray[n3] == (byte)n4) {
                    n4 = this.getCachedByte(i + ++n3);
                }
                if (n3 != byArray.length) continue;
                return i + 1;
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(Blob blob, long l) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            int n;
            int n2 = (int)l - 1;
            if (blob == null || n2 < 0 || (long)n2 >= this.locator_.getLength()) {
                throw JDError.throwSQLException((Object)this, "HY024");
            }
            int n3 = (int)blob.length();
            if (n3 > (n = (int)this.locator_.getLength()) || n3 < 0) {
                return -1L;
            }
            int n4 = n - n3;
            byte[] byArray = blob.getBytes(1L, n3);
            this.initCache();
            for (int i = n2; i <= n4; ++i) {
                int n5 = 0;
                int n6 = this.getCachedByte(i + n5);
                while (n5 < n3 && n6 != -1 && byArray[n5] == (byte)n6) {
                    n6 = this.getCachedByte(i + ++n5);
                }
                if (n5 != n3) continue;
                return i + 1;
            }
            return -1L;
        }
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if (l <= 0L || l > (long)this.maxLength_) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        return new AS400JDBCBlobLocatorOutputStream(this, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            int n;
            int n2 = (int)l - 1;
            if (n2 < 0 || n2 >= this.maxLength_ || byArray == null) {
                throw JDError.throwSQLException((Object)this, "HY024");
            }
            int n3 = n2 + byArray.length;
            if (n3 < 0) {
                n3 = Integer.MAX_VALUE;
            }
            if ((n = n3 - n2) != byArray.length) {
                byte[] byArray2 = byArray;
                byArray = new byte[n];
                System.arraycopy(byArray2, 0, byArray, 0, n);
            }
            this.locator_.writeData((long)n2, byArray, false);
            return byArray.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            int n3;
            int n4;
            int n5 = (int)l - 1;
            if (n5 < 0 || n5 >= this.maxLength_ || byArray == null || n < 0 || n2 < 0 || n + n2 > byArray.length || n5 + n2 > this.maxLength_) {
                JDError.throwSQLException((Object)this, "HY024");
            }
            if ((n4 = n5 + n2) < 0) {
                n4 = Integer.MAX_VALUE;
            }
            int n6 = (n3 = n4 - n5) < n2 ? n3 : n2;
            byte[] byArray2 = new byte[n6];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.locator_.writeData((long)n5, byArray2, false);
            return byArray2.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long l) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            int n = (int)l;
            if (n < 0 || n > this.maxLength_) {
                JDError.throwSQLException((Object)this, "HY024");
            }
            this.locator_.writeData(n, new byte[0], 0, 0, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() throws SQLException {
        if (this.locator_ == null) {
            return;
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            this.locator_.free();
            this.locator_ = null;
            this.savedObject_ = null;
            this.cache_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            return new AS400JDBCInputStream(this.locator_, l, l2);
        }
    }

    public int getLocator() {
        return this.locator_.getHandle();
    }
}

