/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400FileImplBase;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DDMAS400MessageReply;
import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.DDMEndUnitOfWorkReply;
import com.ibm.as400.access.DDMObjectDataStream;
import com.ibm.as400.access.DDMReplyDataStream;
import com.ibm.as400.access.DDMRequestDataStream;
import com.ibm.as400.access.DDMS38IOFB;
import com.ibm.as400.access.DDMS38OpenFeedback;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.ZonedDecimalFieldDescription;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.UnknownHostException;
import java.util.Vector;

class AS400FileImplRemote
extends AS400FileImplBase
implements Serializable {
    static final long serialVersionUID = 4L;
    byte[] dclName_ = new byte[8];
    static long nextDCLName_ = 1L;
    static final Object nextDCLNameLock_ = new Object();
    private static byte[] s38Buffer = new byte[]{0, 5, -44, 5, 0};
    transient AS400Server server_ = null;
    private static int lastCorrelationId_ = 0;
    private static Object correlationIdLock_ = new Object();

    public AS400FileImplRemote() {
        this.setDCLName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        super.close();
        if (this.discardReplys_ && this.server_ != null) {
            AS400Server aS400Server = this.server_;
            synchronized (aS400Server) {
                this.server_.sendAndDiscardReply(DDMRequestDataStream.getRequestS38CLOSE(this.dclName_));
            }
        } else {
            Vector vector = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38CLOSE(this.dclName_), this.newCorrelationId());
            if (vector.size() != 1 || !this.verifyS38MSGRM((DDMDataStream)vector.elementAt(0), null, 0)) {
                this.handleErrorReply(vector, 0);
            }
        }
    }

    public void commit() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.connect();
        Vector vector = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestCMMUOW(), this.newCorrelationId());
        if (vector.size() == 1 && ((DDMDataStream)vector.elementAt(0)).getCodePoint() == 8716) {
            DDMEndUnitOfWorkReply dDMEndUnitOfWorkReply = new DDMEndUnitOfWorkReply(((DDMDataStream)vector.elementAt((int)0)).data_);
            if (dDMEndUnitOfWorkReply.getStatus() != 1) {
                Trace.log(2, "Wrong status returned from commit ds", dDMEndUnitOfWorkReply.data_);
                throw new InternalErrorException(6, dDMEndUnitOfWorkReply.getStatus());
            }
        } else {
            this.handleErrorReply(vector, 0);
        }
    }

    public void connect() throws AS400SecurityException, ConnectionDroppedException, IOException, InterruptedException, ServerStartupException, UnknownHostException {
        if (this.server_ == null) {
            this.server_ = this.system_.getConnection(5, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void createDDSSourceFile(RecordFormat recordFormat, String string, String string2, String string3, String string4, boolean bl, String string5, String string6) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        String string7;
        AS400Message[] aS400MessageArray = this.execute("QSYS/CRTSRCPF FILE(QTEMP/JT400DSSRC) RCDLEN(92) MBR(*FILE) TEXT('JT400 TEMPORARY DDS SOURCE FILE')");
        if (aS400MessageArray.length <= 0) {
            Trace.log(2, "No messages from server.");
            throw new InternalErrorException(6);
        }
        if (aS400MessageArray[0].getID().equals("CPF5813")) {
            aS400MessageArray = this.execute("QSYS/CLRPFM QTEMP/JT400DSSRC");
            if (aS400MessageArray.length <= 0) {
                Trace.log(2, "No messages were returned from QSYS/CLRPFM QTEMP/JT400DSSRC");
                throw new InternalErrorException("QTEMP/JT400DSSRC", 6);
            }
            if (!aS400MessageArray[0].getID().equals("CPC3101")) {
                Trace.log(2, "QSYS/CLRPFM QTEMP/JT400DSSRC");
                throw new AS400Exception(aS400MessageArray);
            }
        } else if (!aS400MessageArray[0].getID().equals("CPC7301")) {
            Trace.log(2, "QSYS/CRTSRCPF FILE(QTEMP/JT400DSSRC) RCDLEN(92) MBR(*FILE) TEXT('JT400 TEMPORARY DDS SOURCE FILE')");
            throw new AS400Exception(aS400MessageArray);
        }
        RecordFormat recordFormat2 = new RecordFormat("JT400DSSRC");
        recordFormat2.addFieldDescription(new ZonedDecimalFieldDescription(new AS400ZonedDecimal(6, 2), "SRCSEQ"));
        recordFormat2.addFieldDescription(new ZonedDecimalFieldDescription(new AS400ZonedDecimal(6, 0), "SRCDAT"));
        recordFormat2.addFieldDescription(new CharacterFieldDescription(new AS400Text(80, this.system_.getCcsid()), "SRCDTA"));
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            string7 = "                                            ALTSEQ(" + string + ")";
            vector.addElement(string7);
        }
        if (string2 != null) {
            string7 = "                                            CCSID(" + string2 + ")";
            vector.addElement(string7);
        }
        if (string3 != null) {
            string7 = "                                            " + string3;
            vector.addElement(string7);
        }
        if (string4 != null) {
            string7 = "                                            REF(" + string4 + ")";
            vector.addElement(string7);
        }
        if (bl) {
            string7 = "                                            UNIQUE";
            vector.addElement(string7);
        }
        string7 = "                R ";
        if (recordFormat.getName().length() > 10) {
            if (Trace.traceOn_) {
                Trace.log(4, "Record format name '" + recordFormat.getName() + "' too long. Using '" + recordFormat.getName().substring(0, 10) + "' instead.");
            }
            string7 = string7 + recordFormat.getName().substring(0, 10);
        } else {
            string7 = string7 + recordFormat.getName();
        }
        vector.addElement(string7);
        if (string5 != null) {
            string7 = "                                            FORMAT(" + string5 + ")";
            vector.addElement(string7);
        }
        if (string6 != null) {
            if (string6.length() > 32) {
                string7 = "                                            TEXT('" + string6.substring(0, 33) + "-";
                vector.addElement(string7);
                string7 = "                                            " + string6.substring(34) + "')";
                vector.addElement(string7);
            } else {
                string7 = "                                            TEXT('" + string6 + "')";
                vector.addElement(string7);
            }
        }
        int n = recordFormat.getNumberOfFields();
        FieldDescription fieldDescription = null;
        String[] stringArray = null;
        int n2 = 0;
        while (true) {
            String string8;
            if (n2 < n) {
                fieldDescription = recordFormat.getFieldDescription(n2);
                stringArray = fieldDescription.getDDSDescription();
                string8 = "                  " + stringArray[0];
                vector.addElement(string8);
            } else {
                n = recordFormat.getNumberOfKeyFields();
                break;
            }
            for (int i = 1; i < stringArray.length; ++i) {
                string8 = "                                            " + stringArray[i];
                int n3 = string8.length();
                int n4 = 0;
                if (n3 > 80) {
                    string7 = string8.substring(n4, 79) + "-";
                    vector.addElement(string7);
                    n3 -= 79;
                    n4 = 79;
                    string7 = "                                            " + string8.substring(n4);
                    vector.addElement(string7);
                    continue;
                }
                vector.addElement(string8);
            }
            ++n2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            fieldDescription = recordFormat.getKeyFieldDescription(n2);
            string7 = "                K ";
            string7 = string7 + fieldDescription.getDDSName();
            vector.addElement(string7);
            String[] stringArray2 = fieldDescription.getKeyFieldFunctions();
            if (stringArray2 == null) continue;
            for (int n5 = 0; n5 < stringArray2.length; n5 = (int)((short)(n5 + 1))) {
                string7 = "                                            " + stringArray2[n5];
                vector.addElement(string7);
            }
        }
        Record[] recordArray = new Record[vector.size()];
        for (int i = 0; i < recordArray.length; ++i) {
            recordArray[i] = recordFormat2.getNewRecord();
            recordArray[i].setField("SRCSEQ", (Object)new BigDecimal((double)i));
            recordArray[i].setField("SRCDAT", (Object)new BigDecimal((double)i));
            recordArray[i].setField("SRCDTA", vector.elementAt(i));
        }
        AS400FileImplRemote aS400FileImplRemote = null;
        try {
            aS400FileImplRemote = new AS400FileImplRemote();
            aS400FileImplRemote.setAll(this.system_, "/QSYS.LIB/QTEMP.LIB/JT400DSSRC.FILE", recordFormat2, false, false, false);
            aS400FileImplRemote.openFile2(2, recordArray.length, 3, false);
            aS400FileImplRemote.write(recordArray);
            aS400FileImplRemote.close();
            return;
        }
        catch (Exception exception) {
            Trace.log(2, "Unable to write records to DDS source file:", (Throwable)exception);
            try {
                if (aS400FileImplRemote != null) {
                    aS400FileImplRemote.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (exception instanceof AS400Exception) {
                throw (AS400Exception)exception;
            }
            Trace.log(2, exception);
            throw new InternalErrorException(6, (Throwable)exception);
        }
    }

    public void deleteCurrentRecord() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.connect();
        Vector vector = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38DEL(this.dclName_), this.newCorrelationId());
        if (vector.size() != 1 || ((DDMDataStream)vector.elementAt(0)).getCodePoint() != 54274) {
            this.handleErrorReply(vector, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AS400Message[] execute(String string) throws AS400SecurityException, InterruptedException, IOException {
        this.connect();
        Vector vector = null;
        if (this.discardReplys_) {
            AS400Server aS400Server = this.server_;
            synchronized (aS400Server) {
                this.server_.sendAndDiscardReply(DDMRequestDataStream.getRequestS38CMD(string, this.system_));
            }
        } else {
            vector = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38CMD(string, this.system_), this.newCorrelationId());
        }
        return this.processReplys(vector);
    }

    public void handleErrorReply(Vector vector, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int n2;
        int n3 = vector.size();
        Vector<AS400Message[]> vector2 = new Vector<AS400Message[]>();
        block4: for (n2 = n; n2 < n3; ++n2) {
            DDMDataStream dDMDataStream = (DDMDataStream)vector.elementAt(n2);
            int n4 = dDMDataStream.getCodePoint();
            switch (n4) {
                case 53761: {
                    DDMAS400MessageReply dDMAS400MessageReply = new DDMAS400MessageReply(this.system_, dDMDataStream.data_);
                    vector2.addElement(dDMAS400MessageReply.getAS400MessageList());
                    continue block4;
                }
                case 4658: 
                case 4659: 
                case 4677: 
                case 4684: 
                case 4688: 
                case 4689: 
                case 4690: 
                case 4692: 
                case 4694: {
                    Trace.log(2, "handleErrorReply()", dDMDataStream.data_);
                    throw new InternalErrorException(6, n4);
                }
                default: {
                    Trace.log(2, "handleErrorReply()", dDMDataStream.data_);
                    throw new InternalErrorException(2, n4);
                }
            }
        }
        if (vector2.size() > 0) {
            n2 = 0;
            int n5 = vector2.size();
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                n2 += ((AS400Message[])vector2.elementAt(i)).length;
            }
            AS400Message[] aS400MessageArray = new AS400Message[n2];
            for (int i = 0; i < n5; ++i) {
                AS400Message[] aS400MessageArray2 = (AS400Message[])vector2.elementAt(i);
                for (int j = 0; j < aS400MessageArray2.length; ++j) {
                    aS400MessageArray[n6++] = aS400MessageArray2[j];
                }
            }
            throw new AS400Exception(aS400MessageArray);
        }
        Trace.log(2, "No messages from server.");
        throw new InternalErrorException(2);
    }

    public void logWarningMessages(Vector vector, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            for (int i = 0; i < n; ++i) {
                DDMAS400MessageReply dDMAS400MessageReply = new DDMAS400MessageReply(this.system_, ((DDMDataStream)vector.elementAt((int)i)).data_);
                AS400Message[] aS400MessageArray = dDMAS400MessageReply.getAS400MessageList();
                Trace.log(4, "AS400FileImplRemote.logWarningMessages():");
                for (int j = 0; j < aS400MessageArray.length; ++j) {
                    Trace.log(4, aS400MessageArray[j].toString());
                }
            }
        }
    }

    private int lookForCodePoint(int n, Vector vector) {
        int n2 = -1;
        int n3 = vector.size();
        for (int i = 0; i < n3 && n2 == -1; ++i) {
            DDMDataStream dDMDataStream = (DDMDataStream)vector.elementAt(i);
            int n4 = 8;
            while (n2 == -1 && n4 < dDMDataStream.data_.length) {
                if (dDMDataStream.get16bit(n4) == n) {
                    n2 = i;
                    continue;
                }
                n4 += dDMDataStream.get16bit(n4 - 2);
            }
        }
        return n2;
    }

    public DDMS38OpenFeedback openFile(int n, int n2, String string) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.connect();
        byte[] byArray = this.createUFCB(n, n2, string, false);
        Vector vector = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38OPEN(byArray, this.dclName_), this.newCorrelationId());
        int n3 = this.lookForCodePoint(54276, vector);
        if (n3 != -1) {
            DDMDataStream dDMDataStream = (DDMDataStream)vector.elementAt(n3);
            this.openFeedback_ = new DDMS38OpenFeedback(this.system_, dDMDataStream.data_);
            if (Trace.traceOn_) {
                Trace.log(3, "AS400FileImplRemote.openFile()\n" + this.openFeedback_.toString());
            }
            if (n3 != 0) {
                this.logWarningMessages(vector, n3);
            }
        } else {
            this.handleErrorReply(vector, 0);
        }
        return this.openFeedback_;
    }

    public void padBytes(byte[] byArray, int n, int n2, byte by) {
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = by;
        }
    }

    public Record[] positionCursorAt(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int n2 = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
        Vector vector = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GET(this.dclName_, n, n2, 0), this.newCorrelationId());
        int n3 = ((DDMDataStream)vector.elementAt(0)).getCodePoint();
        if (n3 == 54274 && vector.size() > 1) {
            this.handleErrorReply(vector, 1);
        } else if (n3 != 54277) {
            this.handleErrorReply(vector, 0);
        }
        Record[] recordArray = this.processReadReply(vector, false);
        return recordArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionCursorAfterLast() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_ && this.cache_.containsLastRecord()) {
            this.cache_.setPositionAfterLast();
            return;
        }
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        this.connect();
        int n = this.newCorrelationId();
        DDMRequestDataStream dDMRequestDataStream = DDMRequestDataStream.getRequestS38FEOD(this.dclName_, 2, 2, 1);
        dDMRequestDataStream.setIsChained(true);
        dDMRequestDataStream.setHasSameRequestCorrelation(true);
        Vector vector = null;
        try {
            AS400Server aS400Server = this.server_;
            synchronized (aS400Server) {
                this.server_.send(dDMRequestDataStream, n);
                DDMObjectDataStream dDMObjectDataStream = new DDMObjectDataStream(11);
                System.arraycopy(s38Buffer, 0, dDMObjectDataStream.data_, 6, 5);
                vector = this.sendRequestAndReceiveReplies(dDMObjectDataStream, n);
            }
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "ConnectionDroppedException:", (Throwable)connectionDroppedException);
            this.system_.disconnectServer(this.server_);
            this.resetState();
            throw connectionDroppedException;
        }
        if (((DDMDataStream)vector.elementAt(0)).getCodePoint() == 54274) {
            if (vector.size() != 1 && !this.verifyS38MSGRM((DDMDataStream)vector.elementAt(1), "CPF5001", 0)) {
                this.handleErrorReply(vector, 1);
            }
        } else {
            this.handleErrorReply(vector, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionCursorBeforeFirst() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_ && this.cache_.containsFirstRecord()) {
            this.cache_.setPositionBeforeFirst();
            return;
        }
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        this.connect();
        int n = this.newCorrelationId();
        DDMRequestDataStream dDMRequestDataStream = DDMRequestDataStream.getRequestS38FEOD(this.dclName_, 1, 2, 1);
        dDMRequestDataStream.setIsChained(true);
        dDMRequestDataStream.setHasSameRequestCorrelation(true);
        Vector vector = null;
        try {
            AS400Server aS400Server = this.server_;
            synchronized (aS400Server) {
                this.server_.send(dDMRequestDataStream, n);
                DDMObjectDataStream dDMObjectDataStream = new DDMObjectDataStream(11);
                System.arraycopy(s38Buffer, 0, dDMObjectDataStream.data_, 6, 5);
                vector = this.sendRequestAndReceiveReplies(dDMObjectDataStream, n);
            }
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "ConnectionDroppedException:", (Throwable)connectionDroppedException);
            this.system_.disconnectServer(this.server_);
            this.resetState();
            throw connectionDroppedException;
        }
        if (((DDMDataStream)vector.elementAt(0)).getCodePoint() == 54274) {
            if (vector.size() != 1 && !this.verifyS38MSGRM((DDMDataStream)vector.elementAt(1), "CPF5001", 0)) {
                this.handleErrorReply(vector, 1);
            }
        } else {
            this.handleErrorReply(vector, 0);
        }
    }

    public Record positionCursorToIndex(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int n2;
        Vector vector;
        int n3;
        if (this.cacheRecords_ && !this.cache_.setPosition(n)) {
            this.cache_.setIsEmpty();
        }
        if ((n3 = ((DDMDataStream)(vector = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETD(this.dclName_, this.recordFormatCTLLName_, 8, n2 = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3, 0, n, this.system_), this.newCorrelationId())).elementAt(0)).getCodePoint()) == 54274 && vector.size() > 1) {
            this.handleErrorReply(vector, 1);
        } else if (n3 != 54277) {
            this.handleErrorReply(vector, 0);
        }
        Record[] recordArray = this.processReadReply(vector, false);
        return recordArray[0];
    }

    public Record positionCursorToKey(Object[] objectArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int n2;
        Vector vector;
        int n3;
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        if ((n3 = ((DDMDataStream)(vector = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETK(this.dclName_, this.recordFormat_, this.recordFormatCTLLName_, n, n2 = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3, 0, objectArray, this.system_), this.newCorrelationId())).elementAt(0)).getCodePoint()) == 54274 && vector.size() > 1) {
            this.handleErrorReply(vector, 1);
        } else if (n3 != 54277) {
            this.handleErrorReply(vector, 0);
        }
        this.processReadReply(vector, true);
        return null;
    }

    public Record positionCursorToKey(byte[] byArray, int n, int n2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int n3;
        Vector vector;
        int n4;
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        if ((n4 = ((DDMDataStream)(vector = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETK(this.dclName_, this.recordFormatCTLLName_, n, n3 = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3, 0, byArray, this.system_, n2), this.newCorrelationId())).elementAt(0)).getCodePoint()) == 54274 && vector.size() > 1) {
            this.handleErrorReply(vector, 1);
        } else if (n4 != 54277) {
            this.handleErrorReply(vector, 0);
        }
        this.processReadReply(vector, true);
        return null;
    }

    public Record[] processReadReply(Vector vector, boolean bl) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record[] recordArray = null;
        int n = this.openFeedback_.getRecordIncrement();
        int n2 = ((DDMDataStream)vector.elementAt(0)).getCodePoint();
        if (n2 == 54274) {
            if (vector.size() > 1) {
                n2 = ((DDMDataStream)vector.elementAt(1)).getCodePoint();
                if (n2 == 53761) {
                    DDMAS400MessageReply dDMAS400MessageReply = new DDMAS400MessageReply(this.system_, ((DDMDataStream)vector.elementAt((int)1)).data_);
                    String string = dDMAS400MessageReply.getAS400Message().getID();
                    if (string.equals("CPF5006") || string.equals("CPF5001")) {
                        return recordArray;
                    }
                    this.handleErrorReply(vector, 1);
                } else {
                    this.handleErrorReply(vector, 1);
                }
            } else {
                this.handleErrorReply(vector, 0);
            }
        } else if (n2 == 54277) {
            int n3;
            DDMS38IOFB dDMS38IOFB;
            boolean bl2;
            if (bl) {
                return recordArray;
            }
            DDMDataStream dDMDataStream = (DDMDataStream)vector.elementAt(0);
            boolean bl3 = bl2 = dDMDataStream.get16bit(6) > Short.MAX_VALUE;
            if (dDMDataStream.isChained()) {
                dDMS38IOFB = new DDMS38IOFB(((DDMDataStream)vector.elementAt((int)1)).data_, 10);
            } else {
                n3 = bl2 ? dDMDataStream.get32bit(10) + 18 : dDMDataStream.get16bit(6) + 10;
                dDMS38IOFB = new DDMS38IOFB(dDMDataStream.data_, n3);
            }
            n3 = dDMS38IOFB.getNumberOfRecordsReturned();
            recordArray = new Record[n3];
            int n4 = bl2 ? 14 : 10;
            int n5 = n4 + dDMS38IOFB.getRecordLength() + 2;
            int n6 = n4 + this.openFeedback_.getNullFieldByteMapOffset();
            int n7 = this.recordFormat_.getNumberOfFields();
            boolean bl4 = this.openFeedback_.isNullCapable();
            for (int i = 0; i < n3; ++i) {
                recordArray[i] = this.recordFormat_.getNewRecord(dDMDataStream.data_, n4 + i * n);
                if (bl4) {
                    for (int j = 0; j < n7; ++j) {
                        if (dDMDataStream.data_[n6 + j + i * n] != -15) continue;
                        recordArray[i].setField(j, null);
                    }
                }
                try {
                    recordArray[i].setRecordNumber(BinaryConverter.byteArrayToInt(dDMDataStream.data_, n5 + i * n));
                    continue;
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        } else {
            this.handleErrorReply(vector, 0);
        }
        return recordArray;
    }

    public AS400Message[] processReplys(Vector vector) throws AS400SecurityException, InterruptedException, IOException {
        int n;
        int n2;
        AS400Message[] aS400MessageArray = null;
        Vector<AS400Message[]> vector2 = new Vector<AS400Message[]>();
        if (vector != null) {
            block4: for (n2 = 0; n2 < vector.size(); ++n2) {
                DDMDataStream dDMDataStream = (DDMDataStream)vector.elementAt(n2);
                n = dDMDataStream.getCodePoint();
                switch (n) {
                    case 53761: {
                        DDMAS400MessageReply dDMAS400MessageReply = new DDMAS400MessageReply(this.system_, dDMDataStream.data_);
                        vector2.addElement(dDMAS400MessageReply.getAS400MessageList());
                        continue block4;
                    }
                    case 4658: 
                    case 4659: 
                    case 4677: 
                    case 4684: 
                    case 4688: 
                    case 4689: 
                    case 4690: 
                    case 4692: 
                    case 4694: {
                        Trace.log(2, "handleErrorReply()", dDMDataStream.data_);
                        throw new InternalErrorException(6, n);
                    }
                    default: {
                        Trace.log(2, "handleErrorReply()", dDMDataStream.data_);
                        throw new InternalErrorException(2, n);
                    }
                }
            }
        }
        if (vector2.size() > 0) {
            n2 = 0;
            int n3 = vector2.size();
            n = 0;
            for (int i = 0; i < n3; ++i) {
                n2 += ((AS400Message[])vector2.elementAt(i)).length;
            }
            aS400MessageArray = new AS400Message[n2];
            for (int i = 0; i < n3; ++i) {
                AS400Message[] aS400MessageArray2 = (AS400Message[])vector2.elementAt(i);
                for (int j = 0; j < aS400MessageArray2.length; ++j) {
                    aS400MessageArray[n++] = aS400MessageArray2[j];
                }
            }
        }
        return aS400MessageArray == null ? new AS400Message[]{} : aS400MessageArray;
    }

    public Record read(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            return super.read(n);
        }
        int n2 = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
        Vector vector = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETD(this.dclName_, this.recordFormatCTLLName_, 8, n2, 0, n, this.system_), this.newCorrelationId());
        Record[] recordArray = this.processReadReply(vector, false);
        return recordArray == null ? null : recordArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record[] readAll(String string, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Object[] objectArray = new Record[]{};
        AS400FileImplRemote aS400FileImplRemote = this;
        synchronized (aS400FileImplRemote) {
            this.openFile2(0, n, 3, string);
            Vector<Record> vector = new Vector<Record>();
            int n2 = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
            Record[] recordArray = this.processReadReply(this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GET(this.dclName_, 1, n2, 0), this.newCorrelationId()), false);
            while (recordArray != null) {
                for (int i = 0; i < recordArray.length; ++i) {
                    vector.addElement(recordArray[i]);
                }
                recordArray = this.processReadReply(this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GET(this.dclName_, 3, n2, 0), this.newCorrelationId()), false);
            }
            int n3 = vector.size();
            if (n3 > 0) {
                objectArray = new Record[n3];
                vector.copyInto(objectArray);
            }
            this.close();
        }
        return objectArray;
    }

    public Record read(Object[] objectArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int n2 = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
        Vector vector = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETK(this.dclName_, this.recordFormat_, this.recordFormatCTLLName_, n, n2, 0, objectArray, this.system_), this.newCorrelationId());
        Record[] recordArray = this.processReadReply(vector, false);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return recordArray == null ? null : recordArray[0];
    }

    public Record read(byte[] byArray, int n, int n2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int n3 = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
        Vector vector = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETK(this.dclName_, this.recordFormatCTLLName_, n, n3, 0, byArray, this.system_, n2), this.newCorrelationId());
        Record[] recordArray = this.processReadReply(vector, false);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return recordArray == null ? null : recordArray[0];
    }

    public Record readRecord(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int n2 = this.openType_ == 0 || this.openType_ == 1 && this.readNoUpdate_ ? 0 : 3;
        Vector vector = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GET(this.dclName_, n, n2, 0), this.newCorrelationId());
        Record[] recordArray = this.processReadReply(vector, false);
        return recordArray == null ? null : recordArray[0];
    }

    public Record[] readRecords(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        int n2 = n == 0 ? 3 : 4;
        Vector vector = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestS38GETM(this.dclName_, this.blockingFactor_, n2, 0, 0, 1), this.newCorrelationId());
        return this.processReadReply(vector, false);
    }

    public void rollback() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.connect();
        Vector vector = this.sendRequestAndReceiveReplies(DDMRequestDataStream.getRequestRLLBCKUOW(), this.newCorrelationId());
        if (vector.size() == 1 && ((DDMDataStream)vector.elementAt(0)).getCodePoint() == 8716) {
            DDMEndUnitOfWorkReply dDMEndUnitOfWorkReply = new DDMEndUnitOfWorkReply(((DDMDataStream)vector.elementAt((int)0)).data_);
            if (dDMEndUnitOfWorkReply.getStatus() != 2) {
                Trace.log(2, "AS400FileImplRemote.rollback()", dDMEndUnitOfWorkReply.data_);
                throw new InternalErrorException(6, dDMEndUnitOfWorkReply.getStatus());
            }
        } else {
            this.handleErrorReply(vector, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector sendRequestAndReceiveReplies(DDMDataStream dDMDataStream, int n) throws InterruptedException, IOException, AS400SecurityException {
        Object object;
        this.connect();
        DDMDataStream dDMDataStream2 = null;
        try {
            object = this.server_;
            synchronized (object) {
                this.server_.send(dDMDataStream, n);
                dDMDataStream2 = (DDMDataStream)this.server_.receive(n);
            }
        }
        catch (ConnectionDroppedException connectionDroppedException) {
            Trace.log(2, "ConnectionDroppedException:", (Throwable)connectionDroppedException);
            this.system_.disconnectServer(this.server_);
            this.resetState();
            throw connectionDroppedException;
        }
        object = new Vector();
        while (dDMDataStream2.isChained()) {
            ((Vector)object).addElement(dDMDataStream2);
            try {
                dDMDataStream2 = (DDMDataStream)this.server_.receive(n);
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "ConnectionDroppedException:", (Throwable)connectionDroppedException);
                this.system_.disconnectServer(this.server_);
                this.resetState();
                throw connectionDroppedException;
            }
        }
        ((Vector)object).addElement(dDMDataStream2);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDCLName() {
        long l;
        Object object = nextDCLNameLock_;
        synchronized (object) {
            l = nextDCLName_++;
        }
        object = Long.toString(l);
        for (int i = 0; i < ((String)object).length(); ++i) {
            char c = ((String)object).charAt(i);
            this.dclName_[i] = (byte)(c & 0xF | 0xF0);
        }
        this.padBytes(this.dclName_, ((String)object).length(), 8 - ((String)object).length(), (byte)64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Record record) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (record.getRecordLength() != this.openFeedback_.getRecordLength()) {
            Trace.log(2, "Incorrect record length for file :");
            Trace.log(2, "record.getRecordLength() :" + String.valueOf(record.getRecordLength()));
            throw new ExtendedIllegalArgumentException("record", 2);
        }
        this.connect();
        Record[] recordArray = new Record[]{record};
        int n = this.newCorrelationId();
        DDMRequestDataStream dDMRequestDataStream = DDMRequestDataStream.getRequestS38UPDAT(33, 3, 0, this.dclName_);
        dDMRequestDataStream.setIsChained(true);
        dDMRequestDataStream.setHasSameRequestCorrelation(true);
        int n2 = -1;
        if (this.rfCache_ != null) {
            int n3 = this.rfCache_.length;
            for (int i = 0; i < n3; ++i) {
                n2 = Math.max(n2, this.rfCache_[i].getNumberOfFields());
            }
        }
        DDMObjectDataStream[] dDMObjectDataStreamArray = DDMObjectDataStream.getObjectS38BUF(recordArray, this.openFeedback_, this.ssp_, n2);
        Vector vector = null;
        AS400Server aS400Server = this.server_;
        synchronized (aS400Server) {
            try {
                this.server_.send(dDMRequestDataStream, n);
                vector = this.sendRequestAndReceiveReplies(dDMObjectDataStreamArray[0], n);
            }
            catch (ConnectionDroppedException connectionDroppedException) {
                Trace.log(2, "ConnectionDroppedException:", (Throwable)connectionDroppedException);
                this.system_.disconnectServer(this.server_);
                this.resetState();
                throw connectionDroppedException;
            }
        }
        if (((DDMDataStream)vector.elementAt(0)).getCodePoint() == 54274) {
            if (vector.size() != 1) {
                this.handleErrorReply(vector, 1);
            }
        } else {
            this.handleErrorReply(vector, 0);
        }
    }

    public boolean verifyS38MSGRM(DDMDataStream dDMDataStream, String string, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (dDMDataStream instanceof DDMReplyDataStream) {
            DDMReplyDataStream dDMReplyDataStream = (DDMReplyDataStream)dDMDataStream;
            DDMAS400MessageReply dDMAS400MessageReply = new DDMAS400MessageReply(this.system_, dDMReplyDataStream.data_);
            AS400Message[] aS400MessageArray = dDMAS400MessageReply.getAS400MessageList();
            for (int i = 0; i < aS400MessageArray.length; ++i) {
                if (!(string != null ? aS400MessageArray[i].getID().equalsIgnoreCase(string) : aS400MessageArray[i].getSeverity() == n)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Record[] recordArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (recordArray[0].getRecordLength() != this.openFeedback_.getRecordLength()) {
            if (Trace.traceOn_) {
                Trace.log(2, "Incorrect record length for file: Expected " + String.valueOf(this.openFeedback_.getRecordLength()) + ", got " + String.valueOf(recordArray[0].getRecordLength()));
            }
            throw new ExtendedIllegalArgumentException("records", 2);
        }
        this.connect();
        int n = this.newCorrelationId();
        DDMRequestDataStream dDMRequestDataStream = DDMRequestDataStream.getRequestS38PUTM(this.dclName_);
        dDMRequestDataStream.setIsChained(true);
        dDMRequestDataStream.setHasSameRequestCorrelation(true);
        int n2 = -1;
        if (this.rfCache_ != null) {
            int n3 = this.rfCache_.length;
            for (int i = 0; i < n3; ++i) {
                n2 = Math.max(n2, this.rfCache_[i].getNumberOfFields());
            }
        }
        DDMObjectDataStream[] dDMObjectDataStreamArray = DDMObjectDataStream.getObjectS38BUF(recordArray, this.openFeedback_, this.ssp_, n2);
        AS400Server aS400Server = this.server_;
        synchronized (aS400Server) {
            for (int i = 0; i < dDMObjectDataStreamArray.length; ++i) {
                this.server_.send(dDMRequestDataStream, n);
                Vector vector = this.sendRequestAndReceiveReplies(dDMObjectDataStreamArray[i], n);
                if (((DDMDataStream)vector.elementAt(0)).getCodePoint() == 54274) {
                    if (vector.size() == 1) continue;
                    this.handleErrorReply(vector, 1);
                    continue;
                }
                this.handleErrorReply(vector, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int newCorrelationId() {
        Object object = correlationIdLock_;
        synchronized (object) {
            if (lastCorrelationId_ == Short.MAX_VALUE) {
                lastCorrelationId_ = 0;
            }
            return ++lastCorrelationId_;
        }
    }

    static {
        AS400Server.addReplyStream((DataStream)new DDMObjectDataStream(), 5);
        AS400Server.addReplyStream((DataStream)new DDMReplyDataStream(), 5);
    }
}

