/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingEvent;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class WorkingCursorAdapter
implements WorkingListener,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final Cursor defaultCursor_ = Cursor.getDefaultCursor();
    private static final Cursor waitCursor_ = Cursor.getPredefinedCursor(3);
    private Component component_ = null;
    private transient Component disabledComponent_;
    private transient Frame frame_;
    private transient Cursor originalCursor_;
    private transient int startCount_;

    public WorkingCursorAdapter() {
        this.initializeTransient();
    }

    public WorkingCursorAdapter(Component component) {
        if (component == null) {
            throw new NullPointerException("component");
        }
        this.component_ = component;
        this.initializeTransient();
    }

    public Component getComponent() {
        return this.component_;
    }

    private void initializeTransient() {
        this.disabledComponent_ = null;
        this.frame_ = null;
        this.originalCursor_ = null;
        this.startCount_ = 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void setComponent(Component component) {
        if (component == null) {
            throw new NullPointerException("component");
        }
        this.component_ = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWorking(WorkingEvent workingEvent) {
        Component component = null;
        Cursor cursor = null;
        WorkingCursorAdapter workingCursorAdapter = this;
        synchronized (workingCursorAdapter) {
            if (this.component_ != null && (this.startCount_ == 0 || this.disabledComponent_ == null)) {
                component = this.disabledComponent_ = this.component_;
            }
            if (this.startCount_ == 0 || this.frame_ == null) {
                this.frame_ = VUtilities.getFrame(this.component_);
                if (this.frame_ != null) {
                    this.originalCursor_ = this.frame_.getCursor();
                    if (this.originalCursor_.getType() == waitCursor_.getType()) {
                        this.originalCursor_ = defaultCursor_;
                    }
                    cursor = waitCursor_;
                }
            }
            ++this.startCount_;
        }
        if (component != null) {
            component.setEnabled(false);
        }
        if (cursor != null) {
            this.frame_.setCursor(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWorking(WorkingEvent workingEvent) {
        Component component = null;
        Cursor cursor = null;
        Frame frame = null;
        WorkingCursorAdapter workingCursorAdapter = this;
        synchronized (workingCursorAdapter) {
            --this.startCount_;
            if (this.startCount_ == 0 && this.frame_ != null) {
                cursor = this.originalCursor_;
                frame = this.frame_;
                this.frame_ = null;
            }
            if (this.startCount_ == 0 && this.disabledComponent_ != null) {
                component = this.disabledComponent_;
                this.disabledComponent_ = null;
            }
        }
        if (component != null) {
            component.setEnabled(true);
        }
        if (cursor != null && frame != null) {
            frame.setCursor(cursor);
        }
    }
}

