/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.MessageQueue;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.MessageQueueClearAction;
import com.ibm.as400.vaccess.MessageQueuePropertiesPane;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEvent;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VQueuedMessage;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VMessageQueue
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static String description_ = ResourceLoader.getText("MESSAGE_QUEUE_DESCRIPTION");
    private static Icon icon16_ = ResourceLoader.getIcon("VMessageList16.gif", description_);
    private static Icon icon32_ = ResourceLoader.getIcon("VMessageList32.gif", description_);
    private static String dateColumnHeader_ = ResourceLoader.getText("MESSAGE_DATE");
    private static String fromJobColumnHeader_ = ResourceLoader.getText("MESSAGE_FROM_JOB");
    private static String fromJobNumberColumnHeader_ = ResourceLoader.getText("MESSAGE_FROM_JOB_NUMBER");
    private static String fromProgramColumnHeader_ = ResourceLoader.getText("MESSAGE_FROM_PROGRAM");
    private static String fromUserColumnHeader_ = ResourceLoader.getText("MESSAGE_FROM_USER");
    private static String messageQueueColumnHeader_ = ResourceLoader.getText("MESSAGE_QUEUE");
    private static String nameColumnHeader_ = ResourceLoader.getText("MESSAGE_ID");
    private static String textColumnHeader_ = ResourceLoader.getText("MESSAGE_TEXT");
    private static String typeColumnHeader_ = ResourceLoader.getText("MESSAGE_TYPE");
    private static String severityColumnHeader_ = ResourceLoader.getText("MESSAGE_SEVERITY");
    private VNode parent_ = null;
    private MessageQueue queue_ = null;
    private static TableColumnModel detailsColumnModel_ = null;
    private transient VAction[] actions_;
    transient VObject[] detailsChildren_;
    private transient Enumeration enum_;
    private transient int loaded_;
    private transient VPropertiesPane propertiesPane_;
    transient ErrorEventSupport errorEventSupport_;
    transient VObjectEventSupport objectEventSupport_;
    transient VObjectListener_ objectListener_;
    transient PropertyChangeSupport propertyChangeSupport_;
    transient VetoableChangeSupport vetoableChangeSupport_;
    transient WorkingEventSupport workingEventSupport_;

    public VMessageQueue() {
        this.queue_ = new MessageQueue();
        this.initializeTransient();
    }

    public VMessageQueue(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.queue_ = new MessageQueue(aS400);
        this.initializeTransient();
    }

    public VMessageQueue(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("path");
        }
        this.queue_ = new MessageQueue(aS400, string);
        this.initializeTransient();
    }

    public VMessageQueue(VNode vNode, AS400 aS400, String string) {
        if (vNode == null) {
            throw new NullPointerException("parent");
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("path");
        }
        this.parent_ = vNode;
        this.queue_ = new MessageQueue(aS400, string);
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        return this.actions_;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int n) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public VObject getDetailsChildAt(int n) {
        if (n < 0 || n >= this.detailsChildren_.length) {
            return null;
        }
        this.loadMore(n);
        return this.detailsChildren_[n];
    }

    public synchronized int getDetailsChildCount() {
        return this.detailsChildren_.length;
    }

    public synchronized int getDetailsIndex(VObject vObject) {
        for (int i = 0; i < this.loaded_; ++i) {
            if (this.detailsChildren_[i] != vObject) continue;
            return i;
        }
        return -1;
    }

    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    public Icon getIcon(int n, boolean bl) {
        if (n == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public int getIndex(TreeNode treeNode) {
        return -1;
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public String getPath() {
        return this.queue_.getPath();
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public Object getPropertyValue(Object object) {
        if (object == VObject.NAME_PROPERTY) {
            return this;
        }
        if (object == VObject.DESCRIPTION_PROPERTY) {
            return description_;
        }
        return null;
    }

    public String getSelection() {
        return this.queue_.getSelection();
    }

    public int getSeverity() {
        return this.queue_.getSeverity();
    }

    public AS400 getSystem() {
        return this.queue_.getSystem();
    }

    public String getText() {
        String string = this.queue_.getPath();
        if (string.equals("*CURRENT")) {
            AS400 aS400 = this.queue_.getSystem();
            if (aS400 != null) {
                return aS400.getUserId();
            }
            return "";
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        return qSYSObjectPathName.getObjectName();
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.objectListener_ = new VObjectListener_();
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.queue_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.queue_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.detailsChildren_ = new VObject[0];
        this.enum_ = null;
        this.loaded_ = -1;
        this.actions_ = new VAction[]{new MessageQueueClearAction(this, this.queue_)};
        for (int i = 0; i < this.actions_.length; ++i) {
            this.actions_[i].addErrorListener(this.errorEventSupport_);
            this.actions_[i].addVObjectListener(this.objectEventSupport_);
            this.actions_[i].addVObjectListener(this.objectListener_);
            this.actions_[i].addWorkingListener(this.workingEventSupport_);
        }
        this.propertiesPane_ = new MessageQueuePropertiesPane(this);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectListener_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isSortable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Loading messages from message queue " + this + ".");
        }
        this.workingEventSupport_.fireStartWorking();
        Exception exception = null;
        try {
            this.enum_ = this.queue_.getMessages();
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        VMessageQueue vMessageQueue = this;
        synchronized (vMessageQueue) {
            for (int i = 0; i < this.loaded_; ++i) {
                this.detailsChildren_[i].removeErrorListener(this.errorEventSupport_);
                this.detailsChildren_[i].removeVObjectListener(this.objectEventSupport_);
                this.detailsChildren_[i].removeVObjectListener(this.objectListener_);
                this.detailsChildren_[i].removeWorkingListener(this.workingEventSupport_);
            }
            this.loaded_ = 0;
            this.detailsChildren_ = exception == null ? new VQueuedMessage[this.queue_.getLength()] : new VQueuedMessage[0];
        }
        if (exception != null) {
            this.errorEventSupport_.fireError(exception);
        }
        this.objectEventSupport_.fireObjectChanged(this, true);
        this.workingEventSupport_.fireStopWorking();
    }

    private void loadMore(int n) {
        if (n >= this.loaded_) {
            this.workingEventSupport_.fireStartWorking();
            Exception exception = null;
            for (int i = this.loaded_; i <= n; ++i) {
                QueuedMessage queuedMessage = (QueuedMessage)this.enum_.nextElement();
                this.detailsChildren_[i] = new VQueuedMessage(queuedMessage, this.queue_);
                this.detailsChildren_[i].addErrorListener(this.errorEventSupport_);
                this.detailsChildren_[i].addVObjectListener(this.objectEventSupport_);
                this.detailsChildren_[i].addVObjectListener(this.objectListener_);
                this.detailsChildren_[i].addWorkingListener(this.workingEventSupport_);
            }
            this.loaded_ = n + 1;
            if (exception != null) {
                this.errorEventSupport_.fireError(exception);
            }
            this.workingEventSupport_.fireStopWorking();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("path");
        }
        this.queue_.setPath(string);
    }

    public void setSelection(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("selection");
        }
        this.queue_.setSelection(string);
    }

    public void setSeverity(int n) throws PropertyVetoException {
        this.queue_.setSeverity(n);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.queue_.setSystem(aS400);
    }

    public void sortDetailsChildren(Object[] objectArray, boolean[] blArray) {
    }

    public String toString() {
        return this.getText();
    }

    static {
        detailsColumnModel_ = new DefaultTableColumnModel();
        int n = 0;
        VTableColumn vTableColumn = new VTableColumn(n++, VObject.NAME_PROPERTY);
        vTableColumn.setCellRenderer(new VObjectCellRenderer());
        vTableColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn.setHeaderValue(nameColumnHeader_);
        vTableColumn.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTableColumn);
        VTableColumn vTableColumn2 = new VTableColumn(n++, VQueuedMessage.TEXT_PROPERTY);
        vTableColumn2.setCellRenderer(new VObjectCellRenderer());
        vTableColumn2.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn2.setHeaderValue(textColumnHeader_);
        vTableColumn2.setPreferredCharWidth(40);
        detailsColumnModel_.addColumn(vTableColumn2);
        VTableColumn vTableColumn3 = new VTableColumn(n++, VQueuedMessage.SEVERITY_PROPERTY);
        vTableColumn3.setCellRenderer(new VObjectCellRenderer(4));
        vTableColumn3.setHeaderRenderer(new VObjectHeaderRenderer(4));
        vTableColumn3.setHeaderValue(severityColumnHeader_);
        vTableColumn3.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTableColumn3);
        VTableColumn vTableColumn4 = new VTableColumn(n++, VQueuedMessage.TYPE_PROPERTY);
        vTableColumn4.setCellRenderer(new VObjectCellRenderer());
        vTableColumn4.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn4.setHeaderValue(typeColumnHeader_);
        vTableColumn4.setPreferredCharWidth(20);
        detailsColumnModel_.addColumn(vTableColumn4);
        VTableColumn vTableColumn5 = new VTableColumn(n++, VQueuedMessage.DATE_PROPERTY);
        vTableColumn5.setCellRenderer(new VObjectCellRenderer());
        vTableColumn5.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn5.setHeaderValue(dateColumnHeader_);
        vTableColumn5.setPreferredCharWidth(20);
        detailsColumnModel_.addColumn(vTableColumn5);
        VTableColumn vTableColumn6 = new VTableColumn(n++, VQueuedMessage.FROM_JOB_PROPERTY);
        vTableColumn6.setCellRenderer(new VObjectCellRenderer());
        vTableColumn6.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn6.setHeaderValue(fromJobColumnHeader_);
        vTableColumn6.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTableColumn6);
        VTableColumn vTableColumn7 = new VTableColumn(n++, VQueuedMessage.FROM_USER_PROPERTY);
        vTableColumn7.setCellRenderer(new VObjectCellRenderer());
        vTableColumn7.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn7.setHeaderValue(fromUserColumnHeader_);
        vTableColumn7.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTableColumn7);
        VTableColumn vTableColumn8 = new VTableColumn(n++, VQueuedMessage.FROM_JOB_NUMBER_PROPERTY);
        vTableColumn8.setCellRenderer(new VObjectCellRenderer());
        vTableColumn8.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn8.setHeaderValue(fromJobNumberColumnHeader_);
        vTableColumn8.setPreferredCharWidth(20);
        detailsColumnModel_.addColumn(vTableColumn8);
        VTableColumn vTableColumn9 = new VTableColumn(n++, VQueuedMessage.FROM_PROGRAM_PROPERTY);
        vTableColumn9.setCellRenderer(new VObjectCellRenderer());
        vTableColumn9.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn9.setHeaderValue(fromProgramColumnHeader_);
        vTableColumn9.setPreferredCharWidth(20);
        detailsColumnModel_.addColumn(vTableColumn9);
        VTableColumn vTableColumn10 = new VTableColumn(n++, VQueuedMessage.MESSAGE_QUEUE_PROPERTY);
        vTableColumn10.setCellRenderer(new VObjectCellRenderer());
        vTableColumn10.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn10.setHeaderValue(messageQueueColumnHeader_);
        vTableColumn10.setPreferredCharWidth(20);
        detailsColumnModel_.addColumn(vTableColumn10);
    }

    private class VObjectListener_
    implements VObjectListener,
    Serializable {
        private VObjectListener_() {
        }

        public void objectChanged(VObjectEvent vObjectEvent) {
        }

        public void objectCreated(VObjectEvent vObjectEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void objectDeleted(VObjectEvent vObjectEvent) {
            VObject vObject = vObjectEvent.getObject();
            VMessageQueue.this.objectEventSupport_.objectDeleted(vObjectEvent);
            VMessageQueue vMessageQueue = VMessageQueue.this;
            synchronized (vMessageQueue) {
                int n = VMessageQueue.this.getDetailsIndex(vObject);
                if (n >= 0) {
                    VObject[] vObjectArray = VMessageQueue.this.detailsChildren_;
                    int n2 = VMessageQueue.this.detailsChildren_.length;
                    VMessageQueue.this.detailsChildren_ = new VObject[n2 - 1];
                    System.arraycopy(vObjectArray, 0, VMessageQueue.this.detailsChildren_, 0, n);
                    System.arraycopy(vObjectArray, n + 1, VMessageQueue.this.detailsChildren_, n, n2 - n - 1);
                    --VMessageQueue.this.loaded_;
                }
            }
            vObject.removeErrorListener(VMessageQueue.this.errorEventSupport_);
            vObject.removeVObjectListener(VMessageQueue.this.objectEventSupport_);
            vObject.removeVObjectListener(VMessageQueue.this.objectListener_);
            vObject.removeWorkingListener(VMessageQueue.this.workingEventSupport_);
        }
    }
}

