/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ActionCompletedEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import com.ibm.as400.vaccess.WorkingEvent;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import javax.swing.Icon;
import javax.swing.JMenuItem;

public class SQLStatementMenuItem
extends JMenuItem
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    transient ActionCompletedEventSupport actionListeners_ = new ActionCompletedEventSupport(this);
    transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    transient WorkingEventSupport workingListeners_ = new WorkingEventSupport(this);
    transient WorkingCursorAdapter worker_ = new WorkingCursorAdapter(this);
    SQLConnection connection_ = null;
    String sql_ = null;
    transient SQLWarning warnings_ = null;
    transient Statement statement_ = null;

    public SQLStatementMenuItem() {
        this.addActionListener(new MenuListener_());
    }

    public SQLStatementMenuItem(Icon icon) {
        super(icon);
        this.addActionListener(new MenuListener_());
    }

    public SQLStatementMenuItem(String string) {
        super(string);
        this.addActionListener(new MenuListener_());
    }

    public SQLStatementMenuItem(String string, Icon icon) {
        super(string, icon);
        this.addActionListener(new MenuListener_());
    }

    public SQLStatementMenuItem(String string, Icon icon, SQLConnection sQLConnection, String string2) {
        super(string, icon);
        if (sQLConnection == null) {
            throw new NullPointerException("connection");
        }
        this.connection_ = sQLConnection;
        if (string2 == null) {
            throw new NullPointerException("SQLStatement");
        }
        this.sql_ = string2;
        this.addActionListener(new MenuListener_());
    }

    public void addActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        this.actionListeners_.addActionCompletedListener(actionCompletedListener);
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorListeners_.addErrorListener(errorListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingListeners_.addWorkingListener(workingListener);
    }

    public SQLConnection getConnection() {
        return this.connection_;
    }

    public void getMoreResults() {
        if (this.statement_ != null) {
            this.workingListeners_.fireStartWorking();
            try {
                this.statement_.getMoreResults();
            }
            catch (SQLException sQLException) {
                this.errorListeners_.fireError(sQLException);
            }
            this.workingListeners_.fireStopWorking();
        }
    }

    public ResultSet getResultSet() {
        if (this.statement_ == null) {
            return null;
        }
        this.workingListeners_.fireStartWorking();
        ResultSet resultSet = null;
        try {
            resultSet = this.statement_.getResultSet();
        }
        catch (SQLException sQLException) {
            this.errorListeners_.fireError(sQLException);
        }
        this.workingListeners_.fireStopWorking();
        return resultSet;
    }

    public String getSQLStatement() {
        if (this.sql_ == null) {
            return "";
        }
        return this.sql_;
    }

    public int getUpdateCount() {
        if (this.statement_ == null) {
            return -1;
        }
        try {
            return this.statement_.getUpdateCount();
        }
        catch (SQLException sQLException) {
            this.errorListeners_.fireError(sQLException);
            return 0;
        }
    }

    public SQLWarning getWarnings() {
        if (this.statement_ == null) {
            return null;
        }
        SQLWarning sQLWarning = null;
        try {
            sQLWarning = this.statement_.getWarnings();
        }
        catch (SQLException sQLException) {
            this.errorListeners_.fireError(sQLException);
        }
        if (this.warnings_ != null) {
            SQLWarning sQLWarning2;
            if (sQLWarning == null) {
                return this.warnings_;
            }
            SQLWarning sQLWarning3 = this.warnings_;
            while ((sQLWarning2 = sQLWarning3.getNextWarning()) != null) {
                sQLWarning3 = sQLWarning2;
            }
            sQLWarning3.setNextWarning(sQLWarning);
            return this.warnings_;
        }
        return sQLWarning;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.actionListeners_ = new ActionCompletedEventSupport(this);
        this.errorListeners_ = new ErrorEventSupport(this);
        this.workingListeners_ = new WorkingEventSupport(this);
        this.worker_ = new WorkingCursorAdapter(this);
        this.warnings_ = null;
        this.statement_ = null;
        this.addActionListener(new MenuListener_());
    }

    public void removeActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        this.actionListeners_.removeActionCompletedListener(actionCompletedListener);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorListeners_.removeErrorListener(errorListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingListeners_.removeWorkingListener(workingListener);
    }

    public void setConnection(SQLConnection sQLConnection) throws PropertyVetoException {
        if (sQLConnection == null) {
            throw new NullPointerException("connection");
        }
        this.fireVetoableChange("connection", this.connection_, sQLConnection);
        SQLConnection sQLConnection2 = this.connection_;
        this.connection_ = sQLConnection;
        if (sQLConnection2 != sQLConnection) {
            if (this.statement_ != null) {
                try {
                    this.statement_.close();
                }
                catch (SQLException sQLException) {
                    this.errorListeners_.fireError(sQLException);
                }
            }
            this.statement_ = null;
            this.warnings_ = null;
        }
        this.firePropertyChange("connection", sQLConnection2, this.connection_);
    }

    public void setSQLStatement(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("SQLStatement");
        }
        String string2 = this.getSQLStatement();
        this.fireVetoableChange("SQLStatement", string2, string);
        this.sql_ = string;
        this.firePropertyChange("SQLStatement", string2, this.sql_);
    }

    private class MenuListener_
    implements ActionListener {
        private MenuListener_() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SQLStatementMenuItem.this.connection_ == null) {
                IllegalStateException illegalStateException = new IllegalStateException("connection");
                SQLStatementMenuItem.this.errorListeners_.fireError(illegalStateException);
                return;
            }
            if (SQLStatementMenuItem.this.sql_ == null) {
                IllegalStateException illegalStateException = new IllegalStateException("SQLStatement");
                SQLStatementMenuItem.this.errorListeners_.fireError(illegalStateException);
                return;
            }
            Trace.log(3, "Running menu, sql is:  " + SQLStatementMenuItem.this.sql_);
            SQLStatementMenuItem.this.workingListeners_.fireStartWorking();
            SQLStatementMenuItem.this.worker_.startWorking(new WorkingEvent(this));
            if (SQLStatementMenuItem.this.statement_ == null) {
                Connection connection;
                try {
                    connection = SQLStatementMenuItem.this.connection_.getConnection();
                    SQLStatementMenuItem.this.statement_ = connection.createStatement();
                }
                catch (SQLException sQLException) {
                    SQLStatementMenuItem.this.errorListeners_.fireError(sQLException);
                    SQLStatementMenuItem.this.worker_.stopWorking(new WorkingEvent(this));
                    SQLStatementMenuItem.this.workingListeners_.fireStopWorking();
                    return;
                }
                try {
                    SQLStatementMenuItem.this.warnings_ = connection.getWarnings();
                }
                catch (SQLException sQLException) {
                    SQLStatementMenuItem.this.errorListeners_.fireError(sQLException);
                }
            } else {
                SQLStatementMenuItem.this.warnings_ = null;
                try {
                    SQLStatementMenuItem.this.statement_.clearWarnings();
                }
                catch (SQLException sQLException) {
                    SQLStatementMenuItem.this.errorListeners_.fireError(sQLException);
                }
            }
            try {
                SQLStatementMenuItem.this.statement_.execute(SQLStatementMenuItem.this.sql_);
            }
            catch (SQLException sQLException) {
                SQLStatementMenuItem.this.errorListeners_.fireError(sQLException);
            }
            SQLStatementMenuItem.this.actionListeners_.fireActionCompleted();
            SQLStatementMenuItem.this.worker_.stopWorking(new WorkingEvent(this));
            SQLStatementMenuItem.this.workingListeners_.fireStopWorking();
        }
    }
}

