/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SQLConnection
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private transient String password_ = null;
    private transient String uid_ = null;
    private String uid2_ = null;
    private Properties properties_ = null;
    private transient Properties properties2_ = null;
    private transient String url_ = null;
    private String url2_ = null;
    private transient Connection connection_ = null;
    private transient PropertyChangeSupport changeListeners_ = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport vetoListeners_ = new VetoableChangeSupport(this);
    private transient WorkingEventSupport workingListeners_ = new WorkingEventSupport(this);

    public SQLConnection() {
    }

    public SQLConnection(String string) {
        if (string == null) {
            throw new NullPointerException("URL");
        }
        this.url_ = this.url2_ = string;
    }

    public SQLConnection(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("URL");
        }
        this.url_ = this.url2_ = string;
        if (string2 == null) {
            throw new NullPointerException("userName");
        }
        this.uid_ = this.uid2_ = string2;
    }

    public SQLConnection(String string, String string2, String string3) {
        if (string == null) {
            throw new NullPointerException("URL");
        }
        this.url_ = this.url2_ = string;
        if (string2 == null) {
            throw new NullPointerException("userName");
        }
        this.uid_ = this.uid2_ = string2;
        if (string3 == null) {
            throw new NullPointerException("password");
        }
        this.password_ = string3;
    }

    public SQLConnection(String string, Properties properties) {
        if (string == null) {
            throw new NullPointerException("URL");
        }
        this.url_ = this.url2_ = string;
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        this.properties2_ = properties;
        this.properties_ = new Properties();
        Enumeration<?> enumeration = this.properties2_.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            ((Hashtable)this.properties_).put(string2, this.properties2_.getProperty(string2));
        }
        ((Hashtable)this.properties_).remove("password");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListeners_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoListeners_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingListeners_.addWorkingListener(workingListener);
    }

    public void close() throws SQLException {
        if (this.connection_ != null) {
            this.connection_.close();
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.connection_ == null) {
            if (this.url2_ == null) {
                throw new IllegalStateException("URL");
            }
            this.workingListeners_.fireStartWorking();
            try {
                if (this.uid2_ != null) {
                    Trace.log(3, "Getting SQL Connection with uid, pwd.");
                    this.connection_ = DriverManager.getConnection(this.url2_, this.uid2_, this.password_);
                } else if (this.properties2_ != null) {
                    Trace.log(3, "Getting SQL Connection with properties.");
                    this.connection_ = DriverManager.getConnection(this.url2_, this.properties2_);
                } else {
                    Trace.log(3, "Getting SQL Connection with url only.");
                    this.connection_ = DriverManager.getConnection(this.url2_);
                }
                Trace.log(3, "Got SQL Connection.");
            }
            catch (SQLException sQLException) {
                this.workingListeners_.fireStopWorking();
                Trace.log(2, "Error getting SQL Connection: " + sQLException.getMessage());
                throw sQLException;
            }
            this.uid_ = null;
            this.url_ = null;
            try {
                DatabaseMetaData databaseMetaData = this.connection_.getMetaData();
                this.uid_ = databaseMetaData.getUserName();
                this.url_ = databaseMetaData.getURL();
            }
            catch (SQLException sQLException) {
                Trace.log(4, "Error getting SQL meta data: " + sQLException.getMessage());
            }
            this.workingListeners_.fireStopWorking();
        }
        return this.connection_;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public String getURL() {
        if (this.url_ == null) {
            return "";
        }
        return this.url_;
    }

    public String getUserName() {
        if (this.uid_ == null) {
            return "";
        }
        return this.uid_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.changeListeners_ = new PropertyChangeSupport(this);
        this.vetoListeners_ = new VetoableChangeSupport(this);
        this.workingListeners_ = new WorkingEventSupport(this);
        this.password_ = null;
        this.connection_ = null;
        this.url_ = this.url2_;
        this.uid_ = this.uid2_;
        this.properties2_ = this.properties_;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListeners_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoListeners_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingListeners_.removeWorkingListener(workingListener);
    }

    public void setPassword(String string) throws PropertyVetoException {
        if (this.connection_ != null) {
            throw new IllegalStateException();
        }
        if (string == null) {
            throw new NullPointerException("password");
        }
        if (this.password_ != null && this.password_.equals(string)) {
            return;
        }
        this.vetoListeners_.fireVetoableChange("password", null, "");
        this.password_ = string;
        this.changeListeners_.firePropertyChange("password", null, "");
    }

    public void setProperties(Properties properties) throws PropertyVetoException {
        if (this.connection_ != null) {
            throw new IllegalStateException();
        }
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        Properties properties2 = new Properties();
        Object object = properties.propertyNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            ((Hashtable)properties2).put(string, properties.getProperty(string));
        }
        ((Hashtable)properties2).remove("password");
        this.vetoListeners_.fireVetoableChange("properties", this.properties_, properties2);
        object = this.properties_;
        this.properties2_ = properties;
        this.properties_ = properties2;
        this.changeListeners_.firePropertyChange("properties", object, this.properties_);
    }

    public void setURL(String string) throws PropertyVetoException {
        if (this.connection_ != null) {
            throw new IllegalStateException();
        }
        if (string == null) {
            throw new NullPointerException("URL");
        }
        String string2 = this.getURL();
        this.vetoListeners_.fireVetoableChange("URL", string2, string);
        this.url_ = this.url2_ = string;
        this.changeListeners_.firePropertyChange("URL", string2, this.url_);
    }

    public void setUserName(String string) throws PropertyVetoException {
        if (this.connection_ != null) {
            throw new IllegalStateException();
        }
        if (string == null) {
            throw new NullPointerException("userName");
        }
        String string2 = this.getUserName();
        this.vetoListeners_.fireVetoableChange("userName", string2, string);
        this.uid_ = this.uid2_ = string;
        this.changeListeners_.firePropertyChange("userName", string2, this.uid_);
    }
}

