/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Permission;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.QSYSPermission;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import com.ibm.as400.vaccess.PermissionMainPanel;
import com.ibm.as400.vaccess.PermissionNameCellObject;
import com.ibm.as400.vaccess.ResourceLoader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

class PermissionTableModelQSYS
extends DefaultTableModel {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private Permission permission_;
    private Vector userPermissions_;
    private boolean isAuthorizationList_;
    private JTable table_;
    private PermissionMainPanel mainPanel_;
    private int selectedColumn_ = 1;
    private String[] columnNames_;
    private static String addUserExceptionDialogMessage_;
    private static String addUserExceptionDialogTitle_;

    public PermissionTableModelQSYS(PermissionMainPanel permissionMainPanel, Permission permission) {
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(permission.getObjectPath());
        this.isAuthorizationList_ = qSYSObjectPathName.getObjectType().toUpperCase().equals("AUTL");
        this.mainPanel_ = permissionMainPanel;
        this.permission_ = permission;
        this.initializeTable();
        Enumeration enumeration = this.permission_.getUserPermissions();
        this.userPermissions_ = new Vector();
        while (enumeration.hasMoreElements()) {
            this.userPermissions_.addElement(enumeration.nextElement());
        }
    }

    public void addRow(String string) {
        try {
            this.permission_.addAuthorizedUser(string);
            this.mainPanel_.getApplyButton().setEnabled(true);
            this.table_.clearSelection();
            Enumeration enumeration = this.permission_.getUserPermissions();
            this.userPermissions_ = new Vector();
            while (enumeration.hasMoreElements()) {
                this.userPermissions_.addElement(enumeration.nextElement());
            }
            int n = this.userPermissions_.size() - 1;
            this.fireTableRowsInserted(n, n);
        }
        catch (ExtendedIllegalArgumentException extendedIllegalArgumentException) {
            Trace.log(2, "Error in addRow : " + extendedIllegalArgumentException);
            this.mainPanel_.fireError(extendedIllegalArgumentException);
        }
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public int getColumnCount() {
        return this.columnNames_.length;
    }

    public String getColumnName(int n) {
        return this.columnNames_[n];
    }

    public int getRowCount() {
        if (this.userPermissions_ == null) {
            return 0;
        }
        return this.userPermissions_.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.userPermissions_.size()) {
            return null;
        }
        if (this.selectedColumn_ > 0) {
            this.table_.clearSelection();
        } else if (this.table_.getSelectedRow() >= 0 && this.table_.getSelectedRowCount() > 0) {
            this.mainPanel_.getRemoveButton().setEnabled(true);
        }
        QSYSPermission qSYSPermission = (QSYSPermission)this.userPermissions_.elementAt(n);
        String string = qSYSPermission.getObjectAuthority().toUpperCase();
        Object object = null;
        switch (n2) {
            case 0: {
                object = new PermissionNameCellObject(qSYSPermission.getUserID(), qSYSPermission.getGroupIndicator());
                break;
            }
            case 1: {
                object = new Boolean(string.equals("*USE"));
                break;
            }
            case 2: {
                object = new Boolean(string.equals("*CHANGE"));
                break;
            }
            case 3: {
                object = new Boolean(string.equals("*ALL"));
                break;
            }
            case 4: {
                object = new Boolean(string.equals("*EXCLUDE"));
                break;
            }
            case 5: {
                if (this.isAuthorizationList_) {
                    object = new Boolean(qSYSPermission.isAuthorizationListManagement());
                    break;
                }
                object = new Boolean(qSYSPermission.isFromAuthorizationList());
                break;
            }
            case 6: {
                object = new Boolean(qSYSPermission.isOperational());
                break;
            }
            case 7: {
                object = new Boolean(qSYSPermission.isManagement());
                break;
            }
            case 8: {
                object = new Boolean(qSYSPermission.isExistence());
                break;
            }
            case 9: {
                object = new Boolean(qSYSPermission.isAlter());
                break;
            }
            case 10: {
                object = new Boolean(qSYSPermission.isReference());
                break;
            }
            case 11: {
                object = new Boolean(qSYSPermission.isRead());
                break;
            }
            case 12: {
                object = new Boolean(qSYSPermission.isAdd());
                break;
            }
            case 13: {
                object = new Boolean(qSYSPermission.isUpdate());
                break;
            }
            case 14: {
                object = new Boolean(qSYSPermission.isDelete());
                break;
            }
            case 15: {
                object = new Boolean(qSYSPermission.isExecute());
            }
        }
        return object;
    }

    private void initializeTable() {
        this.columnNames_ = new String[16];
        this.columnNames_[0] = ResourceLoader.getText("OBJECT_USER_NAME");
        this.columnNames_[1] = ResourceLoader.getText("OBJECT_AUTHORITY_USE");
        this.columnNames_[2] = ResourceLoader.getText("OBJECT_AUTHORITY_CHANGE");
        this.columnNames_[3] = ResourceLoader.getText("OBJECT_AUTHORITY_ALL");
        this.columnNames_[4] = ResourceLoader.getText("OBJECT_AUTHORITY_EXCLUDE");
        if (this.isAuthorizationList_) {
            this.mainPanel_.getListField().setEnabled(false);
            this.columnNames_[5] = ResourceLoader.getText("OBJECT_LIST_MANAGEMENT");
        } else {
            this.columnNames_[5] = ResourceLoader.getText("OBJECT_FROM_AUTHORIZATION_LIST");
        }
        this.columnNames_[6] = ResourceLoader.getText("OBJECT_AUTHORITY_OPERATION");
        this.columnNames_[7] = ResourceLoader.getText("OBJECT_AUTHORITY_MANAGEMENT");
        this.columnNames_[8] = ResourceLoader.getText("OBJECT_AUTHORITY_EXISTENCE");
        this.columnNames_[9] = ResourceLoader.getText("OBJECT_AUTHORITY_ALTER");
        this.columnNames_[10] = ResourceLoader.getText("OBJECT_AUTHORITY_REFERENCE");
        this.columnNames_[11] = ResourceLoader.getText("OBJECT_AUTHORITY_READ");
        this.columnNames_[12] = ResourceLoader.getText("OBJECT_AUTHORITY_ADD");
        this.columnNames_[13] = ResourceLoader.getText("OBJECT_AUTHORITY_UPDATE");
        this.columnNames_[14] = ResourceLoader.getText("OBJECT_AUTHORITY_DELETE");
        this.columnNames_[15] = ResourceLoader.getText("OBJECT_AUTHORITY_EXECUTE");
        addUserExceptionDialogMessage_ = ResourceLoader.getText("OBJECT_ADD_USER_EXCEPTION_DIALOG_MESSAGE");
        addUserExceptionDialogTitle_ = ResourceLoader.getText("OBJECT_ADD_USER_EXCEPTION_DIALOG_TITLE");
    }

    public boolean isCellEditable(int n, int n2) {
        this.selectedColumn_ = n2;
        switch (n2) {
            case 0: {
                return false;
            }
            case 5: {
                UserPermission userPermission = (UserPermission)this.userPermissions_.elementAt(n);
                if (!(this.isAuthorizationList_ ? userPermission.getUserID().toUpperCase().equals("*PUBLIC") : this.mainPanel_.getAutList().toUpperCase().equals("*NONE") || !userPermission.getUserID().toUpperCase().equals("*PUBLIC"))) break;
                return false;
            }
        }
        return true;
    }

    public void removeRow(int n) {
        this.table_.clearSelection();
        QSYSPermission qSYSPermission = (QSYSPermission)this.userPermissions_.elementAt(n);
        this.permission_.removeAuthorizedUser(qSYSPermission.getUserID());
        Enumeration enumeration = this.permission_.getUserPermissions();
        this.userPermissions_ = new Vector();
        while (enumeration.hasMoreElements()) {
            this.userPermissions_.addElement(enumeration.nextElement());
        }
        this.fireTableRowsDeleted(n, n);
    }

    void resetPublicAuthorizationList() {
        UserPermission userPermission = this.permission_.getUserPermission("*PUBLIC");
        int n = this.userPermissions_.indexOf(userPermission);
        if (n >= 0) {
            this.setValueAt(new Boolean(false), n, 5);
        }
    }

    public void setTableInstance(JTable jTable) {
        this.table_ = jTable;
    }

    public void setValueAt(Object object, int n, int n2) {
        this.mainPanel_.getRemoveButton().setEnabled(false);
        QSYSPermission qSYSPermission = (QSYSPermission)this.userPermissions_.elementAt(n);
        switch (n2) {
            case 1: {
                boolean bl = (Boolean)object;
                if (!bl) break;
                qSYSPermission.setObjectAuthority("*Use");
                break;
            }
            case 2: {
                boolean bl = (Boolean)object;
                if (!bl) break;
                qSYSPermission.setObjectAuthority("*Change");
                break;
            }
            case 3: {
                boolean bl = (Boolean)object;
                if (!bl) break;
                qSYSPermission.setObjectAuthority("*All");
                break;
            }
            case 4: {
                boolean bl = (Boolean)object;
                if (!bl) break;
                qSYSPermission.setObjectAuthority("*Exclude");
                qSYSPermission.setAuthorizationListManagement(false);
                break;
            }
            case 5: {
                boolean bl = (Boolean)object;
                if (this.isAuthorizationList_) {
                    qSYSPermission.setAuthorizationListManagement(bl);
                    break;
                }
                qSYSPermission.setFromAuthorizationList(bl);
                break;
            }
            case 6: {
                boolean bl = (Boolean)object;
                qSYSPermission.setOperational(bl);
                break;
            }
            case 7: {
                boolean bl = (Boolean)object;
                qSYSPermission.setManagement(bl);
                break;
            }
            case 8: {
                boolean bl = (Boolean)object;
                qSYSPermission.setExistence(bl);
                break;
            }
            case 9: {
                boolean bl = (Boolean)object;
                qSYSPermission.setAlter(bl);
                break;
            }
            case 10: {
                boolean bl = (Boolean)object;
                qSYSPermission.setReference(bl);
                break;
            }
            case 11: {
                boolean bl = (Boolean)object;
                qSYSPermission.setRead(bl);
                break;
            }
            case 12: {
                boolean bl = (Boolean)object;
                qSYSPermission.setAdd(bl);
                break;
            }
            case 13: {
                boolean bl = (Boolean)object;
                qSYSPermission.setUpdate(bl);
                break;
            }
            case 14: {
                boolean bl = (Boolean)object;
                qSYSPermission.setDelete(bl);
                break;
            }
            case 15: {
                boolean bl = (Boolean)object;
                qSYSPermission.setExecute(bl);
            }
        }
        this.fireTableRowsUpdated(n, n);
        this.mainPanel_.getApplyButton().setEnabled(true);
    }
}

