/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.DataQueueEntry;
import com.ibm.as400.access.DataQueueListener;
import com.ibm.as400.vaccess.DataQueueEventSupport;
import com.ibm.as400.vaccess.DocumentEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.UndoableEditEventSupport;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;

public class DataQueueDocument
implements Document,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private DataQueue dataQueue_ = null;
    private transient PlainDocument document_;
    private transient DocumentEventSupport documentEventSupport_;
    private transient DataQueueEventSupport dataQueueEventSupport_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient UndoableEditEventSupport undoableEditEventSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public DataQueueDocument() {
        this.dataQueue_ = new DataQueue();
        this.initializeTransient();
    }

    public DataQueueDocument(AS400 aS400, String string) {
        this.dataQueue_ = new DataQueue(aS400, string);
        this.initializeTransient();
    }

    public void addDataQueueListener(DataQueueListener dataQueueListener) {
        this.dataQueueEventSupport_.addDataQueueListener(dataQueueListener);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.documentEventSupport_.addDocumentListener(documentListener);
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.undoableEditEventSupport_.addUndoableEditListener(undoableEditListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public synchronized Position createPosition(int n) throws BadLocationException {
        return this.document_.createPosition(n);
    }

    public synchronized Element getDefaultRootElement() {
        return this.document_.getDefaultRootElement();
    }

    public synchronized Position getEndPosition() {
        return this.document_.getEndPosition();
    }

    public synchronized int getLength() {
        return this.document_.getLength();
    }

    public String getPath() {
        return this.dataQueue_.getPath();
    }

    public synchronized Object getProperty(Object object) {
        return this.document_.getProperty(object);
    }

    public synchronized Element[] getRootElements() {
        return this.document_.getRootElements();
    }

    public synchronized Position getStartPosition() {
        return this.document_.getStartPosition();
    }

    public AS400 getSystem() {
        return this.dataQueue_.getSystem();
    }

    public synchronized String getText(int n, int n2) throws BadLocationException {
        return this.document_.getText(n, n2);
    }

    public synchronized void getText(int n, int n2, Segment segment) throws BadLocationException {
        this.document_.getText(n, n2, segment);
    }

    private void initializeTransient() {
        this.document_ = new PlainDocument();
        this.dataQueueEventSupport_ = new DataQueueEventSupport(this);
        this.documentEventSupport_ = new DocumentEventSupport(this);
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.undoableEditEventSupport_ = new UndoableEditEventSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.document_.addDocumentListener(this.documentEventSupport_);
        this.document_.addUndoableEditListener(this.undoableEditEventSupport_);
        this.dataQueue_.addDataQueueListener(this.dataQueueEventSupport_);
    }

    public synchronized void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        this.document_.insertString(n, string, attributeSet);
    }

    public void peek() {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.document_.remove(0, this.document_.getLength());
            DataQueueEntry dataQueueEntry = this.dataQueue_.peek();
            String string = dataQueueEntry != null ? dataQueueEntry.getString() : "";
            this.document_.insertString(0, string, null);
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    public void peek(int n) {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.document_.remove(0, this.document_.getLength());
            DataQueueEntry dataQueueEntry = this.dataQueue_.peek(n);
            String string = dataQueueEntry != null ? dataQueueEntry.getString() : "";
            this.document_.insertString(0, string, null);
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    public synchronized void putProperty(Object object, Object object2) {
        this.document_.putProperty(object, object2);
    }

    public void read() {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.document_.remove(0, this.document_.getLength());
            DataQueueEntry dataQueueEntry = this.dataQueue_.read();
            String string = dataQueueEntry != null ? dataQueueEntry.getString() : "";
            this.document_.insertString(0, string, null);
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    public void read(int n) {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.document_.remove(0, this.document_.getLength());
            DataQueueEntry dataQueueEntry = this.dataQueue_.read(n);
            String string = dataQueueEntry != null ? dataQueueEntry.getString() : "";
            this.document_.insertString(0, string, null);
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public synchronized void remove(int n, int n2) throws BadLocationException {
        this.document_.remove(n, n2);
    }

    public void removeDataQueueListener(DataQueueListener dataQueueListener) {
        this.dataQueueEventSupport_.removeDataQueueListener(dataQueueListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.documentEventSupport_.removeDocumentListener(documentListener);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.undoableEditEventSupport_.removeUndoableEditListener(undoableEditListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void render(Runnable runnable) {
        this.document_.render(runnable);
    }

    public void setPath(String string) throws PropertyVetoException {
        String string2 = this.dataQueue_.getPath();
        String string3 = string;
        this.vetoableChangeSupport_.fireVetoableChange("path", string2, string3);
        this.dataQueue_.setPath(string3);
        this.propertyChangeSupport_.firePropertyChange("path", string2, string3);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        AS400 aS4002 = this.dataQueue_.getSystem();
        AS400 aS4003 = aS400;
        this.vetoableChangeSupport_.fireVetoableChange("system", aS4002, aS4003);
        this.dataQueue_.setSystem(aS400);
        this.propertyChangeSupport_.firePropertyChange("system", aS4002, aS4003);
    }

    public void write() {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.dataQueue_.write(this.document_.getText(0, this.document_.getLength()));
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        this.workingEventSupport_.fireStopWorking();
    }
}

