/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDWriter;
import com.ibm.as400.access.NPCPSelWrtJ;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.NPSystem;
import com.ibm.as400.access.OutputQueueImpl;
import com.ibm.as400.access.OutputQueueImplRemote;
import com.ibm.as400.access.PrintObjectImpl;
import com.ibm.as400.access.PrintObjectImplRemote;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.PrinterImplRemote;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.WriterJobImpl;
import java.io.IOException;

class WriterJobImplRemote
extends PrintObjectImplRemote
implements WriterJobImpl {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final NPCPAttributeIDList attrsToRetrieve_ = new NPCPAttributeIDList();
    private static boolean fAttrIDsToRtvBuilt_ = false;

    WriterJobImplRemote() {
    }

    private synchronized void buildAttrIDsToRtv() {
        if (!fAttrIDsToRtvBuilt_) {
            fAttrIDsToRtvBuilt_ = true;
            attrsToRetrieve_.addAttrID(121);
            attrsToRetrieve_.addAttrID(122);
            attrsToRetrieve_.addAttrID(123);
            attrsToRetrieve_.addAttrID(124);
        }
    }

    public void end(String string) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPDataStream nPDataStream = new NPDataStream(2);
        NPDataStream nPDataStream2 = new NPDataStream(2);
        NPSystem nPSystem = NPSystem.getSystem(this.getSystem());
        NPCPAttribute nPCPAttribute = new NPCPAttribute();
        nPDataStream.setAction(9);
        nPDataStream.addCodePoint(this.getIDCodePoint());
        if (string != null) {
            NPCPAttribute nPCPAttribute2 = new NPCPAttribute();
            nPCPAttribute2.setAttrValue(144, string);
            nPDataStream.addCodePoint(nPCPAttribute2);
        }
        nPDataStream2.addCodePoint(nPCPAttribute);
        nPSystem.makeRequest(nPDataStream, nPDataStream2);
    }

    NPCPAttributeIDList getAttrIDsToRetrieve() {
        if (!fAttrIDsToRtvBuilt_) {
            this.buildAttrIDsToRtv();
        }
        return attrsToRetrieve_;
    }

    NPCPAttributeIDList getAttrIDsToRetrieve(int n) {
        if (!fAttrIDsToRtvBuilt_) {
            attrsToRetrieve_.addAttrID(n);
        }
        return attrsToRetrieve_;
    }

    public String getName() {
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return "";
        }
        return nPCPID.getStringValue(121);
    }

    public NPCPIDWriter start(AS400Impl aS400Impl, PrintObjectImpl printObjectImpl, PrintParameterList printParameterList, OutputQueueImpl outputQueueImpl) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        NPDataStream nPDataStream = new NPDataStream(2);
        NPDataStream nPDataStream2 = new NPDataStream(2);
        NPCPAttribute nPCPAttribute = new NPCPAttribute();
        NPCPIDWriter nPCPIDWriter = new NPCPIDWriter();
        NPSystem nPSystem = NPSystem.getSystem((AS400ImplRemote)aS400Impl);
        nPDataStream.setAction(8);
        nPDataStream.addCodePoint(((PrinterImplRemote)printObjectImpl).getIDCodePoint());
        if (outputQueueImpl != null) {
            nPDataStream.addCodePoint(((OutputQueueImplRemote)outputQueueImpl).getIDCodePoint());
        }
        if (printParameterList != null) {
            nPDataStream.addCodePoint(printParameterList.getAttrCodePoint());
        }
        nPDataStream2.addCodePoint(nPCPAttribute);
        nPDataStream2.addCodePoint(nPCPIDWriter);
        int n = nPSystem.makeRequest(nPDataStream, nPDataStream2);
        if (n != 0) {
            Trace.log(2, "Bad RC starting writer from server.  RC = " + n);
            throw new ErrorCompletingRequestException(1, " Network Print Server RC = " + n);
        }
        return nPCPIDWriter;
    }

    void updateAttrs(NPCPAttributeIDList nPCPAttributeIDList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPDataStream nPDataStream = new NPDataStream(2);
        NPDataStream nPDataStream2 = new NPDataStream(2);
        NPSystem nPSystem = NPSystem.getSystem(this.getSystem());
        NPCPSelWrtJ nPCPSelWrtJ = new NPCPSelWrtJ();
        String string = this.getName();
        nPCPSelWrtJ.setWriter(string);
        NPCPAttribute nPCPAttribute = new NPCPAttribute();
        NPCPIDWriter nPCPIDWriter = new NPCPIDWriter();
        nPDataStream.setAction(22);
        nPDataStream.addCodePoint(nPCPSelWrtJ);
        nPDataStream.addCodePoint(nPCPAttributeIDList);
        nPDataStream2.addCodePoint(nPCPAttribute);
        nPDataStream2.addCodePoint(nPCPIDWriter);
        int n = nPSystem.makeRequest(nPDataStream, nPDataStream2);
        switch (n) {
            case 0: {
                if (this.attrs != null) {
                    this.attrs.addUpdateAttributes(nPCPAttribute);
                    break;
                }
                this.attrs = nPCPAttribute;
                break;
            }
            case 20: {
                Trace.log(2, "Writer Job " + string + " not active");
                throw new ErrorCompletingRequestException(13, string);
            }
            default: {
                Trace.log(2, "NetPrint DataStream RC = " + n);
                throw new ErrorCompletingRequestException(1);
            }
        }
    }
}

