/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Trace;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;

class SystemProperties {
    private static final String ACCESS_PREFIX = "com.ibm.as400.access.";
    private static final String PROPERTIES_CLASS_NAME = "com.ibm.as400.access.Properties";
    private static final String PROPERTIES_FILE_NAME = "com.ibm.as400.access.jt400.properties";
    private static final String PROPERTIES_FILE_NAME_WITH_SLASHES = "com/ibm/as400/access/jt400.properties";
    public static final String AS400_PROXY_SERVER = "com.ibm.as400.access.AS400.proxyServer";
    public static final String SECUREAS400_PROXY_ENCRYPTION_MODE = "com.ibm.as400.access.SecureAS400.proxyEncryptionMode";
    public static final String SECUREAS400_USE_SSLIGHT = "com.ibm.as400.access.SecureAS400.useSslight";
    public static final String TRACE_CATEGORY = "com.ibm.as400.access.Trace.category";
    public static final String TRACE_FILE = "com.ibm.as400.access.Trace.file";
    public static final String TRACE_JDBC_SERVER = "com.ibm.as400.access.ServerTrace.JDBC";
    public static final String TRACE_ENABLED = "com.ibm.as400.access.Trace.enabled";
    public static final String COMMANDCALL_THREADSAFE = "com.ibm.as400.access.CommandCall.threadSafe";
    public static final String PROGRAMCALL_THREADSAFE = "com.ibm.as400.access.ProgramCall.threadSafe";
    public static final String TUNNELPROXYSERVER_CLIENTCLEANUPINTERVAL = "com.ibm.as400.access.TunnelProxyServer.clientCleanupInterval";
    public static final String TUNNELPROXYSERVER_CLIENTLIFETIME = "com.ibm.as400.access.TunnelProxyServer.clientLifetime";
    public static final String FTP_REUSE_SOCKET = "com.ibm.as400.access.FTP.reuseSocket";
    public static final String AS400_SIGNON_HANDLER = "com.ibm.as400.access.AS400.signonHandler";
    public static final String JDBC_STATEMENT_LISTENERS = "com.ibm.as400.access.JDBC.statementListeners";
    private static Vector ignored_ = new Vector();
    private static Properties propertiesFromClass_ = null;
    private static Properties propertiesFromFile_ = null;
    private static boolean propertiesClassLoadFailed_ = false;
    private static boolean propertiesFileLoadFailed_ = false;
    private static boolean systemPropertiesLoadFailed_ = false;
    static /* synthetic */ Class class$com$ibm$as400$access$SystemProperties;

    private SystemProperties() {
    }

    static String getProperty(String string) {
        String string2;
        block16: {
            if (Trace.isTraceOn()) {
                Trace.log(1, "Getting system property: '" + string + "'");
            }
            string2 = null;
            if (ignored_.contains(string)) {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "System property on ignore list, value remains null.");
                }
                return null;
            }
            if (!systemPropertiesLoadFailed_) {
                try {
                    string2 = System.getProperty(string);
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "Value found in system properties:  '" + string2 + "'");
                    }
                }
                catch (SecurityException securityException) {
                    systemPropertiesLoadFailed_ = true;
                    if (!Trace.isTraceErrorOn()) break block16;
                    Trace.log(2, "Browser security exception:", (Throwable)securityException);
                }
            }
        }
        if (string2 == null) {
            if (propertiesFromClass_ == null && !propertiesClassLoadFailed_) {
                SystemProperties.loadPropertiesFromClass();
            }
            if (propertiesFromClass_ != null) {
                string2 = propertiesFromClass_.getProperty(string);
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Value found in Properties class: '" + string2 + "'");
                }
            }
        }
        if (string2 == null) {
            if (propertiesFromFile_ == null && !propertiesFileLoadFailed_) {
                SystemProperties.loadPropertiesFromFile();
            }
            if (propertiesFromFile_ != null) {
                string2 = propertiesFromFile_.getProperty(string);
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Value found in jt400.properties file: '" + string2 + "'");
                }
            }
        }
        if (Trace.isTraceOn() && string2 == null) {
            Trace.log(1, "Value not found.");
        }
        return string2;
    }

    static void ignoreProperty(String string) {
        if (Trace.isTraceOn()) {
            Trace.log(4, "Adding system property to ignore list: '" + string + "'");
        }
        ignored_.addElement(string);
    }

    private static void loadPropertiesFromClass() {
        block3: {
            if (Trace.isTraceOn()) {
                Trace.log(1, "Loading Properties class: 'com.ibm.as400.access.Properties'");
            }
            try {
                propertiesFromClass_ = (Properties)Class.forName(PROPERTIES_CLASS_NAME).newInstance();
            }
            catch (Throwable throwable) {
                propertiesClassLoadFailed_ = true;
                if (!Trace.isTraceWarningOn()) break block3;
                Trace.log(4, "Unable to load class: com.ibm.as400.access.Properties", throwable);
            }
        }
    }

    private static void loadPropertiesFromFile() {
        block8: {
            if (Trace.isTraceOn()) {
                Trace.log(1, "Loading jt400.properties file: 'com.ibm.as400.access.jt400.properties'");
            }
            propertiesFromFile_ = new Properties();
            try {
                InputStream inputStream = (class$com$ibm$as400$access$SystemProperties == null ? (class$com$ibm$as400$access$SystemProperties = SystemProperties.class$("com.ibm.as400.access.SystemProperties")) : class$com$ibm$as400$access$SystemProperties).getResourceAsStream(PROPERTIES_FILE_NAME);
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Trying with Class.getResourceAsStream(): " + (inputStream != null));
                }
                if (inputStream == null) {
                    inputStream = ClassLoader.getSystemResourceAsStream(PROPERTIES_FILE_NAME_WITH_SLASHES);
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "Trying with ClassLoader.getSystemResourceAsStream(): " + (inputStream != null));
                    }
                }
                if (inputStream == null) {
                    propertiesFileLoadFailed_ = true;
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "Load of jt400.properties failed.");
                    }
                    return;
                }
                propertiesFromFile_.load(new BufferedInputStream(inputStream));
                inputStream.close();
            }
            catch (Exception exception) {
                propertiesFileLoadFailed_ = true;
                if (!Trace.isTraceWarningOn()) break block8;
                Trace.log(4, "Unable to load jt400.properties file: com.ibm.as400.access.jt400.properties", (Throwable)exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

