/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.PxRepSV;
import com.ibm.as400.access.PxReqSV;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.Verbose;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.SocketException;

class PSTunnelConnection {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private boolean closed_ = false;
    private long connectionId_;
    private PrintWriter trace_;

    public PSTunnelConnection(long l) {
        this.connectionId_ = l;
        if (Trace.isTraceProxyOn()) {
            this.trace_ = Trace.getPrintWriter();
            Trace.log(6, "Px server tunnel connection " + this + " opened.");
        }
    }

    public void close() {
        this.closed_ = true;
        if (Trace.isTraceProxyOn()) {
            Trace.log(6, "Px server tunnel connection " + this + " closed.");
        }
        Verbose.println(ResourceBundleLoader.getText("PROXY_CONNECTION_CLOSED", Long.toString(this.connectionId_)));
    }

    protected void finalize() throws Throwable {
        if (!this.closed_) {
            this.close();
        }
        super.finalize();
    }

    private void handleIOException(IOException iOException) {
        if (Trace.isTraceErrorOn() && (!(iOException instanceof SocketException) && !(iOException instanceof EOFException) || iOException.getMessage() != null && iOException.getMessage().indexOf("JVM_recv") < 0)) {
            Trace.log(2, "IOException in PSConnection", (Throwable)iOException);
        }
        if (!this.closed_) {
            this.close();
        }
    }

    public void runRequest(PxReqSV pxReqSV, OutputStream outputStream) {
        PxRepSV pxRepSV = pxReqSV.process();
        if (pxRepSV != null) {
            pxRepSV.setCorrelationId(pxReqSV.getCorrelationId());
            pxRepSV.setClientId(pxReqSV.getClientId());
            this.sendTunneling(pxRepSV, outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTunneling(PxRepSV pxRepSV, OutputStream outputStream) {
        block6: {
            try {
                if (pxRepSV == null) break block6;
                OutputStream outputStream2 = outputStream;
                synchronized (outputStream2) {
                    if (Trace.isTraceProxyOn()) {
                        pxRepSV.dump(this.trace_);
                    }
                    pxRepSV.writeTo(outputStream);
                    outputStream.flush();
                }
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
            }
        }
    }
}

