/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDOutQ;
import com.ibm.as400.access.OutputQueueEvent;
import com.ibm.as400.access.OutputQueueImpl;
import com.ibm.as400.access.OutputQueueListener;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class OutputQueue
extends PrintObject
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String PATH = "path";
    private transient Vector outputQueueListeners_ = new Vector();

    OutputQueue(AS400 aS400, NPCPIDOutQ nPCPIDOutQ, NPCPAttribute nPCPAttribute) {
        super(aS400, nPCPIDOutQ, nPCPAttribute, 4);
    }

    public OutputQueue() {
        super(null, null, 4);
    }

    public OutputQueue(AS400 aS400, String string) {
        super(aS400, OutputQueue.buildIDCodePoint(string), null, 4);
    }

    public void addOutputQueueListener(OutputQueueListener outputQueueListener) {
        this.outputQueueListeners_.addElement(outputQueueListener);
    }

    private static NPCPIDOutQ buildIDCodePoint(String string) {
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "OUTQ");
        return new NPCPIDOutQ(qSYSObjectPathName.getObjectName(), qSYSObjectPathName.getLibraryName());
    }

    void checkRunTimeState() {
        super.checkRunTimeState();
        if (this.getIDCodePoint() == null) {
            Trace.log(2, "Parameter 'path' has not been set.");
            throw new ExtendedIllegalStateException(PATH, 4);
        }
    }

    void chooseImpl() throws IOException, AS400SecurityException {
        AS400 aS400 = this.getSystem();
        if (aS400 == null) {
            Trace.log(2, "Attempt to use OutputQueue before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (OutputQueueImpl)aS400.loadImpl2("com.ibm.as400.access.OutputQueueImplRemote", "com.ibm.as400.access.OutputQueueImplProxy");
        super.setImpl();
    }

    public void clear(PrintParameterList printParameterList) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.checkRunTimeState();
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((OutputQueueImpl)this.impl_).clear(printParameterList);
        this.attrs = this.impl_.getAttrValue();
        this.fireOutputQueueEvent(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOutputQueueEvent(int n) {
        Vector vector;
        if (this.outputQueueListeners_.isEmpty()) {
            return;
        }
        OutputQueueEvent outputQueueEvent = new OutputQueueEvent(this, n);
        OutputQueue outputQueue = this;
        synchronized (outputQueue) {
            vector = (Vector)this.outputQueueListeners_.clone();
        }
        block8: for (int i = 0; i < vector.size(); ++i) {
            switch (n) {
                case 1: {
                    ((OutputQueueListener)vector.elementAt(i)).outputQueueCleared(outputQueueEvent);
                    continue block8;
                }
                case 2: {
                    ((OutputQueueListener)vector.elementAt(i)).outputQueueHeld(outputQueueEvent);
                    continue block8;
                }
                case 3: {
                    ((OutputQueueListener)vector.elementAt(i)).outputQueueReleased(outputQueueEvent);
                }
            }
        }
    }

    public String getName() {
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return "";
        }
        return nPCPID.getStringValue(74);
    }

    public String getPath() {
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return "";
        }
        return QSYSObjectPathName.toPath(nPCPID.getStringValue(73), nPCPID.getStringValue(74), "OUTQ");
    }

    public void hold() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.checkRunTimeState();
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((OutputQueueImpl)this.impl_).hold();
        this.attrs = this.impl_.getAttrValue();
        this.fireOutputQueueEvent(2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.outputQueueListeners_ = new Vector();
    }

    public void release() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.checkRunTimeState();
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        ((OutputQueueImpl)this.impl_).release();
        this.attrs = this.impl_.getAttrValue();
        this.fireOutputQueueEvent(3);
    }

    public void removeOutputQueueListener(OutputQueueListener outputQueueListener) {
        this.outputQueueListeners_.removeElement(outputQueueListener);
    }

    public void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'path' is null");
            throw new NullPointerException(PATH);
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'Path' after connect.");
            throw new ExtendedIllegalStateException(PATH, 5);
        }
        String string2 = this.getPath();
        this.vetos.fireVetoableChange(PATH, string2, string);
        this.setIDCodePoint(OutputQueue.buildIDCodePoint(string));
        this.changes.firePropertyChange(PATH, string2, string);
    }
}

