/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.JobCCSIDNative;
import com.ibm.as400.access.Trace;
import java.io.IOException;

public class JobCCSID {
    private AS400 system_ = null;
    private int ccsid_ = -1;

    public JobCCSID() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing JobCCSID object.");
        }
    }

    public JobCCSID(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing JobCCSID object, system: " + aS400);
        }
        this.system_ = aS400;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public int retrieveCcsid() throws AS400SecurityException, ErrorCompletingRequestException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving CCSID.");
        }
        if (this.ccsid_ == -1) {
            if (Trace.traceOn_) {
                Trace.log(1, "Retrieving CCSID from server...");
            }
            if (this.system_ == null) {
                try {
                    this.ccsid_ = JobCCSIDNative.retrieveCcsid();
                }
                catch (Throwable throwable) {
                    Trace.log(2, "Attempt to connect to server before setting system.");
                    throw new ExtendedIllegalStateException("system", 4);
                }
            } else {
                this.ccsid_ = this.system_.getJobCcsid();
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "CCSID:", this.ccsid_);
        }
        return this.ccsid_;
    }

    public void setSystem(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + aS400);
        }
        if (this.ccsid_ != -1) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        this.system_ = aS400;
    }
}

