/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.JDSQLToken;
import com.ibm.as400.access.JDSQLTokenList;
import java.util.Enumeration;
import java.util.NoSuchElementException;

class JDSQLTokenizer
implements Enumeration {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    public static final String DEFAULT_DELIMITERS = " \t\n\r\f";
    private static final char[] INTERNAL_DELIMITERS = " \t\n\r\f".toCharArray();
    private static final int TOKEN_TYPE_DELIMITER = 1;
    private static final int TOKEN_TYPE_COMMENT = 2;
    private static final int TOKEN_TYPE_LITERAL = 4;
    private static final int TOKEN_TYPE_SQL = 8;
    private JDSQLToken[] tokens_;
    private int numberOfParameters_;
    private int currentTokenIndex_;

    public JDSQLTokenizer(String string) {
        this(string, DEFAULT_DELIMITERS, true, true);
    }

    public JDSQLTokenizer(String string, String string2) {
        this(string, string2, true, true);
    }

    public JDSQLTokenizer(String string, String string2, boolean bl, boolean bl2) {
        char[] cArray = string2 == DEFAULT_DELIMITERS ? INTERNAL_DELIMITERS : string2.toCharArray();
        this.tokens_ = JDSQLTokenizer.scanForTokens(string, cArray, bl2, bl);
        this.numberOfParameters_ = 0;
        for (int i = 0; i < this.tokens_.length; ++i) {
            this.numberOfParameters_ += this.tokens_[i].parms_;
        }
        this.currentTokenIndex_ = 0;
    }

    public int countTokens() {
        return this.tokens_.length;
    }

    public int getNumberOfParameters() {
        return this.numberOfParameters_;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        return this.currentTokenIndex_ < this.tokens_.length;
    }

    private static final boolean isDelimiter(char c, char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            return true;
        }
        return false;
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException();
        }
        return this.tokens_[this.currentTokenIndex_++].getToken();
    }

    public String peekToken() {
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException();
        }
        return this.tokens_[this.currentTokenIndex_].getToken();
    }

    private static final JDSQLToken[] scanForTokens(String string, char[] cArray, boolean bl, boolean bl2) {
        JDSQLTokenList jDSQLTokenList = new JDSQLTokenList();
        char[] cArray2 = string.toCharArray();
        int n = 0;
        int n2 = cArray2.length;
        while (n < n2) {
            int n3;
            int n4;
            int n5;
            int n6 = n + 1;
            JDSQLToken jDSQLToken = null;
            if (n6 < n2 && cArray2[n] == '/' && cArray2[n6] == '*') {
                n5 = n;
                n4 = 1;
                for (n = n6 + 1; n < n2 && n4 > 0; ++n) {
                    n3 = n + 1;
                    if (n3 >= n2) continue;
                    if (cArray2[n] == '/' && cArray2[n3] == '*') {
                        ++n4;
                        ++n;
                        continue;
                    }
                    if (cArray2[n] != '*' || cArray2[n3] != '/') continue;
                    --n4;
                    ++n;
                }
                if (bl) {
                    jDSQLToken = new JDSQLToken(cArray2, n5, n - n5, 2);
                }
            } else if (n6 < n2 && cArray2[n] == '-' && cArray2[n6] == '-') {
                n5 = n;
                n = n6 + 1;
                while (n < n2 && cArray2[n++] != '\n') {
                }
                if (bl) {
                    jDSQLToken = new JDSQLToken(cArray2, n5, n - n5, 2);
                }
            } else if (cArray2[n] == '\'') {
                n5 = n++;
                while (n < n2 && cArray2[n++] != '\'') {
                }
                jDSQLToken = new JDSQLToken(cArray2, n5, n - n5, 4);
            } else if (cArray2[n] == '\"') {
                n5 = n++;
                while (n < n2 && cArray2[n++] != '\"') {
                }
                jDSQLToken = new JDSQLToken(cArray2, n5, n - n5, 4);
            } else if (cArray2[n] == '(') {
                n5 = n++;
                jDSQLToken = new JDSQLToken(cArray2, n5, n - n5, 8);
            } else if (JDSQLTokenizer.isDelimiter(cArray2[n], cArray)) {
                if (bl2) {
                    jDSQLToken = new JDSQLToken(cArray2, n, 1, 1);
                }
                ++n;
            } else {
                n5 = 0;
                n4 = n;
                while (!(n >= n2 || JDSQLTokenizer.isDelimiter(cArray2[n], cArray) || cArray2[n] == '\'' || cArray2[n] == '\"' || (n3 = n + 1) < n2 && (cArray2[n] == '/' && cArray2[n3] == '*' || cArray2[n] == '-' && cArray2[n3] == '-'))) {
                    if (cArray2[n] == '?') {
                        ++n5;
                    }
                    ++n;
                }
                jDSQLToken = new JDSQLToken(cArray2, n4, n - n4, 8, n5);
            }
            if (jDSQLToken == null) continue;
            jDSQLTokenList.addToken(jDSQLToken);
        }
        JDSQLToken[] jDSQLTokenArray = new JDSQLToken[jDSQLTokenList.count_];
        System.arraycopy(jDSQLTokenList.tokens_, 0, jDSQLTokenArray, 0, jDSQLTokenList.count_);
        return jDSQLTokenArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.tokens_.length; ++i) {
            stringBuffer.append(this.tokens_[i].getToken());
        }
        return stringBuffer.toString();
    }
}

