/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ExtendedIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

class HexReaderInputStream
extends InputStream {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private Reader reader_;
    private boolean cached_ = false;
    private char cachedChar_;

    public HexReaderInputStream(Reader reader) {
        this.reader_ = reader;
    }

    public int available() throws IOException {
        if (this.cached_ && this.reader_.ready()) {
            return 1;
        }
        return 0;
    }

    public void close() throws IOException {
        this.reader_.close();
    }

    public synchronized int read() throws IOException {
        if (this.cached_) {
            this.cached_ = false;
            char c = (char)this.reader_.read();
            if (c == '\uffffffff') {
                return -1;
            }
            try {
                return BinaryConverter.charsToByte(this.cachedChar_, c);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ExtendedIOException(21);
            }
        }
        char c = (char)this.reader_.read();
        if (c == '\uffffffff') {
            return -1;
        }
        char c2 = (char)this.reader_.read();
        if (c2 == '\uffffffff') {
            return -1;
        }
        try {
            return BinaryConverter.charsToByte(c, c2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExtendedIOException(21);
        }
    }

    public synchronized int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("b");
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.cached_) {
            this.cached_ = false;
            char c = (char)this.reader_.read();
            if (c == '\uffffffff') {
                return -1;
            }
            try {
                byArray[n] = BinaryConverter.charsToByte(this.cachedChar_, c);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ExtendedIOException(21);
            }
            return 1;
        }
        char[] cArray = new char[n2 * 2];
        int n3 = this.reader_.read(cArray);
        if (n3 % 2 == 1) {
            this.cached_ = true;
            this.cachedChar_ = cArray[n3 - 1];
            --n3;
        }
        try {
            return BinaryConverter.stringToBytes(cArray, 0, n3, byArray, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExtendedIOException(21);
        }
    }

    public synchronized long skip(long l) throws IOException {
        if (l == 0L) {
            return 0L;
        }
        if (this.cached_) {
            this.cached_ = false;
        }
        long l2 = this.reader_.skip(l * 2L);
        return l2 / 2L;
    }
}

