/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableInputStream;
import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.Trace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

class ConvTableJavaMap
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    InputStreamReader reader_;
    OutputStreamWriter writer_;
    ByteArrayOutputStream outBuffer_;
    ConvTableInputStream inBuffer_;

    ConvTableJavaMap(String string) throws UnsupportedEncodingException {
        super(0);
        this.encoding_ = string;
        String string2 = ConversionMaps.encodingToCcsidString(string);
        try {
            this.ccsid_ = new Integer(string2);
        }
        catch (Exception exception) {
            if (Trace.traceOn_) {
                Trace.log(5, "No associated CCSID for encoding '" + string + "'. Lookup returned " + string2 + ".");
            }
            this.ccsid_ = 0;
        }
        this.inBuffer_ = new ConvTableInputStream();
        this.outBuffer_ = new ByteArrayOutputStream();
        this.writer_ = new OutputStreamWriter((OutputStream)this.outBuffer_, this.encoding_);
        this.reader_ = new InputStreamReader((InputStream)this.inBuffer_, this.encoding_);
        if (Trace.traceOn_) {
            Trace.log(5, "Successfully loaded Java map for encoding: " + this.encoding_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String byteArrayToString(byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) {
        if (Trace.traceOn_) {
            Trace.log(5, "Converting byte array to string for encoding: " + this.encoding_, byArray, n, n2);
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        ConvTableInputStream convTableInputStream = this.inBuffer_;
        synchronized (convTableInputStream) {
            block8: {
                this.inBuffer_.setContents(byArray, n, n2);
                try {
                    if (this.reader_ == null) {
                        this.reader_ = new InputStreamReader((InputStream)this.inBuffer_, this.encoding_);
                    }
                    n3 = this.reader_.read(cArray);
                }
                catch (IOException iOException) {
                    if (!Trace.traceOn_) break block8;
                    Trace.log(2, "IOException occurred on byteArrayToString for encoding " + this.encoding_, (Throwable)iOException);
                }
            }
            this.reader_ = null;
        }
        if (Trace.traceOn_) {
            Trace.log(5, "Destination string for encoding: " + this.encoding_ + " (" + n3 + ")", ConvTable.dumpCharArray(cArray));
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final byte[] stringToByteArray(String string, BidiConversionProperties bidiConversionProperties) {
        if (Trace.traceOn_) {
            Trace.log(5, "Converting string to byte array for encoding: " + this.encoding_, ConvTable.dumpCharArray(string.toCharArray()));
        }
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = this.outBuffer_;
        synchronized (byteArrayOutputStream) {
            block8: {
                try {
                    this.outBuffer_.reset();
                    if (this.writer_ == null) {
                        this.writer_ = new OutputStreamWriter((OutputStream)this.outBuffer_, this.encoding_);
                    }
                    this.writer_.write(string);
                    this.writer_.flush();
                }
                catch (IOException iOException) {
                    if (!Trace.traceOn_) break block8;
                    Trace.log(2, "IOException occurred on stringToByteArray for encoding " + this.encoding_, (Throwable)iOException);
                }
            }
            this.writer_ = null;
        }
        byArray = this.outBuffer_.toByteArray();
        if (Trace.traceOn_) {
            Trace.log(5, "Destination byte array for encoding: " + this.encoding_, byArray);
        }
        return byArray;
    }
}

