/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DDMACCSECReplyDataStream;
import com.ibm.as400.access.DDMACCSECRequestDataStream;
import com.ibm.as400.access.DDMASPReplyDataStream;
import com.ibm.as400.access.DDMASPRequestDataStream;
import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.DDMEXCSATReplyDataStream;
import com.ibm.as400.access.DDMEXCSATRequestDataStream;
import com.ibm.as400.access.DDMSECCHKReplyDataStream;
import com.ibm.as400.access.DDMSECCHKRequestDataStream;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

class ClassDecoupler {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";

    ClassDecoupler() {
    }

    static void freeDBReplyStream(DataStream dataStream) {
        if (dataStream instanceof DBReplyRequestedDS) {
            ((DBReplyRequestedDS)dataStream).inUse_ = false;
        }
    }

    static Object[] connectDDMPhase1(OutputStream outputStream, InputStream inputStream, boolean bl, int n) throws ServerStartupException, IOException {
        DDMEXCSATRequestDataStream dDMEXCSATRequestDataStream = new DDMEXCSATRequestDataStream();
        dDMEXCSATRequestDataStream.write(outputStream);
        DDMEXCSATReplyDataStream dDMEXCSATReplyDataStream = new DDMEXCSATReplyDataStream();
        dDMEXCSATReplyDataStream.read(inputStream);
        if (!dDMEXCSATReplyDataStream.checkReply()) {
            throw new ServerStartupException(1);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "DDM EXCSAT successful.");
        }
        DDMACCSECRequestDataStream dDMACCSECRequestDataStream = new DDMACCSECRequestDataStream(bl, n, null);
        dDMACCSECRequestDataStream.write(outputStream);
        DDMACCSECReplyDataStream dDMACCSECReplyDataStream = new DDMACCSECReplyDataStream();
        dDMACCSECReplyDataStream.read(inputStream);
        if (!dDMACCSECReplyDataStream.checkReply(n)) {
            throw new ServerStartupException(1);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "DDM ACCSEC successful.");
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (n == 0) {
            byArray = dDMACCSECRequestDataStream.getClientSeed();
            byArray2 = dDMACCSECReplyDataStream.getServerSeed();
        }
        return new Object[]{byArray, byArray2};
    }

    static void connectDDMPhase2(OutputStream outputStream, InputStream inputStream, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, String string, String string2) throws ServerStartupException, IOException {
        DDMSECCHKRequestDataStream dDMSECCHKRequestDataStream = new DDMSECCHKRequestDataStream(byArray, byArray2, byArray3, n);
        dDMSECCHKRequestDataStream.write(outputStream);
        DDMSECCHKReplyDataStream dDMSECCHKReplyDataStream = new DDMSECCHKReplyDataStream();
        dDMSECCHKReplyDataStream.read(inputStream);
        if (!dDMSECCHKReplyDataStream.checkReply()) {
            throw new ServerStartupException(1);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "DDM SECCHK successful.");
        }
        if (byArray3 != null) {
            DDMASPRequestDataStream dDMASPRequestDataStream = new DDMASPRequestDataStream(byArray3);
            dDMASPRequestDataStream.write(outputStream);
            DDMASPReplyDataStream dDMASPReplyDataStream = new DDMASPReplyDataStream();
            dDMASPReplyDataStream.read(inputStream);
            if (!dDMASPReplyDataStream.checkReply()) {
                if (Trace.traceOn_) {
                    Trace.log(2, "RDB name '" + string + "' is not a valid IASP name on system '" + string2 + "'.");
                }
                throw new ServerStartupException(1);
            }
            if (Trace.traceOn_) {
                Trace.log(1, "DDM RDB name '" + string + "' verified.");
            }
        }
    }

    static DataStream constructDDMDataStream(InputStream inputStream, Hashtable hashtable, AS400ImplRemote aS400ImplRemote) throws IOException {
        return DDMDataStream.construct(inputStream, hashtable, aS400ImplRemote);
    }
}

