/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ArabicOption;

class ArabicOptionSet {
    static final int LAMALEF_MASK = 0xF000000;
    static final int ILAMALEF_AUTO = 0x1000000;
    static final int ILAMALEF_NEAR = 0x3000000;
    static final int ILAMALEF_ATBEGIN = 0x5000000;
    static final int ILAMALEF_ATEND = 0x7000000;
    static final int ILAMALEF_RESIZE_BUFFER = 0x9000000;
    static final int SEEN_MASK = 0x700000;
    static final int ISEEN_AUTO = 0x100000;
    static final int ISEEN_ATBEGIN = 0x300000;
    static final int ISEEN_ATEND = 0x500000;
    static final int ISEEN_NEAR = 0x700000;
    static final int YEHHAMZA_MASK = 983040;
    static final int IYEHHAMZA_AUTO = 65536;
    static final int IYEHHAMZA_TWO_CELL_ATBEGIN = 196608;
    static final int IYEHHAMZA_TWO_CELL_ATEND = 327680;
    static final int IYEHHAMZA_TWO_CELL_NEAR = 458752;
    static final int IYEHHAMZA_ONE_CELL = 589824;
    static final int TASHKEEL_MASK = 3840;
    static final int ITASHKEEL_AUTO = 256;
    static final int ITASHKEEL_CUSTOMIZED_WITHZEROWIDTH = 768;
    static final int ITASHKEEL_CUSTOMIZED_WITHWIDTH = 1280;
    static final int ITASHKEEL_CUSTOMIZED_ATBEGIN = 1792;
    static final int ITASHKEEL_CUSTOMIZED_ATEND = 2304;
    static final int ITASHKEEL_KEEP = 2816;
    static final int DEFAULT = 0x1110100;
    int value;

    public ArabicOptionSet() {
        this.value = 0x1110100;
    }

    public ArabicOptionSet(ArabicOptionSet arabicOptionSet) {
        this.value = arabicOptionSet.value;
    }

    public ArabicOptionSet(ArabicOption arabicOption) {
        this.value = arabicOption.value | 0x1110100;
    }

    public ArabicOptionSet(ArabicOption arabicOption, ArabicOption arabicOption2) {
        this.value = arabicOption.value;
        if ((this.value & arabicOption2.value) != 0) {
            throw new IllegalArgumentException();
        }
        this.value |= arabicOption2.value | 0x1110100;
    }

    public ArabicOptionSet(ArabicOption arabicOption, ArabicOption arabicOption2, ArabicOption arabicOption3) {
        this.value = arabicOption.value;
        if ((this.value & arabicOption2.value) != 0) {
            throw new IllegalArgumentException();
        }
        this.value |= arabicOption2.value;
        if ((this.value & arabicOption3.value) != 0) {
            throw new IllegalArgumentException();
        }
        this.value |= arabicOption3.value | 0x1110100;
    }

    public ArabicOptionSet(ArabicOption arabicOption, ArabicOption arabicOption2, ArabicOption arabicOption3, ArabicOption arabicOption4) {
        this.value = arabicOption.value;
        if ((this.value & arabicOption2.value) != 0) {
            throw new IllegalArgumentException();
        }
        this.value |= arabicOption2.value;
        if ((this.value & arabicOption3.value) != 0) {
            throw new IllegalArgumentException();
        }
        this.value |= arabicOption3.value;
        if ((this.value & arabicOption4.value) != 0) {
            throw new IllegalArgumentException();
        }
        this.value |= arabicOption4.value;
    }

    public ArabicOptionSet(char[] cArray) {
        int n = 0x1110100;
        int n2 = cArray.length;
        if (n2 > 6) {
            if ('R' == cArray[6]) {
                n = n & 0xF0FFFFFF | 0x9000000;
            } else if ('N' == cArray[6]) {
                n = n & 0xF0FFFFFF | 0x3000000;
            } else if ('B' == cArray[6]) {
                n = n & 0xF0FFFFFF | 0x5000000;
            } else if ('E' == cArray[6]) {
                n = n & 0xF0FFFFFF | 0x7000000;
            } else if ('A' == cArray[6]) {
                n = n & 0xF0FFFFFF | 0x1000000;
            }
            if (n2 > 7) {
                if ('N' == cArray[7]) {
                    n = n & 0xFF8FFFFF | 0x700000;
                } else if ('B' == cArray[7]) {
                    n = n & 0xFF8FFFFF | 0x300000;
                } else if ('E' == cArray[7]) {
                    n = n & 0xFF8FFFFF | 0x500000;
                } else if ('A' == cArray[7]) {
                    n = n & 0xFF8FFFFF | 0x100000;
                }
                if (n2 > 8) {
                    if ('O' == cArray[8]) {
                        n = n & 0xFFF0FFFF | 0x90000;
                    } else if ('N' == cArray[8]) {
                        n = n & 0xFFF0FFFF | 0x70000;
                    } else if ('B' == cArray[8]) {
                        n = n & 0xFFF0FFFF | 0x30000;
                    } else if ('E' == cArray[8]) {
                        n = n & 0xFFF0FFFF | 0x50000;
                    } else if ('A' == cArray[8]) {
                        n = n & 0xFFF0FFFF | 0x10000;
                    }
                    if (n2 > 9) {
                        if ('K' == cArray[9]) {
                            n = n & 0xFFFFF0FF | 0xB00;
                        } else if ('Z' == cArray[9]) {
                            n = n & 0xFFFFF0FF | 0x300;
                        } else if ('W' == cArray[9]) {
                            n = n & 0xFFFFF0FF | 0x500;
                        } else if ('B' == cArray[9]) {
                            n = n & 0xFFFFF0FF | 0x700;
                        } else if ('E' == cArray[9]) {
                            n = n & 0xFFFFF0FF | 0x900;
                        } else if ('A' == cArray[9]) {
                            n = n & 0xFFFFF0FF | 0x100;
                        }
                    }
                }
            }
        }
        this.value = n;
    }

    public boolean equals(ArabicOptionSet arabicOptionSet) {
        if (arabicOptionSet == null) {
            return false;
        }
        return this.value == arabicOptionSet.value;
    }

    public ArabicOption getLamAlefMode() {
        switch (this.value & 0xF000000) {
            case 0x9000000: {
                return ArabicOption.LAMALEF_RESIZE_BUFFER;
            }
            case 0x3000000: {
                return ArabicOption.LAMALEF_NEAR;
            }
            case 0x5000000: {
                return ArabicOption.LAMALEF_ATBEGIN;
            }
            case 0x7000000: {
                return ArabicOption.LAMALEF_ATEND;
            }
            case 0x1000000: {
                return ArabicOption.LAMALEF_AUTO;
            }
        }
        return ArabicOption.LAMALEF_ATBEGIN;
    }

    public ArabicOption getSeenMode() {
        switch (this.value & 0x700000) {
            case 0x700000: {
                return ArabicOption.SEEN_NEAR;
            }
            case 0x300000: {
                return ArabicOption.SEEN_ATBEGIN;
            }
            case 0x500000: {
                return ArabicOption.SEEN_ATEND;
            }
            case 0x100000: {
                return ArabicOption.SEEN_AUTO;
            }
        }
        return ArabicOption.SEEN_NEAR;
    }

    public ArabicOption getYehHamzaMode() {
        switch (this.value & 0xF0000) {
            case 458752: {
                return ArabicOption.YEHHAMZA_TWO_CELL_NEAR;
            }
            case 196608: {
                return ArabicOption.YEHHAMZA_TWO_CELL_ATBEGIN;
            }
            case 327680: {
                return ArabicOption.YEHHAMZA_TWO_CELL_ATEND;
            }
            case 589824: {
                return ArabicOption.YEHHAMZA_ONE_CELL;
            }
            case 65536: {
                return ArabicOption.YEHHAMZA_AUTO;
            }
        }
        return ArabicOption.YEHHAMZA_TWO_CELL_NEAR;
    }

    public ArabicOption getTashkeelMode() {
        switch (this.value & 0xF00) {
            case 2816: {
                return ArabicOption.TASHKEEL_KEEP;
            }
            case 768: {
                return ArabicOption.TASHKEEL_CUSTOMIZED_WITHZEROWIDTH;
            }
            case 1280: {
                return ArabicOption.TASHKEEL_CUSTOMIZED_WITHWIDTH;
            }
            case 1792: {
                return ArabicOption.TASHKEEL_CUSTOMIZED_ATBEGIN;
            }
            case 2304: {
                return ArabicOption.TASHKEEL_CUSTOMIZED_ATEND;
            }
            case 256: {
                return ArabicOption.TASHKEEL_AUTO;
            }
        }
        return ArabicOption.TASHKEEL_KEEP;
    }

    public int hashCode() {
        return this.value;
    }

    public void setAllOptions(ArabicOptionSet arabicOptionSet) {
        this.value = arabicOptionSet.value;
    }

    public void setOneOption(ArabicOption arabicOption) {
        this.value = this.value & ~arabicOption.mask | arabicOption.value;
    }
}

