/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.flatpack.Parser;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.util.ParserUtils;
import net.sf.flatpack.xml.MetaData;
import net.sf.flatpack.xml.ResolveLocalDTD;
import net.sf.flatpack.xml.XMLRecordElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class MapParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapParser.class);
    private static final String COLUMN = "COLUMN";
    private static final String LENGTH = "length";
    private static boolean showDebug = false;

    private MapParser() {
    }

    public static Map<String, Object> parse(Reader xmlStreamReader, Parser pzparser) throws IOException, ParserConfigurationException, SAXException {
        if (xmlStreamReader == null) {
            throw new NullPointerException("XML Reader Is Not Allowed To Be Null...");
        }
        LinkedHashMap<String, Object> mdIndex = new LinkedHashMap<String, Object>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new ResolveLocalDTD());
        Document document = builder.parse(new InputSource(xmlStreamReader));
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        List<ColumnMetaData> columnResults = MapParser.parseColumnElements(nodeList);
        mdIndex.put("detail", columnResults);
        mdIndex.put("colIndex", ParserUtils.buidColumnIndexMap(columnResults, pzparser));
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (!"RECORD".equalsIgnoreCase(nodeName)) continue;
            NamedNodeMap attributes = node.getAttributes();
            Node id = attributes.getNamedItem("id");
            if (id != null && "detail".equalsIgnoreCase(id.getTextContent())) {
                throw new IllegalArgumentException("The ID 'detail' on the <RECORD> element is reserved, please select another id");
            }
            List<ColumnMetaData> columns = MapParser.parseColumnElements(node.getChildNodes());
            XMLRecordElement xmlre = new XMLRecordElement();
            xmlre.setColumns(columns, pzparser);
            xmlre.setIndicator(MapParser.getAttributeValue(attributes, "indicator"));
            xmlre.setElementNumber(MapParser.convertAttributeToInt(MapParser.getAttributeValue(attributes, "elementNumber")));
            xmlre.setStartPosition(MapParser.convertAttributeToInt(MapParser.getAttributeValue(attributes, "startPosition")));
            xmlre.setEndPositition(MapParser.convertAttributeToInt(MapParser.getAttributeValue(attributes, "endPosition")));
            xmlre.setElementCount(MapParser.convertAttributeToInt(MapParser.getAttributeValue(attributes, "elementCount")));
            mdIndex.put(MapParser.getAttributeValue(attributes, "id"), xmlre);
            mdIndex.put("colIndex_" + MapParser.getAttributeValue(attributes, "id"), ParserUtils.buidColumnIndexMap(columns, pzparser));
        }
        if (showDebug) {
            MapParser.setShowDebug(mdIndex);
        }
        return mdIndex;
    }

    private static String getAttributeValue(NamedNodeMap attributes, String attributeName) {
        Node namedItem = attributes.getNamedItem(attributeName);
        return namedItem != null ? namedItem.getTextContent() : null;
    }

    private static List<ColumnMetaData> parseColumnElements(NodeList nodeList) {
        HashSet<String> columnNames = new HashSet<String>();
        ArrayList<ColumnMetaData> columnResults = new ArrayList<ColumnMetaData>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (!COLUMN.equalsIgnoreCase(nodeName)) continue;
            NamedNodeMap attributes = node.getAttributes();
            ColumnMetaData cmd = new ColumnMetaData();
            String columnName = attributes.getNamedItem("name").getTextContent();
            if (columnName == null) {
                throw new IllegalArgumentException("Name attribute is required on the column tag!");
            }
            if (columnNames.contains(columnName)) {
                throw new IllegalArgumentException("Duplicate name column '" + columnName + "'");
            }
            cmd.setColName(columnName);
            columnNames.add(columnName);
            if (attributes.getNamedItem(LENGTH) != null) {
                try {
                    cmd.setColLength(Integer.parseInt(attributes.getNamedItem(LENGTH).getTextContent()));
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("LENGTH ATTRIBUTE ON COLUMN ELEMENT MUST BE AN INTEGER.  GOT: " + attributes.getNamedItem(LENGTH).getTextContent(), ex);
                }
            }
            columnResults.add(cmd);
        }
        return columnResults;
    }

    private static int convertAttributeToInt(String attribute) {
        if (attribute == null) {
            return 0;
        }
        try {
            return Integer.parseInt(attribute);
        }
        catch (Exception ignore) {
            return 0;
        }
    }

    public static void setDebug(boolean b) {
        showDebug = b;
    }

    private static void setShowDebug(Map<String, Object> xmlResults) {
        for (Map.Entry<String, Object> entry : xmlResults.entrySet()) {
            XMLRecordElement xmlrecEle = null;
            String recordID = entry.getKey();
            List<ColumnMetaData> columns = null;
            if (recordID.equals("detail")) {
                columns = (List<ColumnMetaData>)entry.getValue();
            } else {
                xmlrecEle = (XMLRecordElement)entry.getValue();
                columns = xmlrecEle.getColumns();
            }
            LOGGER.debug(">>>>Column MD Id:{}", (Object)recordID);
            if (xmlrecEle != null) {
                LOGGER.debug("Start Position: {} End Postion: {} Element Number: {} Indicator{}", new Object[]{xmlrecEle.getStartPosition(), xmlrecEle.getEndPositition(), xmlrecEle.getElementNumber(), xmlrecEle.getIndicator()});
            }
            for (ColumnMetaData cmd : columns) {
                LOGGER.debug("Column Name: {} LENGTH: {}", (Object)cmd.getColName(), (Object)cmd.getColLength());
            }
        }
    }

    public static MetaData parseMap(Reader xmlStreamReader, Parser pzparser) throws IOException, ParserConfigurationException, SAXException {
        Map<String, Object> map = MapParser.parse(xmlStreamReader, pzparser);
        List col = (List)map.get("detail");
        map.remove("detail");
        Map m = (Map)map.get("colIndex");
        map.remove("colIndex");
        Iterator<Map.Entry<String, Object>> entrySetIt = map.entrySet().iterator();
        while (entrySetIt.hasNext()) {
            Map.Entry<String, Object> e = entrySetIt.next();
            if (!e.getKey().startsWith("colIndex_")) continue;
            entrySetIt.remove();
        }
        return new MetaData(col, m, map);
    }
}

