/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.writer;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.writer.AbstractWriter;
import net.sf.flatpack.writer.Writer;

public class FixedLengthWriter
extends AbstractWriter {
    private static final int MAX_CHAR_TO_USE_LOOP = 8;
    private final Map<?, ?> columnMapping;
    private final char padChar;

    protected FixedLengthWriter(Map parsedMapping, java.io.Writer output, char padChar) {
        super(output);
        this.columnMapping = parsedMapping;
        this.padChar = padChar;
    }

    @Override
    public Writer addRecordEntry(String columnName, Object value) {
        if (value != null) {
            ColumnMetaData metaData = this.getColumnMetaData(columnName);
            String valueString = value.toString();
            if (valueString.length() > metaData.getColLength()) {
                throw new IllegalArgumentException(valueString + " exceeds the maximum length for column " + columnName + "(" + metaData.getColLength() + ")");
            }
        }
        return super.addRecordEntry(columnName, value);
    }

    @Override
    public Writer nextRecord() throws IOException {
        for (ColumnMetaData element : this.getColumnMetaData()) {
            Object value = this.getRowMap().get(element.getColName());
            this.write(this.formattedValue(value, element));
        }
        return super.nextRecord();
    }

    protected char[] formattedValue(Object val, ColumnMetaData element) {
        BigDecimal bd;
        Object value;
        Object object = value = val == null ? "" : val;
        String stringValue = value instanceof BigDecimal ? ((bd = (BigDecimal)value).signum() == 0 ? "0" : bd.toPlainString()) : value.toString();
        int stringLength = stringValue.length();
        int columnLength = element.getColLength();
        char[] formattedValue = new char[columnLength];
        int numCharacters = Math.min(stringLength, columnLength);
        if (numCharacters < 8) {
            for (int i = 0; i < numCharacters; ++i) {
                formattedValue[i] = stringValue.charAt(i);
            }
        } else {
            stringValue.getChars(0, numCharacters, formattedValue, 0);
        }
        if (stringLength < columnLength) {
            Arrays.fill(formattedValue, stringLength, columnLength, this.padChar);
        }
        return formattedValue;
    }

    @Override
    protected boolean validateColumnTitle(String columnTitle) {
        Map columnNameToIndex = (Map)this.columnMapping.get("colIndex");
        return columnNameToIndex.keySet().contains(columnTitle);
    }

    @Override
    public Writer printFooter() {
        return this;
    }

    @Override
    public Writer printHeader() {
        return this;
    }

    private List<ColumnMetaData> getColumnMetaData() {
        return (List)this.columnMapping.get("detail");
    }

    private ColumnMetaData getColumnMetaData(String columnName) {
        for (ColumnMetaData element : this.getColumnMetaData()) {
            if (!element.getColName().equals(columnName)) continue;
            return element;
        }
        throw new IllegalArgumentException("Column \"" + columnName + "\" unknown");
    }
}

