/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.ordering;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import net.sf.flatpack.Parser;
import net.sf.flatpack.ordering.OrderColumn;
import net.sf.flatpack.structure.Row;
import net.sf.flatpack.util.ParserUtils;
import net.sf.flatpack.xml.MetaData;

public class OrderBy
implements Comparator<Row> {
    private final List<OrderColumn> orderbys = new ArrayList<OrderColumn>();
    private MetaData metaData;
    private Parser parser;

    public void addOrderColumn(OrderColumn oc) {
        this.orderbys.add(oc);
    }

    @Override
    public int compare(Row row0, Row row1) {
        int result = 0;
        for (int i = 0; i < this.orderbys.size(); ++i) {
            String mdkey1;
            OrderColumn oc = this.orderbys.get(i);
            String mdkey0 = row0.getMdkey() == null ? "detail" : row0.getMdkey();
            String string = mdkey1 = row1.getMdkey() == null ? "detail" : row1.getMdkey();
            if (!mdkey0.equals("detail") && !mdkey1.equals("detail")) {
                return 0;
            }
            if (!mdkey0.equals("detail") || !mdkey1.equals("detail")) {
                return !mdkey0.equals("detail") ? 1 : 0;
            }
            result = this.compareCol(row0, row1, oc);
            if (result != 0) break;
        }
        return result;
    }

    private int compareCol(Row row0, Row row1, OrderColumn oc) {
        Object comp0 = null;
        Object comp1 = null;
        String str0 = row0.getValue(ParserUtils.getColumnIndex(row0.getMdkey(), this.metaData, oc.getColumnName(), this.parser.isColumnNamesCaseSensitive())).toLowerCase(Locale.getDefault());
        String str1 = row1.getValue(ParserUtils.getColumnIndex(row1.getMdkey(), this.metaData, oc.getColumnName(), this.parser.isColumnNamesCaseSensitive())).toLowerCase(Locale.getDefault());
        switch (oc.getSelectedColType()) {
            case 2: {
                comp0 = Double.valueOf(ParserUtils.stripNonDoubleChars(str0));
                comp1 = Double.valueOf(ParserUtils.stripNonDoubleChars(str1));
                break;
            }
            case 1: {
                SimpleDateFormat sdf = new SimpleDateFormat(oc.getDateFormatPattern());
                try {
                    comp0 = sdf.parse(str0);
                }
                catch (ParseException e) {
                    comp0 = this.getBadDateDefault();
                }
                try {
                    comp1 = sdf.parse(str1);
                }
                catch (ParseException e) {
                    comp1 = this.getBadDateDefault();
                }
                break;
            }
            default: {
                comp0 = str0;
                comp1 = str1;
            }
        }
        int result = comp0.compareTo(comp1) * oc.getSortIndicator();
        return result;
    }

    private Date getBadDateDefault() {
        GregorianCalendar defaultBadDt = new GregorianCalendar();
        defaultBadDt.set(2, 1);
        defaultBadDt.set(1, 1900);
        defaultBadDt.set(5, 1);
        return defaultBadDt.getTime();
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }
}

