/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import net.sf.flatpack.DBDelimiterParser;
import net.sf.flatpack.DBFixedLengthParser;
import net.sf.flatpack.DelimiterParser;
import net.sf.flatpack.FixedLengthParser;
import net.sf.flatpack.Parser;
import net.sf.flatpack.ParserFactory;

public class DefaultParserFactory
implements ParserFactory {
    private static final DefaultParserFactory INSTANCE = new DefaultParserFactory();

    public static ParserFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public Parser newFixedLengthParser(Connection con, File dataSource, String dataDefinition) {
        return new DBFixedLengthParser(con, dataSource, dataDefinition);
    }

    @Override
    public Parser newFixedLengthParser(Connection con, InputStream dataSourceStream, String dataDefinition) {
        return new DBFixedLengthParser(con, dataSourceStream, dataDefinition);
    }

    @Override
    public Parser newFixedLengthParser(File pzmapXML, File dataSource) {
        return new FixedLengthParser(pzmapXML, dataSource);
    }

    @Override
    public Parser newFixedLengthParser(InputStream pzmapXMLStream, InputStream dataSourceStream) {
        return new FixedLengthParser(pzmapXMLStream, dataSourceStream);
    }

    @Override
    public Parser newFixedLengthParser(Connection con, Reader dataSource, String dataDefinition) {
        return new DBFixedLengthParser(con, dataSource, dataDefinition);
    }

    @Override
    public Parser newFixedLengthParser(Reader pzmapXMLStream, Reader dataSource) {
        return new FixedLengthParser(pzmapXMLStream, dataSource);
    }

    @Override
    public Parser newDelimitedParser(Connection con, InputStream dataSourceStream, String dataDefinition, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        return new DBDelimiterParser(con, dataSourceStream, dataDefinition, delimiter, qualifier, ignoreFirstRecord);
    }

    @Override
    public Parser newDelimitedParser(File pzmapXML, File dataSource, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        return new DelimiterParser(pzmapXML, dataSource, delimiter, qualifier, ignoreFirstRecord);
    }

    @Override
    public Parser newDelimitedParser(InputStream pzmapXMLStream, InputStream dataSourceStream, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        return new DelimiterParser(pzmapXMLStream, dataSourceStream, delimiter, qualifier, ignoreFirstRecord);
    }

    @Override
    public Parser newDelimitedParser(File dataSource, char delimiter, char qualifier) {
        return new DelimiterParser(dataSource, delimiter, qualifier, false);
    }

    public static Parser newCsvParser(InputStream dataSourceStream) {
        return INSTANCE.newDelimitedParser(dataSourceStream, ',', '\"');
    }

    public static Parser newCsvParser(Reader dataSource) {
        return INSTANCE.newDelimitedParser(dataSource, ',', '\"');
    }

    @Override
    public Parser newDelimitedParser(InputStream dataSourceStream, char delimiter, char qualifier) {
        return new DelimiterParser(dataSourceStream, delimiter, qualifier, false);
    }

    @Override
    public Parser newDelimitedParser(Connection con, Reader dataSource, String dataDefinition, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        return new DBDelimiterParser(con, dataSource, dataDefinition, delimiter, qualifier, ignoreFirstRecord);
    }

    @Override
    public Parser newDelimitedParser(Reader dataSource, char delimiter, char qualifier) {
        return new DelimiterParser(dataSource, delimiter, qualifier, false);
    }

    @Override
    public Parser newDelimitedParser(Reader pzmapXML, Reader dataSource, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        return new DelimiterParser(dataSource, pzmapXML, delimiter, qualifier, ignoreFirstRecord);
    }
}

