/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import net.sf.flatpack.AbstractDelimiterParser;
import net.sf.flatpack.InitialisationException;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.util.ParserUtils;

public class DBDelimiterParser
extends AbstractDelimiterParser {
    private final Connection con;
    private InputStream dataSourceStream;

    public DBDelimiterParser(Connection con, InputStream dataSourceStream, String dataDefinition, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(null, dataDefinition, delimiter, qualifier, ignoreFirstRecord);
        this.con = con;
        this.dataSourceStream = dataSourceStream;
    }

    public DBDelimiterParser(Connection con, Reader dataSourceReader, String dataDefinition, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(dataSourceReader, dataDefinition, delimiter, qualifier, ignoreFirstRecord);
        this.con = con;
    }

    @Override
    protected void init() {
        try {
            if (this.dataSourceStream != null) {
                InputStreamReader r = new InputStreamReader(this.dataSourceStream);
                this.setDataSourceReader(r);
                this.addToCloseReaderList(r);
            }
            List<ColumnMetaData> cmds = ParserUtils.buildMDFromSQLTable(this.con, this.getDataDefinition(), this);
            this.addToMetaData(cmds);
            if (cmds.isEmpty()) {
                throw new FileNotFoundException("DATA DEFINITION CAN NOT BE FOUND IN THE DATABASE " + this.getDataDefinition());
            }
            this.setInitialised(true);
        }
        catch (FileNotFoundException | SQLException e) {
            throw new InitialisationException(e);
        }
    }

    @Override
    protected boolean shouldCreateMDFromFile() {
        return false;
    }
}

