/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.xquery.GroupSpec;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;

public class GroupedValueSequence
extends AbstractSequence {
    private Entry[] items = null;
    private int count = 0;
    private GroupSpec[] groupSpecs;
    private Sequence groupKey;
    private XQueryContext context;
    private int groupKeyLength;
    private int itemType = 12;

    public GroupedValueSequence(GroupSpec[] groupSpecs, int size, Sequence keySequence, XQueryContext aContext) {
        this.groupSpecs = groupSpecs;
        this.items = new Entry[size];
        this.groupKey = keySequence;
        this.context = aContext;
        this.groupKeyLength = this.groupKey.getItemCount();
    }

    public SequenceIterator iterate() throws XPathException {
        return new GroupedValueSequenceIterator();
    }

    public SequenceIterator unorderedIterator() {
        return new GroupedValueSequenceIterator();
    }

    public int getItemCount() {
        return this.items == null ? 0 : this.count;
    }

    public Sequence getGroupKey() {
        return this.groupKey;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean hasOne() {
        return this.hasOne;
    }

    public void add(Item item) throws XPathException {
        if (this.hasOne) {
            this.hasOne = false;
        }
        if (this.isEmpty) {
            this.hasOne = true;
        }
        this.isEmpty = false;
        if (this.count == this.items.length) {
            Entry[] newItems = new Entry[this.count * 2];
            System.arraycopy(this.items, 0, newItems, 0, this.count);
            this.items = newItems;
        }
        this.items[this.count++] = new Entry(item);
        this.checkItemType(item.getType());
    }

    public void addAll(Sequence other) throws XPathException {
        if (other.hasOne()) {
            this.add(other.itemAt(0));
        } else if (!other.isEmpty()) {
            SequenceIterator i = other.iterate();
            while (i.hasNext()) {
                Item next = i.nextItem();
                if (next == null) continue;
                this.add(next);
            }
        }
    }

    public Item itemAt(int pos) {
        if (this.items != null && pos > -1 && pos < this.count) {
            return this.items[pos].item;
        }
        return null;
    }

    private void checkItemType(int type) {
        if (this.itemType == -1 || this.itemType == type) {
            return;
        }
        this.itemType = this.itemType == 12 ? type : -1;
    }

    public int getItemType() {
        return this.itemType;
    }

    public NodeSet toNodeSet() throws XPathException {
        if (this.itemType != 12 && Type.subTypeOf(this.itemType, -1)) {
            ExtArrayNodeSet set = new ExtArrayNodeSet();
            for (int i = 0; i < this.count; ++i) {
                NodeValue v = null;
                Entry temp = this.items[i];
                v = (NodeValue)temp.item;
                if (v.getImplementationType() != 1) {
                    set.add((NodeProxy)v);
                    continue;
                }
                set.add((NodeProxy)v);
            }
            return set;
        }
        throw new XPathException("Type error: the sequence cannot be converted into a node set. Item type is " + Type.getTypeName(this.itemType));
    }

    public void removeDuplicates() {
    }

    private class GroupedValueSequenceIterator
    implements SequenceIterator {
        int pos = 0;

        private GroupedValueSequenceIterator() {
        }

        public boolean hasNext() {
            return this.pos < GroupedValueSequence.this.count;
        }

        public Item nextItem() {
            if (this.pos < GroupedValueSequence.this.count) {
                return ((GroupedValueSequence)GroupedValueSequence.this).items[this.pos++].item;
            }
            return null;
        }
    }

    private class Entry
    implements Comparable {
        Item item;
        AtomicValue[] values;

        public Entry(Item item) throws XPathException {
            this.item = item;
            this.values = new AtomicValue[GroupedValueSequence.this.groupSpecs.length];
            for (int i = 0; i < GroupedValueSequence.this.groupSpecs.length; ++i) {
                Sequence seq = GroupedValueSequence.this.groupSpecs[i].getGroupExpression().eval(null);
                this.values[i] = AtomicValue.EMPTY_VALUE;
                if (seq.hasOne()) {
                    this.values[i] = seq.itemAt(0).atomize();
                    continue;
                }
                if (!seq.hasMany()) continue;
                throw new XPathException("expected a single value for group by expression " + ExpressionDumper.dump(GroupedValueSequence.this.groupSpecs[i].getGroupExpression()) + " ; found: " + seq.getItemCount());
            }
        }

        public int compareTo(Object o) {
            Entry other = (Entry)o;
            int cmp = 0;
            for (int i = 0; i < this.values.length; ++i) {
                AtomicValue a = this.values[i];
                AtomicValue b = other.values[i];
                cmp = a == AtomicValue.EMPTY_VALUE && b != AtomicValue.EMPTY_VALUE ? 1 : a.compareTo(b);
            }
            return cmp;
        }
    }
}

